/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.requestcontroller.RequestController;

class MaxRequestsWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    private final AttributeDefinition attributeDefinition;

    MaxRequestsWriteHandler(AttributeDefinition attributeDefinition) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.apply(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.apply(context, restored);
    }

    private void apply(OperationContext context, ModelNode model) throws OperationFailedException {
        ServiceController serviceController = context.getServiceRegistry(false).getService(RequestController.SERVICE_NAME);
        if (serviceController == null) {
            return;
        }
        RequestController requestController = (RequestController)serviceController.getService().getValue();
        ModelNode modelNode = this.attributeDefinition.resolveModelAttribute(context, model);
        if (!modelNode.isDefined()) {
            requestController.setMaxRequestCount(-1);
        } else {
            requestController.setMaxRequestCount(modelNode.asInt());
        }
    }
}

