/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.keycloak.events.EventStoreProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.timer.ScheduledTask;

public class ClearExpiredEvents
implements ScheduledTask {
    public void run(KeycloakSession session) {
        EventStoreProvider eventStore = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
        if (eventStore != null) {
            for (RealmModel realm : session.realms().getRealms()) {
                if (!realm.isEventsEnabled() || realm.getEventsExpiration() <= 0L) continue;
                long olderThan = System.currentTimeMillis() - realm.getEventsExpiration() * 1000L;
                eventStore.clear(realm.getId(), olderThan);
            }
        }
    }
}

