/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowAcceptingSslChannel;
import io.undertow.protocols.ssl.UndertowSslConnection;
import io.undertow.server.DefaultByteBufferPool;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.JsseSslUtils;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.SslConnection;
import org.xnio.ssl.XnioSsl;

public class UndertowXnioSsl
extends XnioSsl {
    private static final ByteBufferPool DEFAULT_BUFFER_POOL = new DefaultByteBufferPool(true, 17408, -1, 12);
    private final ByteBufferPool bufferPool;
    private volatile SSLContext sslContext;

    public UndertowXnioSsl(Xnio xnio, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        this(xnio, optionMap, DEFAULT_BUFFER_POOL, JsseSslUtils.createSSLContext((OptionMap)optionMap));
    }

    public UndertowXnioSsl(Xnio xnio, OptionMap optionMap, SSLContext sslContext) {
        this(xnio, optionMap, DEFAULT_BUFFER_POOL, sslContext);
    }

    public UndertowXnioSsl(Xnio xnio, OptionMap optionMap, ByteBufferPool bufferPool) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        this(xnio, optionMap, bufferPool, JsseSslUtils.createSSLContext((OptionMap)optionMap));
    }

    public UndertowXnioSsl(Xnio xnio, OptionMap optionMap, ByteBufferPool bufferPool, SSLContext sslContext) {
        super(xnio, sslContext, optionMap);
        this.bufferPool = bufferPool;
        this.sslContext = sslContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public static SSLEngine getSslEngine(SslConnection connection) {
        if (connection instanceof UndertowSslConnection) {
            return ((UndertowSslConnection)connection).getSSLEngine();
        }
        return JsseXnioSsl.getSslEngine((SslConnection)connection);
    }

    public IoFuture<ConnectedSslStreamChannel> connectSsl(XnioWorker worker, InetSocketAddress bindAddress, InetSocketAddress destination, final ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        final FutureResult futureResult = new FutureResult(IoUtils.directExecutor());
        IoFuture futureSslConnection = this.openSslConnection(worker, bindAddress, destination, (ChannelListener<? super SslConnection>)new ChannelListener<SslConnection>(){

            public void handleEvent(SslConnection sslConnection) {
                AssembledConnectedSslStreamChannel assembledChannel = new AssembledConnectedSslStreamChannel((SslChannel)sslConnection, (StreamSourceChannel)sslConnection.getSourceChannel(), (StreamSinkChannel)sslConnection.getSinkChannel());
                if (!futureResult.setResult((Object)assembledChannel)) {
                    IoUtils.safeClose((Closeable)assembledChannel);
                } else {
                    ChannelListeners.invokeChannelListener((Channel)assembledChannel, (ChannelListener)openListener);
                }
            }
        }, bindListener, optionMap).addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<SslConnection, FutureResult<ConnectedSslStreamChannel>>(){

            public void handleCancelled(FutureResult<ConnectedSslStreamChannel> result) {
                result.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<ConnectedSslStreamChannel> result) {
                result.setException(exception);
            }
        }, (Object)futureResult);
        futureResult.getIoFuture().addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<ConnectedStreamChannel, IoFuture<SslConnection>>(){

            public void handleCancelled(IoFuture<SslConnection> result) {
                result.cancel();
            }
        }, (Object)futureSslConnection);
        futureResult.addCancelHandler((Cancellable)futureSslConnection);
        return futureResult.getIoFuture();
    }

    public IoFuture<SslConnection> openSslConnection(XnioWorker worker, InetSocketAddress bindAddress, InetSocketAddress destination, ChannelListener<? super SslConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult futureResult = new FutureResult((Executor)worker);
        IoFuture connection = worker.openStreamConnection((SocketAddress)bindAddress, (SocketAddress)destination, (ChannelListener)new StreamConnectionChannelListener(optionMap, destination, (FutureResult<SslConnection>)futureResult, openListener), bindListener, optionMap);
        return this.setupSslConnection((FutureResult<SslConnection>)futureResult, (IoFuture<StreamConnection>)connection);
    }

    public IoFuture<SslConnection> openSslConnection(XnioIoThread ioThread, InetSocketAddress bindAddress, InetSocketAddress destination, ChannelListener<? super SslConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult futureResult = new FutureResult((Executor)ioThread);
        IoFuture connection = ioThread.openStreamConnection((SocketAddress)bindAddress, (SocketAddress)destination, (ChannelListener)new StreamConnectionChannelListener(optionMap, destination, (FutureResult<SslConnection>)futureResult, openListener), bindListener, optionMap);
        return this.setupSslConnection((FutureResult<SslConnection>)futureResult, (IoFuture<StreamConnection>)connection);
    }

    public SslConnection wrapExistingConnection(StreamConnection connection, OptionMap optionMap) {
        return new UndertowSslConnection(connection, JsseSslUtils.createSSLEngine((SSLContext)this.sslContext, (OptionMap)optionMap, (InetSocketAddress)((InetSocketAddress)connection.getPeerAddress())), this.bufferPool);
    }

    private IoFuture<SslConnection> setupSslConnection(FutureResult<SslConnection> futureResult, IoFuture<StreamConnection> connection) {
        connection.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<StreamConnection, FutureResult<SslConnection>>(){

            public void handleCancelled(FutureResult<SslConnection> attachment) {
                attachment.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<SslConnection> attachment) {
                attachment.setException(exception);
            }
        }, futureResult);
        futureResult.addCancelHandler(connection);
        return futureResult.getIoFuture();
    }

    public AcceptingChannel<ConnectedSslStreamChannel> createSslTcpServer(XnioWorker worker, InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedSslStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        final AcceptingChannel<SslConnection> server = this.createSslConnectionServer(worker, bindAddress, null, optionMap);
        AcceptingChannel<ConnectedSslStreamChannel> acceptingChannel = new AcceptingChannel<ConnectedSslStreamChannel>(){

            public ConnectedSslStreamChannel accept() throws IOException {
                SslConnection connection = (SslConnection)server.accept();
                return connection == null ? null : new AssembledConnectedSslStreamChannel((SslChannel)connection, (StreamSourceChannel)connection.getSourceChannel(), (StreamSinkChannel)connection.getSinkChannel());
            }

            public ChannelListener.Setter<? extends AcceptingChannel<ConnectedSslStreamChannel>> getAcceptSetter() {
                return ChannelListeners.getDelegatingSetter((ChannelListener.Setter)server.getAcceptSetter(), (Channel)((Object)this));
            }

            public ChannelListener.Setter<? extends AcceptingChannel<ConnectedSslStreamChannel>> getCloseSetter() {
                return ChannelListeners.getDelegatingSetter((ChannelListener.Setter)server.getCloseSetter(), (Channel)((Object)this));
            }

            public SocketAddress getLocalAddress() {
                return server.getLocalAddress();
            }

            public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
                return (A)server.getLocalAddress(type);
            }

            public void suspendAccepts() {
                server.suspendAccepts();
            }

            public void resumeAccepts() {
                server.resumeAccepts();
            }

            public boolean isAcceptResumed() {
                return server.isAcceptResumed();
            }

            public void wakeupAccepts() {
                server.wakeupAccepts();
            }

            public void awaitAcceptable() throws IOException {
                server.awaitAcceptable();
            }

            public void awaitAcceptable(long time, TimeUnit timeUnit) throws IOException {
                server.awaitAcceptable(time, timeUnit);
            }

            public XnioWorker getWorker() {
                return server.getWorker();
            }

            @Deprecated
            public XnioExecutor getAcceptThread() {
                return server.getAcceptThread();
            }

            public XnioIoThread getIoThread() {
                return server.getIoThread();
            }

            public void close() throws IOException {
                server.close();
            }

            public boolean isOpen() {
                return server.isOpen();
            }

            public boolean supportsOption(Option<?> option) {
                return server.supportsOption(option);
            }

            public <T> T getOption(Option<T> option) throws IOException {
                return (T)server.getOption(option);
            }

            public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                return (T)server.setOption(option, value);
            }
        };
        acceptingChannel.getAcceptSetter().set(acceptListener);
        return acceptingChannel;
    }

    public void updateSSLContext(SSLContext context) {
        this.sslContext = context;
    }

    public AcceptingChannel<SslConnection> createSslConnectionServer(XnioWorker worker, InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<SslConnection>> acceptListener, OptionMap optionMap) throws IOException {
        UndertowAcceptingSslChannel server = new UndertowAcceptingSslChannel(this, (AcceptingChannel<? extends StreamConnection>)worker.createStreamConnectionServer((SocketAddress)bindAddress, null, optionMap), optionMap, this.bufferPool, false);
        if (acceptListener != null) {
            server.getAcceptSetter().set(acceptListener);
        }
        return server;
    }

    private class StreamConnectionChannelListener
    implements ChannelListener<StreamConnection> {
        private final OptionMap optionMap;
        private final InetSocketAddress destination;
        private final FutureResult<SslConnection> futureResult;
        private final ChannelListener<? super SslConnection> openListener;

        public StreamConnectionChannelListener(OptionMap optionMap, InetSocketAddress destination, FutureResult<SslConnection> futureResult, ChannelListener<? super SslConnection> openListener) {
            this.optionMap = optionMap;
            this.destination = destination;
            this.futureResult = futureResult;
            this.openListener = openListener;
        }

        public void handleEvent(StreamConnection connection) {
            UndertowSslConnection wrappedConnection = new UndertowSslConnection(connection, JsseSslUtils.createSSLEngine((SSLContext)UndertowXnioSsl.this.sslContext, (OptionMap)this.optionMap, (InetSocketAddress)this.destination), UndertowXnioSsl.this.bufferPool);
            if (!this.futureResult.setResult((Object)wrappedConnection)) {
                IoUtils.safeClose((Closeable)connection);
            } else {
                ChannelListeners.invokeChannelListener((Channel)((Object)wrappedConnection), this.openListener);
            }
        }
    }
}

