/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.w3c.dom.Document;

public class JaxrsSAML2BindingBuilder
extends BaseSAML2BindingBuilder<JaxrsSAML2BindingBuilder> {
    public RedirectBindingBuilder redirectBinding(Document document) throws ProcessingException {
        return new RedirectBindingBuilder(this, document);
    }

    public PostBindingBuilder postBinding(Document document) throws ProcessingException {
        return new PostBindingBuilder(this, document);
    }

    public static class RedirectBindingBuilder
    extends BaseSAML2BindingBuilder.BaseRedirectBindingBuilder {
        public RedirectBindingBuilder(JaxrsSAML2BindingBuilder builder, Document document) throws ProcessingException {
            super((BaseSAML2BindingBuilder)builder, document);
        }

        public Response response(String redirectUri) throws ProcessingException, ConfigurationException, IOException {
            return this.response(redirectUri, false);
        }

        public Response request(String redirect) throws ProcessingException, ConfigurationException, IOException {
            return this.response(redirect, true);
        }

        private Response response(String redirectUri, boolean asRequest) throws ProcessingException, ConfigurationException, IOException {
            URI uri = this.generateURI(redirectUri, asRequest);
            if (logger.isDebugEnabled()) {
                logger.trace((Object)("redirect-binding uri: " + uri.toString()));
            }
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            return Response.status((int)302).location(uri).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache, no-store").build();
        }
    }

    public static class PostBindingBuilder
    extends BaseSAML2BindingBuilder.BasePostBindingBuilder {
        public PostBindingBuilder(JaxrsSAML2BindingBuilder builder, Document document) throws ProcessingException {
            super((BaseSAML2BindingBuilder)builder, document);
        }

        public Response request(String actionUrl) throws ConfigurationException, ProcessingException, IOException {
            return this.buildResponse(this.document, actionUrl, true);
        }

        public Response response(String actionUrl) throws ConfigurationException, ProcessingException, IOException {
            return this.buildResponse(this.document, actionUrl, false);
        }

        protected Response buildResponse(Document responseDoc, String actionUrl, boolean asRequest) throws ProcessingException, ConfigurationException, IOException {
            String str = this.builder.buildHtmlPostResponse(responseDoc, actionUrl, asRequest);
            return Response.ok((Object)str, (MediaType)MediaType.TEXT_HTML_TYPE).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache, no-store").build();
        }
    }
}

