/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.runner.AbstractModuleTask;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchUtils;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

class ModuleRemoveTask
extends AbstractModuleTask {
    ModuleRemoveTask(PatchingTaskDescription description) {
        super(description);
    }

    @Override
    protected boolean failOnContentMismatch(PatchingTaskContext context) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] apply(PatchingTaskContext context, PatchContentLoader loader) throws IOException {
        File targetDir = context.getTargetFile(this.contentItem);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw PatchLogger.ROOT_LOGGER.cannotCreateDirectory(targetDir.getAbsolutePath());
        }
        File moduleXml = new File(targetDir, "module.xml");
        ByteArrayInputStream is = new ByteArrayInputStream(PatchUtils.getAbsentModuleContent((ModuleItem)this.contentItem));
        try {
            byte[] byArray = IoUtils.copy(is, moduleXml);
            return byArray;
        }
        finally {
            IoUtils.safeClose(is);
        }
    }

    @Override
    protected ContentModification getOriginalModification(byte[] targetHash, byte[] itemHash) {
        ModuleItem original = (ModuleItem)this.getContentItem();
        ModuleItem item = new ModuleItem(original.getName(), original.getSlot(), targetHash);
        return new ContentModification(item, this.description.getModification().getTargetHash(), ModificationType.MODIFY, this.description.getModification().getCondition());
    }

    @Override
    ContentModification createRollbackEntry(ContentModification original, byte[] targetHash, byte[] itemHash) {
        ModuleItem item = ModuleRemoveTask.createContentItem((ModuleItem)this.contentItem, itemHash);
        return new ContentModification(item, targetHash, ModificationType.MODIFY, original.getCondition());
    }
}

