/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class StringKeyedJDBCStoreBuilder
extends JDBCStoreBuilder<JdbcStringBasedStoreConfiguration, JdbcStringBasedStoreConfigurationBuilder> {
    private final InjectedValue<TableManipulationConfiguration> table = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private volatile JdbcStringBasedStoreConfigurationBuilder builder;

    public StringKeyedJDBCStoreBuilder(String containerName, String cacheName) {
        super(JdbcStringBasedStoreConfigurationBuilder.class, containerName, cacheName);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.STRING_TABLE.getServiceName(this.containerName, this.cacheName), TableManipulationConfiguration.class, this.table);
    }

    @Override
    public PersistenceConfiguration getValue() {
        this.builder.table().read((TableManipulationConfiguration)this.table.getValue());
        return super.getValue();
    }

    @Override
    JdbcStringBasedStoreConfigurationBuilder createStore(OperationContext context, ModelNode model) throws OperationFailedException {
        this.builder = (JdbcStringBasedStoreConfigurationBuilder)super.createStore(context, model);
        return this.builder;
    }
}

