/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.resources.admin.permissions.GroupPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.GroupPermissionManagement;
import org.keycloak.services.resources.admin.permissions.Helper;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;

class GroupPermissions
implements GroupPermissionEvaluator,
GroupPermissionManagement {
    private static final Logger logger = Logger.getLogger(GroupPermissions.class);
    public static final String MAP_ROLE_SCOPE = "map-role";
    public static final String MANAGE_MEMBERSHIP_SCOPE = "manage-membership";
    public static final String MANAGE_MEMBERS_SCOPE = "manage-members";
    public static final String VIEW_MEMBERS_SCOPE = "view-members";
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected final AuthorizationProvider authz;
    protected final MgmtPermissions root;

    public GroupPermissions(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissions root) {
        this.session = session;
        this.realm = realm;
        this.authz = authz;
        this.root = root;
    }

    private static String getGroupResourceName(GroupModel group) {
        return "group.resource." + group.getId();
    }

    public static String getManagePermissionGroup(GroupModel group) {
        return "manage.permission.group." + group.getId();
    }

    public static String getManageMembersPermissionGroup(GroupModel group) {
        return "manage.members.permission.group." + group.getId();
    }

    public static String getManageMembershipPermissionGroup(GroupModel group) {
        return "manage.membership.permission.group." + group.getId();
    }

    public static String getViewPermissionGroup(GroupModel group) {
        return "view.permission.group." + group.getId();
    }

    public static String getViewMembersPermissionGroup(GroupModel group) {
        return "view.members.permission.group." + group.getId();
    }

    private void initialize(GroupModel group) {
        this.root.initializeRealmResourceServer();
        this.root.initializeRealmDefaultScopes();
        ResourceServer server = this.root.realmResourceServer();
        Scope manageScope = this.root.realmManageScope();
        Scope viewScope = this.root.realmViewScope();
        Scope manageMembersScope = this.root.initializeRealmScope(MANAGE_MEMBERS_SCOPE);
        Scope viewMembersScope = this.root.initializeRealmScope(VIEW_MEMBERS_SCOPE);
        Scope manageMembershipScope = this.root.initializeRealmScope(MANAGE_MEMBERSHIP_SCOPE);
        String groupResourceName = GroupPermissions.getGroupResourceName(group);
        Resource groupResource = this.authz.getStoreFactory().getResourceStore().findByName(groupResourceName, server.getId());
        if (groupResource == null) {
            groupResource = this.authz.getStoreFactory().getResourceStore().create(groupResourceName, server, server.getClientId());
            HashSet<Scope> scopeset = new HashSet<Scope>();
            scopeset.add(manageScope);
            scopeset.add(viewScope);
            scopeset.add(manageMembershipScope);
            scopeset.add(manageMembersScope);
            groupResource.updateScopes(scopeset);
        }
        String managePermissionName = GroupPermissions.getManagePermissionGroup(group);
        Policy managePermission = this.authz.getStoreFactory().getPolicyStore().findByName(managePermissionName, server.getId());
        if (managePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, managePermissionName, groupResource, manageScope);
        }
        String viewPermissionName = GroupPermissions.getViewPermissionGroup(group);
        Policy viewPermission = this.authz.getStoreFactory().getPolicyStore().findByName(viewPermissionName, server.getId());
        if (viewPermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, viewPermissionName, groupResource, viewScope);
        }
        String manageMembersPermissionName = GroupPermissions.getManageMembersPermissionGroup(group);
        Policy manageMembersPermission = this.authz.getStoreFactory().getPolicyStore().findByName(manageMembersPermissionName, server.getId());
        if (manageMembersPermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, manageMembersPermissionName, groupResource, manageMembersScope);
        }
        String viewMembersPermissionName = GroupPermissions.getViewMembersPermissionGroup(group);
        Policy viewMembersPermission = this.authz.getStoreFactory().getPolicyStore().findByName(viewMembersPermissionName, server.getId());
        if (viewMembersPermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, viewMembersPermissionName, groupResource, viewMembersScope);
        }
        String manageMembershipPermissionName = GroupPermissions.getManageMembershipPermissionGroup(group);
        Policy manageMembershipPermission = this.authz.getStoreFactory().getPolicyStore().findByName(manageMembershipPermissionName, server.getId());
        if (manageMembershipPermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, manageMembershipPermissionName, groupResource, manageMembershipScope);
        }
    }

    @Override
    public boolean canList() {
        return this.root.hasOneAdminRole(AdminRoles.VIEW_USERS, AdminRoles.MANAGE_USERS, AdminRoles.QUERY_GROUPS);
    }

    @Override
    public void requireList() {
        if (!this.canList()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean isPermissionsEnabled(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        return this.authz.getStoreFactory().getResourceStore().findByName(GroupPermissions.getGroupResourceName(group), server.getId()) != null;
    }

    private Resource groupResource(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        String groupResourceName = GroupPermissions.getGroupResourceName(group);
        return this.authz.getStoreFactory().getResourceStore().findByName(groupResourceName, server.getId());
    }

    @Override
    public void setPermissionsEnabled(GroupModel group, boolean enable) {
        if (enable) {
            this.initialize(group);
        } else {
            this.deletePermissions(group);
        }
    }

    private void deletePermissions(GroupModel group) {
        Resource resource;
        Policy manageMembersPermission;
        Policy viewPermission;
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return;
        }
        Policy managePermission = this.managePermission(group);
        if (managePermission != null) {
            this.authz.getStoreFactory().getPolicyStore().delete(managePermission.getId());
        }
        if ((viewPermission = this.viewPermission(group)) != null) {
            this.authz.getStoreFactory().getPolicyStore().delete(viewPermission.getId());
        }
        if ((manageMembersPermission = this.manageMembersPermission(group)) != null) {
            this.authz.getStoreFactory().getPolicyStore().delete(manageMembersPermission.getId());
        }
        Policy viewMembersPermission = this.viewMembersPermission(group);
        if (manageMembersPermission == null) {
            this.authz.getStoreFactory().getPolicyStore().delete(viewMembersPermission.getId());
        }
        if ((resource = this.groupResource(group)) != null) {
            this.authz.getStoreFactory().getResourceStore().delete(resource.getId());
        }
    }

    @Override
    public Policy viewMembersPermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        String viewMembersPermissionName = GroupPermissions.getViewMembersPermissionGroup(group);
        return this.authz.getStoreFactory().getPolicyStore().findByName(viewMembersPermissionName, server.getId());
    }

    @Override
    public Policy manageMembersPermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        String manageMembersPermissionName = GroupPermissions.getManageMembersPermissionGroup(group);
        return this.authz.getStoreFactory().getPolicyStore().findByName(manageMembersPermissionName, server.getId());
    }

    @Override
    public Policy manageMembershipPermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        String manageMembershipPermissionName = GroupPermissions.getManageMembershipPermissionGroup(group);
        return this.authz.getStoreFactory().getPolicyStore().findByName(manageMembershipPermissionName, server.getId());
    }

    @Override
    public Policy viewPermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        String viewPermissionName = GroupPermissions.getViewPermissionGroup(group);
        return this.authz.getStoreFactory().getPolicyStore().findByName(viewPermissionName, server.getId());
    }

    @Override
    public Policy managePermission(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        String managePermissionName = GroupPermissions.getManagePermissionGroup(group);
        return this.authz.getStoreFactory().getPolicyStore().findByName(managePermissionName, server.getId());
    }

    @Override
    public Resource resource(GroupModel group) {
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return null;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(GroupPermissions.getGroupResourceName(group), server.getId());
        if (resource == null) {
            return null;
        }
        return resource;
    }

    @Override
    public Map<String, String> getPermissions(GroupModel group) {
        HashMap<String, String> scopes = new HashMap<String, String>();
        scopes.put("view", this.viewPermission(group).getId());
        scopes.put("manage", this.managePermission(group).getId());
        scopes.put(MANAGE_MEMBERS_SCOPE, this.manageMembersPermission(group).getId());
        scopes.put(VIEW_MEMBERS_SCOPE, this.viewMembersPermission(group).getId());
        scopes.put(MANAGE_MEMBERSHIP_SCOPE, this.manageMembershipPermission(group).getId());
        return scopes;
    }

    @Override
    public boolean canManage(GroupModel group) {
        if (this.canManage()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(GroupPermissions.getGroupResourceName(group), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.managePermission(group);
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.root.realmManageScope();
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public void requireManage(GroupModel group) {
        if (!this.canManage(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView(GroupModel group) {
        return this.hasView(group) || this.canManage(group);
    }

    private boolean hasView(GroupModel group) {
        if (this.canView()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(GroupPermissions.getGroupResourceName(group), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.viewPermission(group);
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.root.realmViewScope();
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public void requireView(GroupModel group) {
        if (!this.canView(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManage() {
        return this.root.users().canManageDefault();
    }

    @Override
    public void requireManage() {
        if (!this.canManage()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView() {
        return this.root.users().canViewDefault();
    }

    @Override
    public void requireView() {
        if (!this.canView()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canViewMembers(GroupModel group) {
        return this.canViewMembersEvaluation(group) || this.canManageMembers(group);
    }

    private boolean canViewMembersEvaluation(GroupModel group) {
        if (this.root.users().canView()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(GroupPermissions.getGroupResourceName(group), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.viewMembersPermission(group);
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName(VIEW_MEMBERS_SCOPE, server.getId());
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public void requireViewMembers(GroupModel group) {
        if (!this.canViewMembers(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageMembers(GroupModel group) {
        if (this.root.users().canManage()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(GroupPermissions.getGroupResourceName(group), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.manageMembersPermission(group);
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName(MANAGE_MEMBERS_SCOPE, server.getId());
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public void requireManageMembers(GroupModel group) {
        if (!this.canManageMembers(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageMembership(GroupModel group) {
        if (this.canManage(group)) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(GroupPermissions.getGroupResourceName(group), server.getId());
        if (resource == null) {
            return false;
        }
        Policy policy = this.manageMembershipPermission(group);
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName(MANAGE_MEMBERSHIP_SCOPE, server.getId());
        return this.root.evaluatePermission(resource, scope, server);
    }

    @Override
    public void requireManageMembership(GroupModel group) {
        if (!this.canManageMembership(group)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public Map<String, Boolean> getAccess(GroupModel group) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("view", this.canView(group));
        map.put("manage", this.canManage(group));
        map.put("manageMembership", this.canManageMembership(group));
        return map;
    }
}

