/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.AuthenticatedClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.InfinispanKeycloakTransaction;
import org.keycloak.models.sessions.infinispan.UserLoginFailureAdapter;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.stream.Comparators;
import org.keycloak.models.sessions.infinispan.stream.Mappers;
import org.keycloak.models.sessions.infinispan.stream.SessionPredicate;
import org.keycloak.models.sessions.infinispan.stream.UserLoginFailurePredicate;
import org.keycloak.models.sessions.infinispan.stream.UserSessionPredicate;

public class InfinispanUserSessionProvider
implements UserSessionProvider {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProvider.class);
    protected final KeycloakSession session;
    protected final Cache<String, SessionEntity> sessionCache;
    protected final Cache<String, SessionEntity> offlineSessionCache;
    protected final Cache<LoginFailureKey, LoginFailureEntity> loginFailureCache;
    protected final InfinispanKeycloakTransaction tx;

    public InfinispanUserSessionProvider(KeycloakSession session, Cache<String, SessionEntity> sessionCache, Cache<String, SessionEntity> offlineSessionCache, Cache<LoginFailureKey, LoginFailureEntity> loginFailureCache) {
        this.session = session;
        this.sessionCache = sessionCache;
        this.offlineSessionCache = offlineSessionCache;
        this.loginFailureCache = loginFailureCache;
        this.tx = new InfinispanKeycloakTransaction();
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
    }

    protected Cache<String, SessionEntity> getCache(boolean offline) {
        return offline ? this.offlineSessionCache : this.sessionCache;
    }

    public AuthenticatedClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity();
        AuthenticatedClientSessionAdapter adapter = new AuthenticatedClientSessionAdapter(entity, client, (UserSessionAdapter)userSession, this, this.sessionCache);
        adapter.setUserSession(userSession);
        return adapter;
    }

    public UserSessionModel createUserSession(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(id);
        this.updateSessionEntity(entity, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
        this.tx.putIfAbsent(this.sessionCache, id, entity);
        return this.wrap(realm, entity, false);
    }

    void updateSessionEntity(UserSessionEntity entity, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        entity.setRealm(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        return this.getUserSession(realm, id, false);
    }

    protected UserSessionAdapter getUserSession(RealmModel realm, String id, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        UserSessionEntity entity = (UserSessionEntity)this.tx.get(cache, id);
        if (entity == null) {
            entity = (UserSessionEntity)cache.get((Object)id);
        }
        return this.wrap(realm, entity, offline);
    }

    protected List<UserSessionModel> getUserSessions(RealmModel realm, Predicate<Map.Entry<String, SessionEntity>> predicate, boolean offline) {
        CacheStream cacheStream = this.getCache(offline).entrySet().stream();
        Iterator itr = cacheStream.filter(predicate).iterator();
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        while (itr.hasNext()) {
            UserSessionEntity e = (UserSessionEntity)((Map.Entry)itr.next()).getValue();
            sessions.add(this.wrap(realm, e, offline));
        }
        return sessions;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        return this.getUserSessions(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), false);
    }

    public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        return this.getUserSessions(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), false);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        List<UserSessionModel> userSessions = this.getUserSessions(realm, UserSessionPredicate.create(realm.getId()).brokerSessionId(brokerSessionId), false);
        return userSessions.isEmpty() ? null : userSessions.get(0);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, -1, -1);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        return this.getUserSessions(realm, client, firstResult, maxResults, false);
    }

    protected List<UserSessionModel> getUserSessions(final RealmModel realm, ClientModel client, int firstResult, int maxResults, final boolean offline) {
        List entities;
        int count;
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Stream<UserSessionEntity> stream = cache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).client(client.getId())).map(Mappers.userSessionEntity()).sorted(Comparators.userSessionLastSessionRefresh());
        if (firstResult < 0) {
            firstResult = 0;
        }
        if (maxResults < 0) {
            maxResults = Integer.MAX_VALUE;
        }
        if ((count = firstResult + maxResults) > 0) {
            stream = stream.limit(count);
        }
        if (firstResult > (entities = stream.collect(Collectors.toList())).size()) {
            return Collections.emptyList();
        }
        maxResults = Math.min(maxResults, entities.size() - firstResult);
        entities = entities.subList(firstResult, firstResult + maxResults);
        final LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        entities.stream().forEach(new Consumer<UserSessionEntity>(){

            @Override
            public void accept(UserSessionEntity userSessionEntity) {
                sessions.add(InfinispanUserSessionProvider.this.wrap(realm, userSessionEntity, offline));
            }
        });
        return sessions;
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, false);
    }

    protected long getUserSessionsCount(RealmModel realm, ClientModel client, boolean offline) {
        return this.getCache(offline).entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).client(client.getId())).count();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = this.getUserSessionEntity(session, false);
        if (entity != null) {
            this.removeUserSession(realm, entity, false);
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Iterator itr = cache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).user(user.getId())).map(Mappers.sessionEntity()).iterator();
        while (itr.hasNext()) {
            UserSessionEntity userSessionEntity = (UserSessionEntity)itr.next();
            this.removeUserSession(realm, userSessionEntity, offline);
        }
    }

    public void removeExpired(RealmModel realm) {
        log.debugf("Removing expired sessions", new Object[0]);
        this.removeExpiredUserSessions(realm);
        this.removeExpiredOfflineUserSessions(realm);
    }

    private void removeExpiredUserSessions(RealmModel realm) {
        int expired = Time.currentTime() - realm.getSsoSessionMaxLifespan();
        int expiredRefresh = Time.currentTime() - realm.getSsoSessionIdleTimeout();
        Iterator itr = this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).expired(expired, expiredRefresh)).iterator();
        int counter = 0;
        while (itr.hasNext()) {
            ++counter;
            UserSessionEntity entity = (UserSessionEntity)((Map.Entry)itr.next()).getValue();
            this.tx.remove(this.sessionCache, entity.getId());
        }
        log.debugf("Removed %d expired user sessions for realm '%s'", counter, (Object)realm.getName());
    }

    private void removeExpiredOfflineUserSessions(RealmModel realm) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        int expiredOffline = Time.currentTime() - realm.getOfflineSessionIdleTimeout();
        UserSessionPredicate predicate = UserSessionPredicate.create(realm.getId()).expired(null, expiredOffline);
        Iterator itr = this.offlineSessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).entrySet().stream().filter((Predicate)predicate).iterator();
        int counter = 0;
        while (itr.hasNext()) {
            ++counter;
            UserSessionEntity entity = (UserSessionEntity)((Map.Entry)itr.next()).getValue();
            this.tx.remove(this.offlineSessionCache, entity.getId());
            persister.removeUserSession(entity.getId(), true);
            for (String clientUUID : entity.getAuthenticatedClientSessions().keySet()) {
                persister.removeClientSession(entity.getId(), clientUUID, true);
            }
        }
        log.debugf("Removed %d expired offline user sessions for realm '%s'", counter, (Object)realm.getName());
    }

    public void removeUserSessions(RealmModel realm) {
        this.removeUserSessions(realm, false);
    }

    protected void removeUserSessions(RealmModel realm, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Iterator itr = cache.entrySet().stream().filter((Predicate)SessionPredicate.create(realm.getId())).map(Mappers.sessionId()).iterator();
        while (itr.hasNext()) {
            cache.remove(itr.next());
        }
    }

    public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        return this.wrap(key, (LoginFailureEntity)this.loginFailureCache.get((Object)key));
    }

    public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        LoginFailureEntity entity = new LoginFailureEntity();
        entity.setRealm(realm.getId());
        entity.setUserId(userId);
        this.tx.put(this.loginFailureCache, key, entity);
        return this.wrap(key, entity);
    }

    public void removeUserLoginFailure(RealmModel realm, String userId) {
        this.tx.remove(this.loginFailureCache, new LoginFailureKey(realm.getId(), userId));
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        Iterator itr = this.loginFailureCache.entrySet().stream().filter((Predicate)UserLoginFailurePredicate.create(realm.getId())).map(Mappers.loginFailureId()).iterator();
        while (itr.hasNext()) {
            LoginFailureKey key = (LoginFailureKey)itr.next();
            this.tx.remove(this.loginFailureCache, key);
        }
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm, true);
        this.removeUserSessions(realm, false);
        this.removeAllUserLoginFailures(realm);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    protected void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, true);
        this.removeUserSessions(realm, user, false);
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getUsername()));
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getEmail()));
    }

    public void close() {
    }

    protected void removeUserSession(RealmModel realm, UserSessionEntity sessionEntity, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        this.tx.remove(cache, sessionEntity.getId());
    }

    InfinispanKeycloakTransaction getTx() {
        return this.tx;
    }

    UserSessionAdapter wrap(RealmModel realm, UserSessionEntity entity, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        return entity != null ? new UserSessionAdapter(this.session, this, cache, realm, entity, offline) : null;
    }

    List<UserSessionModel> wrapUserSessions(RealmModel realm, Collection<UserSessionEntity> entities, boolean offline) {
        LinkedList<UserSessionModel> models = new LinkedList<UserSessionModel>();
        for (UserSessionEntity e : entities) {
            models.add(this.wrap(realm, e, offline));
        }
        return models;
    }

    UserLoginFailureModel wrap(LoginFailureKey key, LoginFailureEntity entity) {
        return entity != null ? new UserLoginFailureAdapter(this, this.loginFailureCache, key, entity) : null;
    }

    UserSessionEntity getUserSessionEntity(UserSessionModel userSession, boolean offline) {
        if (userSession instanceof UserSessionAdapter) {
            return ((UserSessionAdapter)userSession).getEntity();
        }
        Cache<String, SessionEntity> cache = this.getCache(offline);
        return cache != null ? (UserSessionEntity)cache.get((Object)userSession.getId()) : null;
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        UserSessionAdapter offlineUserSession = this.importUserSession(userSession, true, false);
        int currentTime = Time.currentTime();
        offlineUserSession.getEntity().setStarted(currentTime);
        offlineUserSession.setLastSessionRefresh(currentTime);
        return offlineUserSession;
    }

    public UserSessionAdapter getOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.getUserSession(realm, userSessionId, true);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(userSession, true);
        if (userSessionEntity != null) {
            this.removeUserSession(realm, userSessionEntity, true);
        }
    }

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        UserSessionAdapter userSessionAdapter = offlineUserSession instanceof UserSessionAdapter ? (UserSessionAdapter)offlineUserSession : this.getOfflineUserSession(offlineUserSession.getRealm(), offlineUserSession.getId());
        AuthenticatedClientSessionAdapter offlineClientSession = this.importClientSession(userSessionAdapter, clientSession);
        offlineClientSession.setTimestamp(Time.currentTime());
        return offlineClientSession;
    }

    public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, UserModel user) {
        Iterator itr = this.offlineSessionCache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).user(user.getId())).iterator();
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        while (itr.hasNext()) {
            UserSessionEntity entity = (UserSessionEntity)((Map.Entry)itr.next()).getValue();
            UserSessionAdapter userSession = this.wrap(realm, entity, true);
            userSessions.add(userSession);
        }
        return userSessions;
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, true);
    }

    public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, ClientModel client, int first, int max) {
        return this.getUserSessions(realm, client, first, max, true);
    }

    public UserSessionAdapter importUserSession(UserSessionModel userSession, boolean offline, boolean importAuthenticatedClientSessions) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(userSession.getId());
        entity.setRealm(userSession.getRealm().getId());
        entity.setAuthMethod(userSession.getAuthMethod());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        entity.setBrokerUserId(userSession.getBrokerUserId());
        entity.setIpAddress(userSession.getIpAddress());
        entity.setLoginUsername(userSession.getLoginUsername());
        entity.setNotes(userSession.getNotes() == null ? new ConcurrentHashMap() : userSession.getNotes());
        entity.setAuthenticatedClientSessions(new ConcurrentHashMap<String, AuthenticatedClientSessionEntity>());
        entity.setRememberMe(userSession.isRememberMe());
        entity.setState(userSession.getState());
        entity.setUser(userSession.getUser().getId());
        entity.setStarted(userSession.getStarted());
        entity.setLastSessionRefresh(userSession.getLastSessionRefresh());
        Cache<String, SessionEntity> cache = this.getCache(offline);
        this.tx.put(cache, userSession.getId(), entity);
        UserSessionAdapter importedSession = this.wrap(userSession.getRealm(), entity, offline);
        if (importAuthenticatedClientSessions) {
            for (AuthenticatedClientSessionModel clientSession : userSession.getAuthenticatedClientSessions().values()) {
                this.importClientSession(importedSession, clientSession);
            }
        }
        return importedSession;
    }

    private AuthenticatedClientSessionAdapter importClientSession(UserSessionAdapter importedUserSession, AuthenticatedClientSessionModel clientSession) {
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity();
        entity.setAction(clientSession.getAction());
        entity.setAuthMethod(clientSession.getProtocol());
        entity.setNotes(clientSession.getNotes());
        entity.setProtocolMappers(clientSession.getProtocolMappers());
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setRoles(clientSession.getRoles());
        entity.setTimestamp(clientSession.getTimestamp());
        Map<String, AuthenticatedClientSessionEntity> clientSessions = importedUserSession.getEntity().getAuthenticatedClientSessions();
        clientSessions.put(clientSession.getClient().getId(), entity);
        importedUserSession.update();
        return new AuthenticatedClientSessionAdapter(entity, clientSession.getClient(), importedUserSession, this, importedUserSession.getCache());
    }
}

