/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.jmx.JMXSubsystemRootResource;
import org.jboss.as.jmx.JmxEffect;
import org.jboss.as.jmx.PluggableMBeanServerImpl;
import org.jboss.as.jmx.model.ConfiguredDomains;
import org.jboss.as.jmx.model.ManagementModelIntegration;
import org.jboss.as.jmx.model.ModelControllerMBeanServerPlugin;
import org.jboss.as.server.Services;
import org.jboss.as.server.jmx.MBeanServerPlugin;
import org.jboss.as.server.jmx.PluggableMBeanServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class MBeanServerService
implements Service<PluggableMBeanServer> {
    public static final ServiceName SERVICE_NAME = JMXSubsystemRootResource.JMX_CAPABILITY.getCapabilityServiceName(MBeanServer.class);
    private static final ServiceName LEGACY_MBEAN_SERVER_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private static final ServiceName DOMAIN_CONTROLLER_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "model", "controller"});
    private final String resolvedDomainName;
    private final String expressionsDomainName;
    private final boolean legacyWithProperPropertyFormat;
    private final boolean coreMBeanSensitivity;
    private final JmxAuthorizer authorizer;
    private final ManagedAuditLogger auditLoggerInfo;
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<ManagementModelIntegration.ManagementModelProvider> managementModelProviderValue = new InjectedValue();
    private final ProcessType processType;
    private final boolean isMasterHc;
    private final JmxEffect jmxEffect;
    private PluggableMBeanServer mBeanServer;
    private MBeanServerPlugin showModelPlugin;

    private MBeanServerService(String resolvedDomainName, String expressionsDomainName, boolean legacyWithProperPropertyFormat, boolean coreMBeanSensitivity, ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, JmxEffect jmxEffect, ProcessType processType, boolean isMasterHc) {
        this.resolvedDomainName = resolvedDomainName;
        this.expressionsDomainName = expressionsDomainName;
        this.legacyWithProperPropertyFormat = legacyWithProperPropertyFormat;
        this.coreMBeanSensitivity = coreMBeanSensitivity;
        this.auditLoggerInfo = auditLoggerInfo;
        this.authorizer = authorizer;
        this.jmxEffect = jmxEffect;
        this.processType = processType;
        this.isMasterHc = isMasterHc;
    }

    @SafeVarargs
    public static ServiceController<?> addService(ServiceTarget batchBuilder, String resolvedDomainName, String expressionsDomainName, boolean legacyWithProperPropertyFormat, boolean coreMBeanSensitivity, ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, JmxEffect jmxEffect, ProcessType processType, boolean isMasterHc, ServiceListener<? super PluggableMBeanServer> ... listeners) {
        MBeanServerService service = new MBeanServerService(resolvedDomainName, expressionsDomainName, legacyWithProperPropertyFormat, coreMBeanSensitivity, auditLoggerInfo, authorizer, jmxEffect, processType, isMasterHc);
        ServiceName modelControllerName = processType == ProcessType.HOST_CONTROLLER ? DOMAIN_CONTROLLER_NAME : Services.JBOSS_SERVER_CONTROLLER;
        return batchBuilder.addService(SERVICE_NAME, (Service)service).addListener(listeners).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(modelControllerName, ModelController.class, service.modelControllerValue).addDependency(ManagementModelIntegration.SERVICE_NAME, ManagementModelIntegration.ManagementModelProvider.class, service.managementModelProviderValue).addAliases(new ServiceName[]{LEGACY_MBEAN_SERVER_NAME}).install();
    }

    public synchronized void start(StartContext context) throws StartException {
        MBeanServer platform = ManagementFactory.getPlatformMBeanServer();
        PluggableMBeanServerImpl pluggable = platform instanceof PluggableMBeanServerImpl ? (PluggableMBeanServerImpl)((Object)platform) : new PluggableMBeanServerImpl(platform, null);
        MBeanServerDelegate delegate = platform instanceof PluggableMBeanServerImpl ? ((PluggableMBeanServerImpl)((Object)platform)).getMBeanServerDelegate() : null;
        pluggable.setAuditLogger(this.auditLoggerInfo);
        pluggable.setAuthorizer(this.authorizer);
        pluggable.setJmxEffect(this.jmxEffect);
        this.authorizer.setNonFacadeMBeansSensitive(this.coreMBeanSensitivity);
        if (this.resolvedDomainName != null || this.expressionsDomainName != null) {
            ConfiguredDomains configuredDomains = new ConfiguredDomains(this.resolvedDomainName, this.expressionsDomainName);
            this.showModelPlugin = new ModelControllerMBeanServerPlugin((MBeanServer)((Object)pluggable), configuredDomains, (ModelController)this.modelControllerValue.getValue(), delegate, this.legacyWithProperPropertyFormat, this.processType, (ManagementModelIntegration.ManagementModelProvider)this.managementModelProviderValue.getValue(), this.isMasterHc);
            pluggable.addPlugin(this.showModelPlugin);
        }
        this.mBeanServer = pluggable;
    }

    public synchronized void stop(StopContext context) {
        this.mBeanServer.removePlugin(this.showModelPlugin);
        this.mBeanServer = null;
    }

    public synchronized PluggableMBeanServer getValue() throws IllegalStateException {
        return this.mBeanServer;
    }
}

