/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.File;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.Target;
import org.hibernate.tool.schema.extract.internal.DatabaseInformationImpl;
import org.hibernate.tool.schema.internal.TargetDatabaseImpl;
import org.hibernate.tool.schema.internal.TargetFileImpl;
import org.hibernate.tool.schema.internal.TargetStdoutImpl;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.SchemaMigrator;

public class SchemaUpdate {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SchemaUpdate.class);
    private final MetadataImplementor metadata;
    private final ServiceRegistry serviceRegistry;
    private final JdbcConnectionAccess jdbcConnectionAccess;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private String outputFile;
    private String delimiter;
    private Formatter formatter;

    public SchemaUpdate(MetadataImplementor metadata) {
        this(metadata.getMetadataBuildingOptions().getServiceRegistry(), metadata);
    }

    public SchemaUpdate(ServiceRegistry serviceRegistry, MetadataImplementor metadata) throws HibernateException {
        this.metadata = metadata;
        this.serviceRegistry = serviceRegistry;
        this.jdbcConnectionAccess = serviceRegistry.getService(JdbcServices.class).getBootstrapJdbcConnectionAccess();
    }

    public void execute(boolean script, boolean doUpdate) {
        this.execute(Target.interpret(script, doUpdate));
    }

    public void execute(Target target) {
        DatabaseInformationImpl databaseInformation;
        LOG.runningHbm2ddlSchemaUpdate();
        this.exceptions.clear();
        List<org.hibernate.tool.schema.spi.Target> toolTargets = this.buildToolTargets(target);
        ConfigurationService cfgService = this.serviceRegistry.getService(ConfigurationService.class);
        SchemaMigrator schemaMigrator = this.serviceRegistry.getService(SchemaManagementTool.class).getSchemaMigrator(cfgService.getSettings());
        JdbcServices jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        try {
            databaseInformation = new DatabaseInformationImpl(this.serviceRegistry, this.serviceRegistry.getService(JdbcEnvironment.class), this.jdbcConnectionAccess, this.metadata.getDatabase().getDefaultNamespace().getPhysicalName().getCatalog(), this.metadata.getDatabase().getDefaultNamespace().getPhysicalName().getSchema());
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Error creating DatabaseInformation for schema migration");
        }
        schemaMigrator.doMigration(this.metadata, databaseInformation, true, toolTargets);
    }

    private List<org.hibernate.tool.schema.spi.Target> buildToolTargets(Target target) {
        ArrayList<org.hibernate.tool.schema.spi.Target> toolTargets = new ArrayList<org.hibernate.tool.schema.spi.Target>();
        if (target.doScript()) {
            toolTargets.add(new TargetStdoutImpl(this.delimiter, this.formatter));
        }
        if (target.doExport()) {
            toolTargets.add(new TargetDatabaseImpl(this.jdbcConnectionAccess));
        }
        if (this.outputFile != null) {
            LOG.writingGeneratedSchemaToFile(this.outputFile);
            toolTargets.add(new TargetFileImpl(this.outputFile, this.delimiter, this.formatter));
        }
        return toolTargets;
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void setHaltOnError(boolean haltOnError) {
    }

    public void setFormat(boolean format) {
        this.formatter = (format ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLineArgs parsedArgs = CommandLineArgs.parseCommandLineArgs(args);
            StandardServiceRegistry serviceRegistry = SchemaUpdate.buildStandardServiceRegistry(parsedArgs);
            try {
                MetadataImplementor metadata = SchemaUpdate.buildMetadata(parsedArgs, serviceRegistry);
                SchemaUpdate schemaUpdate = new SchemaUpdate(metadata);
                schemaUpdate.setOutputFile(parsedArgs.outFile);
                schemaUpdate.setDelimiter(parsedArgs.delimiter);
                schemaUpdate.execute(parsedArgs.script, parsedArgs.doUpdate);
            }
            finally {
                StandardServiceRegistryBuilder.destroy(serviceRegistry);
            }
        }
        catch (Exception e) {
            LOG.unableToRunSchemaUpdate(e);
            e.printStackTrace();
        }
    }

    private static StandardServiceRegistry buildStandardServiceRegistry(CommandLineArgs parsedArgs) throws Exception {
        BootstrapServiceRegistry bsr = new BootstrapServiceRegistryBuilder().build();
        StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bsr);
        if (parsedArgs.cfgXmlFile != null) {
            ssrBuilder.configure(parsedArgs.cfgXmlFile);
        }
        if (parsedArgs.propertiesFile != null) {
            Properties props = new Properties();
            props.load(new FileInputStream(parsedArgs.propertiesFile));
            ssrBuilder.applySettings(props);
        }
        return ssrBuilder.build();
    }

    private static MetadataImplementor buildMetadata(CommandLineArgs parsedArgs, ServiceRegistry serviceRegistry) throws Exception {
        MetadataSources metadataSources = new MetadataSources(serviceRegistry);
        for (String filename : parsedArgs.hbmXmlFiles) {
            metadataSources.addFile(filename);
        }
        for (String filename : parsedArgs.jarFiles) {
            metadataSources.addJar(new File(filename));
        }
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
        if (parsedArgs.implicitNamingStrategyImplName != null) {
            metadataBuilder.applyImplicitNamingStrategy(strategySelector.resolveStrategy(ImplicitNamingStrategy.class, parsedArgs.implicitNamingStrategyImplName));
        }
        if (parsedArgs.physicalNamingStrategyImplName != null) {
            metadataBuilder.applyPhysicalNamingStrategy(strategySelector.resolveStrategy(PhysicalNamingStrategy.class, parsedArgs.physicalNamingStrategyImplName));
        }
        return (MetadataImplementor)metadataBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataImplementor buildMetadataFromMainArgs(String[] args) throws Exception {
        CommandLineArgs commandLineArgs = CommandLineArgs.parseCommandLineArgs(args);
        StandardServiceRegistry serviceRegistry = SchemaUpdate.buildStandardServiceRegistry(commandLineArgs);
        try {
            MetadataImplementor metadataImplementor = SchemaUpdate.buildMetadata(commandLineArgs, serviceRegistry);
            return metadataImplementor;
        }
        finally {
            StandardServiceRegistryBuilder.destroy(serviceRegistry);
        }
    }

    private static class CommandLineArgs {
        boolean script = true;
        boolean doUpdate = true;
        String propertiesFile = null;
        String cfgXmlFile = null;
        String outFile = null;
        String delimiter = null;
        String implicitNamingStrategyImplName = null;
        String physicalNamingStrategyImplName = null;
        List<String> hbmXmlFiles = new ArrayList<String>();
        List<String> jarFiles = new ArrayList<String>();

        private CommandLineArgs() {
        }

        public static CommandLineArgs parseCommandLineArgs(String[] args) {
            CommandLineArgs parsedArgs = new CommandLineArgs();
            for (String arg : args) {
                if (arg.startsWith("--")) {
                    if (arg.equals("--quiet")) {
                        parsedArgs.script = false;
                        continue;
                    }
                    if (arg.startsWith("--properties=")) {
                        parsedArgs.propertiesFile = arg.substring(13);
                        continue;
                    }
                    if (arg.startsWith("--config=")) {
                        parsedArgs.cfgXmlFile = arg.substring(9);
                        continue;
                    }
                    if (arg.startsWith("--text")) {
                        parsedArgs.doUpdate = false;
                        continue;
                    }
                    if (arg.startsWith("--output=")) {
                        parsedArgs.outFile = arg.substring(9);
                        continue;
                    }
                    if (arg.startsWith("--naming=")) {
                        DeprecationLogger.DEPRECATION_LOGGER.logDeprecatedNamingStrategyArgument();
                        continue;
                    }
                    if (arg.startsWith("--delimiter=")) {
                        parsedArgs.delimiter = arg.substring(12);
                        continue;
                    }
                    if (arg.startsWith("--implicit-naming=")) {
                        parsedArgs.implicitNamingStrategyImplName = arg.substring(18);
                        continue;
                    }
                    if (!arg.startsWith("--physical-naming=")) continue;
                    parsedArgs.physicalNamingStrategyImplName = arg.substring(18);
                    continue;
                }
                if (arg.endsWith(".jar")) {
                    parsedArgs.jarFiles.add(arg);
                    continue;
                }
                parsedArgs.hbmXmlFiles.add(arg);
            }
            return parsedArgs;
        }
    }
}

