/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsMessageConsumer;
import org.jboss.resource.adapter.jms.JmsSession;

public class JmsMessageProducer
implements MessageProducer {
    private static final Logger log = Logger.getLogger(JmsMessageConsumer.class);
    MessageProducer producer;
    JmsSession session;
    private boolean trace = log.isTraceEnabled();

    public JmsMessageProducer(MessageProducer producer, JmsSession session) {
        this.producer = producer;
        this.session = session;
        if (this.trace) {
            log.trace((Object)("new JmsMessageProducer " + this + " producer=" + producer + " session=" + session));
        }
    }

    public void close() throws JMSException {
        if (this.trace) {
            log.trace((Object)("close " + this));
        }
        try {
            this.closeProducer();
        }
        finally {
            this.session.removeProducer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("send " + this + " destination=" + destination + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive));
            }
            this.producer.send(destination, message, deliveryMode, priority, timeToLive);
            if (this.trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("send " + this + " destination=" + destination + " message=" + message));
            }
            this.producer.send(destination, message);
            if (this.trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("send " + this + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive));
            }
            this.producer.send(message, deliveryMode, priority, timeToLive);
            if (this.trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public void send(Message message) throws JMSException {
        this.session.lock();
        try {
            if (this.trace) {
                log.trace((Object)("send " + this + " message=" + message));
            }
            this.producer.send(message);
            if (this.trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public int getDeliveryMode() throws JMSException {
        return this.producer.getDeliveryMode();
    }

    public Destination getDestination() throws JMSException {
        return this.producer.getDestination();
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.producer.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.producer.getDisableMessageTimestamp();
    }

    public int getPriority() throws JMSException {
        return this.producer.getPriority();
    }

    public long getTimeToLive() throws JMSException {
        return this.producer.getTimeToLive();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.producer.setDeliveryMode(deliveryMode);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.producer.setDisableMessageID(value);
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.producer.setDisableMessageTimestamp(value);
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.producer.setPriority(defaultPriority);
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.producer.setTimeToLive(timeToLive);
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.producer.setDeliveryDelay(deliveryDelay);
    }

    public long getDeliveryDelay() throws JMSException {
        return this.producer.getDeliveryDelay();
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        this.producer.send(message, completionListener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.producer.send(message, deliveryMode, priority, timeToLive, completionListener);
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        this.producer.send(destination, message, completionListener);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.producer.send(destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    void closeProducer() throws JMSException {
        this.producer.close();
    }
}

