/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.authz.PermissionMappable;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.permission.PermissionVerifier;

public class SimplePermissionMapper
implements PermissionMapper {
    private final MappingMode mappingMode;
    private final List<Mapping> mappings;

    private SimplePermissionMapper(MappingMode mappingMode, List<Mapping> mappings) {
        this.mappingMode = mappingMode;
        this.mappings = mappings;
    }

    @Override
    public PermissionVerifier mapPermissions(PermissionMappable permissionMappable, Roles roles) {
        Assert.checkNotNullParam((String)"permissionMappable", (Object)permissionMappable);
        Assert.checkNotNullParam((String)"roles", (Object)roles);
        PermissionVerifier result = null;
        for (Mapping current : this.mappings) {
            if (!current.principals.contains(permissionMappable.getPrincipal().getName()) && !roles.containsAny(current.roles)) continue;
            switch (this.mappingMode) {
                case FIRST_MATCH: {
                    return current.permissionVerifier;
                }
                case AND: {
                    result = result != null ? result.and(current.permissionVerifier) : current.permissionVerifier;
                    break;
                }
                case OR: {
                    result = result != null ? result.or(current.permissionVerifier) : current.permissionVerifier;
                    break;
                }
                case UNLESS: {
                    result = result != null ? result.unless(current.permissionVerifier) : current.permissionVerifier;
                    break;
                }
                case XOR: {
                    result = result != null ? result.xor(current.permissionVerifier) : current.permissionVerifier;
                }
            }
        }
        return result != null ? result : PermissionVerifier.NONE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum MappingMode {
        FIRST_MATCH,
        AND,
        OR,
        XOR,
        UNLESS;

    }

    private static class Mapping {
        private final Set<String> principals;
        private final Set<String> roles;
        private final PermissionVerifier permissionVerifier;

        private Mapping(Set<String> principals, Set<String> roles, PermissionVerifier permissionVerifier) {
            this.principals = new HashSet<String>((Collection)Assert.checkNotNullParam((String)"principals", principals));
            this.roles = Collections.unmodifiableSet(new HashSet((Collection)Assert.checkNotNullParam((String)"roles", roles)));
            this.permissionVerifier = (PermissionVerifier)Assert.checkNotNullParam((String)"permissionVerifier", (Object)permissionVerifier);
        }
    }

    public static class Builder {
        private boolean built = false;
        private MappingMode mappingMode = MappingMode.FIRST_MATCH;
        private final List<Mapping> mappings = new ArrayList<Mapping>();

        Builder() {
        }

        public Builder setMappingMode(MappingMode mappingMode) {
            this.assertNotBuilt();
            this.mappingMode = mappingMode;
            return this;
        }

        public Builder addMapping(Set<String> principals, Set<String> roles, PermissionVerifier permissionVerifer) {
            this.assertNotBuilt();
            this.mappings.add(new Mapping(principals, roles, permissionVerifer));
            return this;
        }

        public PermissionMapper build() {
            this.assertNotBuilt();
            this.built = true;
            return new SimplePermissionMapper(this.mappingMode, this.mappings);
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }
}

