/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.HashSet;
import javax.security.jacc.EJBMethodPermission;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaccInterceptor
implements Interceptor {
    private final String viewClassName;
    private final Method viewMethod;

    public JaccInterceptor(String viewClassName, Method viewMethod) {
        this.viewClassName = viewClassName;
        this.viewMethod = viewMethod;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        Component component = (Component)context.getPrivateData(Component.class);
        SecurityDomain securityDomain = (SecurityDomain)context.getPrivateData(SecurityDomain.class);
        Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        SecurityIdentity currentIdentity = securityDomain.getCurrentSecurityIdentity();
        if (!(component instanceof EJBComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, EJBComponent.class);
        }
        Method invokedMethod = context.getMethod();
        ComponentView componentView = (ComponentView)context.getPrivateData(ComponentView.class);
        String viewClassOfInvokedMethod = componentView.getViewClass().getName();
        if (!this.viewClassName.equals(viewClassOfInvokedMethod) || !this.viewMethod.equals(invokedMethod)) {
            throw EjbLogger.ROOT_LOGGER.failProcessInvocation(this.getClass().getName(), invokedMethod, viewClassOfInvokedMethod, this.viewMethod, this.viewClassName);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        if (WildFlySecurityManager.isChecking()) {
            try {
                AccessController.doPrivileged(() -> {
                    this.hasPermission(ejbComponent, componentView, invokedMethod, currentIdentity);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        } else {
            this.hasPermission(ejbComponent, componentView, invokedMethod, currentIdentity);
        }
        return context.proceed();
    }

    private EJBMethodPermission createEjbMethodPermission(Method invokedMethod, EJBComponent ejbComponent, MethodInterfaceType methodIntfType) {
        return new EJBMethodPermission(ejbComponent.getComponentName(), methodIntfType.name(), invokedMethod);
    }

    private void hasPermission(EJBComponent ejbComponent, ComponentView componentView, Method method, SecurityIdentity securityIdentity) {
        Policy policy;
        MethodInterfaceType methodIntfType = this.getMethodInterfaceType((MethodIntf)((Object)componentView.getPrivateData(MethodIntf.class)));
        EJBMethodPermission permission = this.createEjbMethodPermission(method, ejbComponent, methodIntfType);
        ProtectionDomain domain = new ProtectionDomain(componentView.getProxyClass().getProtectionDomain().getCodeSource(), null, null, JaccInterceptor.getGrantedRoles(securityIdentity));
        Policy policy2 = policy = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(Policy::getPolicy) : Policy.getPolicy();
        if (!policy.implies(domain, (Permission)permission)) {
            throw EjbLogger.ROOT_LOGGER.invocationOfMethodNotAllowed(method, ejbComponent.getComponentName());
        }
    }

    protected MethodInterfaceType getMethodInterfaceType(MethodIntf viewType) {
        switch (viewType) {
            case HOME: {
                return MethodInterfaceType.Home;
            }
            case LOCAL_HOME: {
                return MethodInterfaceType.LocalHome;
            }
            case SERVICE_ENDPOINT: {
                return MethodInterfaceType.ServiceEndpoint;
            }
            case LOCAL: {
                return MethodInterfaceType.Local;
            }
            case REMOTE: {
                return MethodInterfaceType.Remote;
            }
            case TIMER: {
                return MethodInterfaceType.Timer;
            }
            case MESSAGE_ENDPOINT: {
                return MethodInterfaceType.MessageEndpoint;
            }
        }
        return null;
    }

    public static Principal[] getGrantedRoles(SecurityIdentity securityIdentity) {
        HashSet roles = new HashSet();
        securityIdentity.getRoles("ejb").forEach(roles::add);
        return (Principal[])roles.stream().map(roleName -> () -> roleName).toArray(Principal[]::new);
    }
}

