/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;

@Entity
@Table(name="RESOURCE_SERVER_SCOPE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "RESOURCE_SERVER_ID"})})
@NamedQueries(value={@NamedQuery(name="findScopeIdByName", query="select s.id from ScopeEntity s where s.resourceServer.id = :serverId and s.name = :name"), @NamedQuery(name="findScopeIdByResourceServer", query="select s.id from ScopeEntity s where s.resourceServer.id = :serverId"), @NamedQuery(name="deleteScopeByResourceServer", query="delete from ScopeEntity s where s.resourceServer.id = :serverId")})
public class ScopeEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Column(name="NAME")
    private String name;
    @Column(name="ICON_URI")
    private String iconUri;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RESOURCE_SERVER_ID")
    private ResourceServerEntity resourceServer;
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="SCOPE_POLICY", joinColumns={@JoinColumn(name="SCOPE_ID")}, inverseJoinColumns={@JoinColumn(name="POLICY_ID")})
    private List<PolicyEntity> policies = new ArrayList<PolicyEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public ResourceServerEntity getResourceServer() {
        return this.resourceServer;
    }

    public List<PolicyEntity> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<PolicyEntity> policies) {
        this.policies = policies;
    }

    public void setResourceServer(ResourceServerEntity resourceServer) {
        this.resourceServer = resourceServer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeEntity that = (ScopeEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

