/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexExternalizer;

public class EnumExternalizer<E extends Enum<E>>
implements Externalizer<E> {
    private final IndexExternalizer ordinalExternalizer;
    private final Class<E> enumClass;

    public EnumExternalizer(Class<E> enumClass) {
        this.ordinalExternalizer = IndexExternalizer.select(((Enum[])enumClass.getEnumConstants()).length);
        this.enumClass = enumClass;
    }

    public void writeObject(ObjectOutput output, E value) throws IOException {
        this.ordinalExternalizer.writeData(output, ((Enum)value).ordinal());
    }

    public E readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return (E)((Enum[])this.enumClass.getEnumConstants())[this.ordinalExternalizer.readData(input)];
    }

    public Class<E> getTargetClass() {
        return this.enumClass;
    }
}

