/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.StickySessionEncoderProvider;

public class AuthenticationSessionManager {
    public static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    private static final Logger log = Logger.getLogger(AuthenticationSessionManager.class);
    private final KeycloakSession session;

    public AuthenticationSessionManager(KeycloakSession session) {
        this.session = session;
    }

    public AuthenticationSessionModel createAuthenticationSession(RealmModel realm, ClientModel client, boolean browserCookie) {
        AuthenticationSessionModel authSession = this.session.authenticationSessions().createAuthenticationSession(realm, client);
        if (browserCookie) {
            this.setAuthSessionCookie(authSession.getId(), realm);
        }
        return authSession;
    }

    public String getCurrentAuthenticationSessionId(RealmModel realm) {
        return this.getAuthSessionCookieDecoded(realm);
    }

    public AuthenticationSessionModel getCurrentAuthenticationSession(RealmModel realm) {
        String authSessionId = this.getAuthSessionCookieDecoded(realm);
        return authSessionId == null ? null : this.session.authenticationSessions().getAuthenticationSession(realm, authSessionId);
    }

    public void setAuthSessionCookie(String authSessionId, RealmModel realm) {
        UriInfo uriInfo = this.session.getContext().getUri();
        String cookiePath = AuthenticationManager.getRealmCookiePath(realm, uriInfo);
        boolean sslRequired = realm.getSslRequired().isRequired(this.session.getContext().getConnection());
        StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)this.session.getProvider(StickySessionEncoderProvider.class);
        String encodedAuthSessionId = encoder.encodeSessionId(authSessionId);
        CookieHelper.addCookie(AUTH_SESSION_ID, encodedAuthSessionId, cookiePath, null, null, -1, sslRequired, true);
        log.debugf("Set AUTH_SESSION_ID cookie with value %s", (Object)encodedAuthSessionId);
    }

    private String getAuthSessionCookieDecoded(RealmModel realm) {
        String cookieVal = CookieHelper.getCookieValue(AUTH_SESSION_ID);
        if (cookieVal != null) {
            log.debugf("Found AUTH_SESSION_ID cookie with value %s", (Object)cookieVal);
            StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)this.session.getProvider(StickySessionEncoderProvider.class);
            String decodedAuthSessionId = encoder.decodeSessionId(cookieVal);
            String reencoded = encoder.encodeSessionId(decodedAuthSessionId);
            if (!reencoded.equals(cookieVal)) {
                log.debugf("Route changed. Will update authentication session cookie", new Object[0]);
                this.setAuthSessionCookie(decodedAuthSessionId, realm);
            }
            return decodedAuthSessionId;
        }
        log.debugf("Not found AUTH_SESSION_ID cookie", new Object[0]);
        return null;
    }

    public void removeAuthenticationSession(RealmModel realm, AuthenticationSessionModel authSession, boolean expireRestartCookie) {
        log.debugf("Removing authSession '%s'. Expire restart cookie: %b", (Object)authSession.getId(), (Object)expireRestartCookie);
        this.session.authenticationSessions().removeAuthenticationSession(realm, authSession);
        if (expireRestartCookie) {
            ClientConnection clientConnection = this.session.getContext().getConnection();
            UriInfo uriInfo = this.session.getContext().getUri();
            RestartLoginCookie.expireRestartCookie(realm, clientConnection, uriInfo);
        }
    }

    public UserSessionModel getUserSession(AuthenticationSessionModel authSession) {
        return this.session.sessions().getUserSession(authSession.getRealm(), authSession.getId());
    }
}

