/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.ExplainedVerificationException;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionContextResult;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.ActionTokenHandler;
import org.keycloak.authentication.actiontoken.DefaultActionToken;
import org.keycloak.authentication.actiontoken.DefaultActionTokenKey;
import org.keycloak.authentication.actiontoken.ExplainedTokenVerificationException;
import org.keycloak.authentication.actiontoken.resetcred.ResetCredentialsActionTokenHandler;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.exceptions.TokenNotActiveException;
import org.keycloak.models.ActionTokenKeyModel;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsServiceChecks;
import org.keycloak.services.resources.LoginActionsServiceException;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.SessionCodeChecks;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.services.util.BrowserHistoryHelper;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class LoginActionsService {
    private static final Logger logger = Logger.getLogger(LoginActionsService.class);
    public static final String AUTHENTICATE_PATH = "authenticate";
    public static final String REGISTRATION_PATH = "registration";
    public static final String RESET_CREDENTIALS_PATH = "reset-credentials";
    public static final String REQUIRED_ACTION = "required-action";
    public static final String FIRST_BROKER_LOGIN_PATH = "first-broker-login";
    public static final String POST_BROKER_LOGIN_PATH = "post-broker-login";
    public static final String RESTART_PATH = "restart";
    public static final String FORWARDED_ERROR_MESSAGE_NOTE = "forwardedErrorMessage";
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    @Context
    protected Providers providers;
    @Context
    protected KeycloakSession session;
    private EventBuilder event;

    public static UriBuilder loginActionsBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return LoginActionsService.loginActionsBaseUrl(baseUriBuilder);
    }

    public static UriBuilder authenticationFormProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "authenticateForm");
    }

    public static UriBuilder requiredActionProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "requiredActionPOST");
    }

    public static UriBuilder actionTokenProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "executeActionToken");
    }

    public static UriBuilder registrationFormProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "processRegister");
    }

    public static UriBuilder firstBrokerLoginProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "firstBrokerLoginGet");
    }

    public static UriBuilder postBrokerLoginProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "postBrokerLoginGet");
    }

    public static UriBuilder loginActionsBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getLoginActionsService");
    }

    public LoginActionsService(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.event = event;
        CacheControlUtil.noBackButtonCacheControlHeader();
    }

    private boolean checkSsl() {
        if (this.uriInfo.getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }

    private SessionCodeChecks checksForCode(String code, String execution, String clientId, String flowPath) {
        SessionCodeChecks res = new SessionCodeChecks(this.realm, this.uriInfo, this.request, this.clientConnection, this.session, this.event, code, execution, clientId, flowPath);
        res.initialVerify();
        return res;
    }

    protected URI getLastExecutionUrl(String flowPath, String executionId, String clientId) {
        return new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).getLastExecutionUrl(flowPath, executionId, clientId);
    }

    @Path(value="restart")
    @GET
    public Response restartSession(@QueryParam(value="client_id") String clientId) {
        this.event.event(EventType.RESTART_AUTHENTICATION);
        SessionCodeChecks checks = new SessionCodeChecks(this.realm, this.uriInfo, this.request, this.clientConnection, this.session, this.event, null, null, clientId, null);
        AuthenticationSessionModel authSession = checks.initialVerifyAuthSession();
        if (authSession == null) {
            return checks.getResponse();
        }
        String flowPath = authSession.getClientNote("APP_INITIATED_FLOW");
        if (flowPath == null) {
            flowPath = AUTHENTICATE_PATH;
        }
        AuthenticationProcessor.resetFlow(authSession, flowPath);
        URI redirectUri = this.getLastExecutionUrl(flowPath, null, authSession.getClient().getClientId());
        logger.debugf("Flow restart requested. Redirecting to %s", (Object)redirectUri);
        return Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
    }

    @Path(value="authenticate")
    @GET
    public Response authenticate(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        this.event.event(EventType.LOGIN);
        SessionCodeChecks checks = this.checksForCode(code, execution, clientId, AUTHENTICATE_PATH);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        boolean actionRequest = checks.isActionRequest();
        return this.processAuthentication(actionRequest, execution, authSession, null);
    }

    protected Response processAuthentication(boolean action, String execution, AuthenticationSessionModel authSession, String errorMessage) {
        return this.processFlow(action, execution, authSession, AUTHENTICATE_PATH, this.realm.getBrowserFlow(), errorMessage, new AuthenticationProcessor());
    }

    protected Response processFlow(boolean action, String execution, AuthenticationSessionModel authSession, String flowPath, AuthenticationFlowModel flow, String errorMessage, AuthenticationProcessor processor) {
        Response response;
        String forwardedErrorMessage;
        processor.setAuthenticationSession(authSession).setFlowPath(flowPath).setBrowserFlow(true).setFlowId(flow.getId()).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        if (errorMessage != null) {
            processor.setForwardedErrorMessage(new FormMessage(null, errorMessage));
        }
        if ((forwardedErrorMessage = authSession.getAuthNote(FORWARDED_ERROR_MESSAGE_NOTE)) != null) {
            authSession.removeAuthNote(FORWARDED_ERROR_MESSAGE_NOTE);
            processor.setForwardedErrorMessage(new FormMessage(null, forwardedErrorMessage));
        }
        try {
            response = action ? processor.authenticationAction(execution) : processor.authenticate();
        }
        catch (WebApplicationException e) {
            response = e.getResponse();
            authSession = processor.getAuthenticationSession();
        }
        catch (Exception e) {
            response = processor.handleBrowserException(e);
            authSession = processor.getAuthenticationSession();
        }
        return BrowserHistoryHelper.getInstance().saveResponseAndRedirect(this.session, authSession, response, action, this.request);
    }

    @Path(value="authenticate")
    @POST
    public Response authenticateForm(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        return this.authenticate(code, execution, clientId);
    }

    @Path(value="reset-credentials")
    @POST
    public Response resetCredentialsPOST(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="key") String key) {
        if (key != null) {
            return this.handleActionToken(key, execution, clientId);
        }
        this.event.event(EventType.RESET_PASSWORD);
        return this.resetCredentials(code, execution, clientId);
    }

    @Path(value="reset-credentials")
    @GET
    public Response resetCredentialsGET(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        AuthenticationSessionModel authSession = new AuthenticationSessionManager(this.session).getCurrentAuthenticationSession(this.realm);
        if (authSession == null && code == null) {
            if (!this.realm.isResetPasswordAllowed()) {
                this.event.event(EventType.RESET_PASSWORD);
                this.event.error("not_allowed");
                return ErrorPage.error(this.session, "resetCredentialNotAllowedMessage", new Object[0]);
            }
            authSession = this.createAuthenticationSessionForClient();
            return this.processResetCredentials(false, null, authSession, null);
        }
        this.event.event(EventType.RESET_PASSWORD);
        return this.resetCredentials(code, execution, clientId);
    }

    AuthenticationSessionModel createAuthenticationSessionForClient() throws UriBuilderException, IllegalArgumentException {
        ClientModel client = this.realm.getClientByClientId("account");
        AuthenticationSessionModel authSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, client, true);
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setProtocol("openid-connect");
        String redirectUri = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString();
        authSession.setRedirectUri(redirectUri);
        authSession.setClientNote("response_type", "code");
        authSession.setClientNote("redirect_uri", redirectUri);
        authSession.setClientNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        return authSession;
    }

    protected Response resetCredentials(String code, String execution, String clientId) {
        SessionCodeChecks checks = this.checksForCode(code, execution, clientId, RESET_CREDENTIALS_PATH);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.USER)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        if (!this.realm.isResetPasswordAllowed()) {
            this.event.error("not_allowed");
            return ErrorPage.error(this.session, "resetCredentialNotAllowedMessage", new Object[0]);
        }
        return this.processResetCredentials(checks.isActionRequest(), execution, authSession, null);
    }

    @Path(value="action-token")
    @GET
    public Response executeActionToken(@QueryParam(value="key") String key, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        return this.handleActionToken(key, execution, clientId);
    }

    protected <T extends JsonWebToken> Response handleActionToken(String tokenString, String execution, String clientId) {
        JsonWebToken token;
        ActionTokenHandler<Object> handler;
        String eventError = null;
        String defaultErrorMessage = null;
        AuthenticationSessionModel authSession = new AuthenticationSessionManager(this.session).getCurrentAuthenticationSession(this.realm);
        this.event.event(EventType.EXECUTE_ACTION_TOKEN);
        ClientModel client = null;
        if (clientId != null) {
            client = this.realm.getClientByClientId(clientId);
        }
        if (client != null) {
            this.session.getContext().setClient(client);
        }
        try {
            if (tokenString == null) {
                throw new ExplainedTokenVerificationException(null, "not_allowed", "invalidRequestMessage");
            }
            TokenVerifier tokenVerifier = TokenVerifier.create((String)tokenString, DefaultActionTokenKey.class);
            DefaultActionTokenKey aToken = (DefaultActionTokenKey)tokenVerifier.getToken();
            this.event.detail("token_id", aToken.getId()).detail("action", aToken.getActionId()).user(aToken.getUserId());
            handler = this.resolveActionTokenHandler(aToken.getActionId());
            eventError = handler.getDefaultEventError();
            defaultErrorMessage = handler.getDefaultErrorMessage();
            if (!this.realm.isEnabled()) {
                throw new ExplainedTokenVerificationException((JsonWebToken)aToken, "realm_disabled", "realmNotEnabledMessage");
            }
            if (!this.checkSsl()) {
                throw new ExplainedTokenVerificationException((JsonWebToken)aToken, "ssl_required", "httpsRequiredMessage");
            }
            tokenVerifier.withChecks(new TokenVerifier.Predicate[]{TokenVerifier.IS_ACTIVE, new TokenVerifier.RealmUrlCheck(Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName())), DefaultActionToken.ACTION_TOKEN_BASIC_CHECKS}).secretKey(this.session.keys().getActiveHmacKey(this.realm).getSecretKey()).verify();
            token = TokenVerifier.create((String)tokenString, handler.getTokenClass()).getToken();
        }
        catch (TokenNotActiveException ex) {
            if (authSession != null) {
                this.event.clone().error("expired_code");
                String flowPath = authSession.getClientNote("APP_INITIATED_FLOW");
                if (flowPath == null) {
                    flowPath = AUTHENTICATE_PATH;
                }
                AuthenticationProcessor.resetFlow(authSession, flowPath);
                return this.processFlowFromPath(flowPath, authSession, "expiredActionTokenSessionExistsMessage");
            }
            return this.handleActionTokenVerificationException(null, (VerificationException)((Object)ex), "expired_code", "expiredActionTokenNoSessionMessage");
        }
        catch (ExplainedTokenVerificationException ex) {
            return this.handleActionTokenVerificationException(null, (VerificationException)((Object)ex), ex.getErrorEvent(), ex.getMessage());
        }
        catch (ExplainedVerificationException ex) {
            return this.handleActionTokenVerificationException(null, ex, ex.getErrorEvent(), ex.getMessage());
        }
        catch (VerificationException ex) {
            return this.handleActionTokenVerificationException(null, ex, eventError, defaultErrorMessage);
        }
        ActionTokenContext<T> tokenContext = new ActionTokenContext<T>(this.session, this.realm, this.uriInfo, this.clientConnection, this.request, this.event, handler, execution, this::processFlow, this::brokerLoginFlow);
        try {
            String tokenAuthSessionId = handler.getAuthenticationSessionIdFromToken(token, tokenContext);
            if (tokenAuthSessionId != null) {
                LoginActionsServiceChecks.checkNotLoggedInYet(tokenContext, tokenAuthSessionId);
            }
            if (authSession == null) {
                authSession = handler.startFreshAuthenticationSession(token, tokenContext);
                tokenContext.setAuthenticationSession(authSession, true);
            } else if (tokenAuthSessionId == null || !LoginActionsServiceChecks.doesAuthenticationSessionFromCookieMatchOneFromToken(tokenContext, tokenAuthSessionId)) {
                logger.debugf("Authentication session in progress but no authentication session ID was found in action token %s, restarting.", (Object)token.getId());
                new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, false);
                authSession = handler.startFreshAuthenticationSession(token, tokenContext);
                tokenContext.setAuthenticationSession(authSession, true);
            }
            this.initLoginEvent(authSession);
            this.event.event(handler.eventType());
            LoginActionsServiceChecks.checkIsUserValid(token, tokenContext);
            LoginActionsServiceChecks.checkIsClientValid(token, tokenContext);
            this.session.getContext().setClient(authSession.getClient());
            TokenVerifier.create((JsonWebToken)token).withChecks(handler.getVerifiers(tokenContext)).verify();
            authSession = tokenContext.getAuthenticationSession();
            this.event = tokenContext.getEvent();
            this.event.event(handler.eventType());
            if (!handler.canUseTokenRepeatedly(token, tokenContext)) {
                LoginActionsServiceChecks.checkTokenWasNotUsedYet(token, tokenContext);
                authSession.setAuthNote("INVALIDATE_ACTION_TOKEN", ((ActionTokenKeyModel)token).serializeKey());
            }
            authSession.setAuthNote("ACTION_TOKEN_USER", ((ActionTokenKeyModel)token).getUserId());
            return handler.handleToken(token, tokenContext);
        }
        catch (ExplainedTokenVerificationException ex) {
            return this.handleActionTokenVerificationException(tokenContext, (VerificationException)((Object)ex), ex.getErrorEvent(), ex.getMessage());
        }
        catch (LoginActionsServiceException ex) {
            Response response = ex.getResponse();
            return response == null ? this.handleActionTokenVerificationException(tokenContext, ex, eventError, defaultErrorMessage) : response;
        }
        catch (VerificationException ex) {
            return this.handleActionTokenVerificationException(tokenContext, ex, eventError, defaultErrorMessage);
        }
    }

    private Response processFlowFromPath(String flowPath, AuthenticationSessionModel authSession, String errorMessage) {
        if (AUTHENTICATE_PATH.equals(flowPath)) {
            return this.processAuthentication(false, null, authSession, errorMessage);
        }
        if (REGISTRATION_PATH.equals(flowPath)) {
            return this.processRegistration(false, null, authSession, errorMessage);
        }
        if (RESET_CREDENTIALS_PATH.equals(flowPath)) {
            return this.processResetCredentials(false, null, authSession, errorMessage);
        }
        return ErrorPage.error(this.session, errorMessage == null ? "invalidRequestMessage" : errorMessage, new Object[0]);
    }

    private <T extends JsonWebToken> ActionTokenHandler<T> resolveActionTokenHandler(String actionId) throws VerificationException {
        if (actionId == null) {
            throw new VerificationException("Action token operation not set");
        }
        ActionTokenHandler handler = (ActionTokenHandler)this.session.getProvider(ActionTokenHandler.class, actionId);
        if (handler == null) {
            throw new VerificationException("Invalid action token operation");
        }
        return handler;
    }

    private Response handleActionTokenVerificationException(ActionTokenContext<?> tokenContext, VerificationException ex, String eventError, String errorMessage) {
        if (tokenContext != null && tokenContext.getAuthenticationSession() != null) {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, tokenContext.getAuthenticationSession(), true);
        }
        this.event.detail("reason", ex == null ? "<unknown>" : ex.getMessage()).error(eventError == null ? "invalid_code" : eventError);
        return ErrorPage.error(this.session, errorMessage == null ? "invalidCodeMessage" : errorMessage, new Object[0]);
    }

    protected Response processResetCredentials(boolean actionRequest, String execution, AuthenticationSessionModel authSession, String errorMessage) {
        ResetCredentialsActionTokenHandler.ResetCredsAuthenticationProcessor authProcessor = new ResetCredentialsActionTokenHandler.ResetCredsAuthenticationProcessor();
        return this.processFlow(actionRequest, execution, authSession, RESET_CREDENTIALS_PATH, this.realm.getResetCredentialsFlow(), errorMessage, authProcessor);
    }

    protected Response processRegistration(boolean action, String execution, AuthenticationSessionModel authSession, String errorMessage) {
        return this.processFlow(action, execution, authSession, REGISTRATION_PATH, this.realm.getRegistrationFlow(), errorMessage, new AuthenticationProcessor());
    }

    @Path(value="registration")
    @GET
    public Response registerPage(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        return this.registerRequest(code, execution, clientId, false);
    }

    @Path(value="registration")
    @POST
    public Response processRegister(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        return this.registerRequest(code, execution, clientId, true);
    }

    private Response registerRequest(String code, String execution, String clientId, boolean isPostRequest) {
        this.event.event(EventType.REGISTER);
        if (!this.realm.isRegistrationAllowed()) {
            this.event.error("registration_disabled");
            return ErrorPage.error(this.session, "registrationNotAllowedMessage", new Object[0]);
        }
        SessionCodeChecks checks = this.checksForCode(code, execution, clientId, REGISTRATION_PATH);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        return this.processRegistration(checks.isActionRequest(), execution, authSession, null);
    }

    @Path(value="first-broker-login")
    @GET
    public Response firstBrokerLoginGet(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        return this.brokerLoginFlow(code, execution, clientId, FIRST_BROKER_LOGIN_PATH);
    }

    @Path(value="first-broker-login")
    @POST
    public Response firstBrokerLoginPost(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        return this.brokerLoginFlow(code, execution, clientId, FIRST_BROKER_LOGIN_PATH);
    }

    @Path(value="post-broker-login")
    @GET
    public Response postBrokerLoginGet(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        return this.brokerLoginFlow(code, execution, clientId, POST_BROKER_LOGIN_PATH);
    }

    @Path(value="post-broker-login")
    @POST
    public Response postBrokerLoginPost(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId) {
        return this.brokerLoginFlow(code, execution, clientId, POST_BROKER_LOGIN_PATH);
    }

    protected Response brokerLoginFlow(String code, String execution, String clientId, String flowPath) {
        String flowId;
        final boolean firstBrokerLogin = flowPath.equals(FIRST_BROKER_LOGIN_PATH);
        EventType eventType = firstBrokerLogin ? EventType.IDENTITY_PROVIDER_FIRST_LOGIN : EventType.IDENTITY_PROVIDER_POST_LOGIN;
        this.event.event(eventType);
        SessionCodeChecks checks = this.checksForCode(code, execution, clientId, flowPath);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.getResponse();
        }
        this.event.detail("code_id", code);
        final AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        String noteKey = firstBrokerLogin ? "BROKERED_CONTEXT" : "PBL_BROKERED_IDENTITY_CONTEXT";
        SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authSession, noteKey);
        if (serializedCtx == null) {
            ServicesLogger.LOGGER.notFoundSerializedCtxInClientSession(noteKey);
            throw new WebApplicationException(ErrorPage.error(this.session, "Not found serialized context in authenticationSession.", new Object[0]));
        }
        BrokeredIdentityContext brokerContext = serializedCtx.deserialize(this.session, authSession);
        final String identityProviderAlias = brokerContext.getIdpConfig().getAlias();
        String string = flowId = firstBrokerLogin ? brokerContext.getIdpConfig().getFirstBrokerLoginFlowId() : brokerContext.getIdpConfig().getPostBrokerLoginFlowId();
        if (flowId == null) {
            ServicesLogger.LOGGER.flowNotConfigForIDP(identityProviderAlias);
            throw new WebApplicationException(ErrorPage.error(this.session, "Flow not configured for identity provider", new Object[0]));
        }
        AuthenticationFlowModel brokerLoginFlow = this.realm.getAuthenticationFlowById(flowId);
        if (brokerLoginFlow == null) {
            ServicesLogger.LOGGER.flowNotFoundForIDP(flowId, identityProviderAlias);
            throw new WebApplicationException(ErrorPage.error(this.session, "Flow not found for identity provider", new Object[0]));
        }
        this.event.detail("identity_provider", identityProviderAlias).detail("identity_provider_identity", brokerContext.getUsername());
        AuthenticationProcessor processor = new AuthenticationProcessor(){

            @Override
            protected Response authenticationComplete() {
                if (firstBrokerLogin) {
                    authSession.setAuthNote("FIRST_BROKER_LOGIN_SUCCESS", identityProviderAlias);
                } else {
                    String authStateNoteKey = "PBL_AUTH_STATE." + identityProviderAlias;
                    authSession.setAuthNote(authStateNoteKey, "true");
                }
                return LoginActionsService.this.redirectToAfterBrokerLoginEndpoint(authSession, firstBrokerLogin);
            }
        };
        return this.processFlow(checks.isActionRequest(), execution, authSession, flowPath, brokerLoginFlow, null, processor);
    }

    private Response redirectToAfterBrokerLoginEndpoint(AuthenticationSessionModel authSession, boolean firstBrokerLogin) {
        return LoginActionsService.redirectToAfterBrokerLoginEndpoint(this.session, this.realm, this.uriInfo, authSession, firstBrokerLogin);
    }

    public static Response redirectToAfterBrokerLoginEndpoint(KeycloakSession session, RealmModel realm, UriInfo uriInfo, AuthenticationSessionModel authSession, boolean firstBrokerLogin) {
        ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(session, realm, authSession);
        authSession.setTimestamp(Time.currentTime());
        String clientId = authSession.getClient().getClientId();
        URI redirect = firstBrokerLogin ? Urls.identityProviderAfterFirstBrokerLogin(uriInfo.getBaseUri(), realm.getName(), accessCode.getCode(), clientId) : Urls.identityProviderAfterPostBrokerLogin(uriInfo.getBaseUri(), realm.getName(), accessCode.getCode(), clientId);
        logger.debugf("Redirecting to '%s' ", (Object)redirect);
        return Response.status((int)302).location(redirect).build();
    }

    @Path(value="consent")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processConsent(MultivaluedMap<String, String> formData) {
        this.event.event(EventType.LOGIN);
        String code = (String)formData.getFirst((Object)"code");
        String clientId = (String)this.uriInfo.getQueryParameters().getFirst((Object)"client_id");
        SessionCodeChecks checks = this.checksForCode(code, null, clientId, REQUIRED_ACTION);
        if (!checks.verifyRequiredAction(CommonClientSessionModel.Action.OAUTH_GRANT.name())) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        this.initLoginEvent(authSession);
        UserModel user = authSession.getAuthenticatedUser();
        ClientModel client = authSession.getClient();
        if (formData.containsKey((Object)"cancel")) {
            LoginProtocol protocol = (LoginProtocol)this.session.getProvider(LoginProtocol.class, authSession.getProtocol());
            protocol.setRealm(this.realm).setHttpHeaders(this.headers).setUriInfo(this.uriInfo).setEventBuilder(this.event);
            Response response = protocol.sendError(authSession, LoginProtocol.Error.CONSENT_DENIED);
            this.event.error("rejected_by_user");
            return response;
        }
        UserConsentModel grantedConsent = this.session.users().getConsentByClient(this.realm, user.getId(), client.getId());
        if (grantedConsent == null) {
            grantedConsent = new UserConsentModel(client);
            this.session.users().addConsent(this.realm, user.getId(), grantedConsent);
        }
        for (RoleModel role : ClientSessionCode.getRequestedRoles((CommonClientSessionModel)authSession, this.realm)) {
            grantedConsent.addGrantedRole(role);
        }
        for (ProtocolMapperModel protocolMapper : ClientSessionCode.getRequestedProtocolMappers(authSession.getProtocolMappers(), client)) {
            if (!protocolMapper.isConsentRequired() || protocolMapper.getConsentText() == null) continue;
            grantedConsent.addGrantedProtocolMapper(protocolMapper);
        }
        this.session.users().updateConsent(this.realm, user.getId(), grantedConsent);
        this.event.detail("consent", "consent_granted");
        this.event.success();
        AuthenticatedClientSessionModel clientSession = AuthenticationProcessor.attachSession(authSession, null, this.session, this.realm, this.clientConnection, this.event);
        return AuthenticationManager.redirectAfterSuccessfulFlow(this.session, this.realm, clientSession.getUserSession(), clientSession, this.request, this.uriInfo, this.clientConnection, this.event, authSession.getProtocol());
    }

    private void initLoginEvent(AuthenticationSessionModel authSession) {
        String rememberMe;
        String attemptedUsername;
        String responseType = authSession.getClientNote("response_type");
        if (responseType == null) {
            responseType = "code";
        }
        String respMode = authSession.getClientNote("response_mode");
        OIDCResponseMode responseMode = OIDCResponseMode.parse(respMode, OIDCResponseType.parse(responseType));
        this.event.event(EventType.LOGIN).client(authSession.getClient()).detail("code_id", authSession.getId()).detail("redirect_uri", authSession.getRedirectUri()).detail("auth_method", authSession.getProtocol()).detail("response_type", responseType).detail("response_mode", responseMode.toString().toLowerCase());
        UserModel authenticatedUser = authSession.getAuthenticatedUser();
        if (authenticatedUser != null) {
            this.event.user(authenticatedUser).detail("username", authenticatedUser.getUsername());
        }
        if ((attemptedUsername = authSession.getAuthNote("ATTEMPTED_USERNAME")) != null) {
            this.event.detail("username", attemptedUsername);
        }
        if ((rememberMe = authSession.getAuthNote("remember_me")) == null || !rememberMe.equalsIgnoreCase("true")) {
            rememberMe = "false";
        }
        this.event.detail("remember_me", rememberMe);
        Map userSessionNotes = authSession.getUserSessionNotes();
        String identityProvider = (String)userSessionNotes.get("identity_provider");
        if (identityProvider != null) {
            this.event.detail("identity_provider", identityProvider).detail("identity_provider_identity", (String)userSessionNotes.get("identity_provider_identity"));
        }
    }

    @Path(value="required-action")
    @POST
    public Response requiredActionPOST(@QueryParam(value="code") String code, @QueryParam(value="execution") String action, @QueryParam(value="client_id") String clientId) {
        return this.processRequireAction(code, action, clientId);
    }

    @Path(value="required-action")
    @GET
    public Response requiredActionGET(@QueryParam(value="code") String code, @QueryParam(value="execution") String action, @QueryParam(value="client_id") String clientId) {
        return this.processRequireAction(code, action, clientId);
    }

    private Response processRequireAction(String code, String action, String clientId) {
        Response response;
        this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
        SessionCodeChecks checks = this.checksForCode(code, action, clientId, REQUIRED_ACTION);
        if (!checks.verifyRequiredAction(action)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        if (!checks.isActionRequest()) {
            this.initLoginEvent(authSession);
            this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
            return AuthenticationManager.nextActionAfterAuthentication(this.session, authSession, this.clientConnection, this.request, this.uriInfo, this.event);
        }
        this.initLoginEvent(authSession);
        this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
        this.event.detail("custom_required_action", action);
        RequiredActionFactory factory = (RequiredActionFactory)this.session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, action);
        if (factory == null) {
            ServicesLogger.LOGGER.actionProviderNull();
            this.event.error("invalid_code");
            throw new WebApplicationException(ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]));
        }
        RequiredActionProvider provider = (RequiredActionProvider)factory.create(this.session);
        RequiredActionContextResult context = new RequiredActionContextResult(authSession, this.realm, this.event, this.session, this.request, authSession.getAuthenticatedUser(), factory){

            @Override
            public void ignore() {
                throw new RuntimeException("Cannot call ignore within processAction()");
            }
        };
        provider.processAction((RequiredActionContext)context);
        if (action != null) {
            authSession.setAuthNote("last.processed.execution", action);
        }
        if (context.getStatus() == RequiredActionContext.Status.SUCCESS) {
            this.event.clone().success();
            this.initLoginEvent(authSession);
            this.event.event(EventType.LOGIN);
            authSession.removeRequiredAction(factory.getId());
            authSession.getAuthenticatedUser().removeRequiredAction(factory.getId());
            authSession.removeAuthNote("current.authentication.execution");
            response = AuthenticationManager.nextActionAfterAuthentication(this.session, authSession, this.clientConnection, this.request, this.uriInfo, this.event);
        } else if (context.getStatus() == RequiredActionContext.Status.CHALLENGE) {
            response = context.getChallenge();
        } else if (context.getStatus() == RequiredActionContext.Status.FAILURE) {
            LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, authSession.getProtocol());
            protocol.setRealm(context.getRealm()).setHttpHeaders(context.getHttpRequest().getHttpHeaders()).setUriInfo(context.getUriInfo()).setEventBuilder(this.event);
            this.event.detail("custom_required_action", action);
            response = protocol.sendError(authSession, LoginProtocol.Error.CONSENT_DENIED);
            this.event.error("rejected_by_user");
        } else {
            throw new RuntimeException("Unreachable");
        }
        return BrowserHistoryHelper.getInstance().saveResponseAndRedirect(this.session, authSession, response, true, this.request);
    }
}

