/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.representations.VersionRepresentation;
import org.keycloak.services.resources.Cors;

@Path(value="/version")
public class ServerVersionResource {
    protected static final Logger logger = Logger.getLogger(ServerVersionResource.class);
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;

    @OPTIONS
    @Produces(value={"application/json"})
    public Response getVersionPreflight() {
        logger.debugv("cors request from: {0}", this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)"Origin"));
        return Cors.add(this.request, Response.ok()).allowedMethods("GET").auth().preflight().build();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public VersionRepresentation getVersion() {
        Cors.add(this.request).allowedOrigins("*").allowedMethods("GET").auth().build(this.response);
        return VersionRepresentation.SINGLETON;
    }
}

