/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.bitbucket;

import com.fasterxml.jackson.databind.JsonNode;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.models.KeycloakSession;

public class BitbucketIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String AUTH_URL = "https://bitbucket.org/site/oauth2/authorize";
    public static final String TOKEN_URL = "https://bitbucket.org/site/oauth2/access_token";
    public static final String USER_URL = "https://api.bitbucket.org/2.0/user";
    public static final String EMAIL_SCOPE = "email";
    public static final String ACCOUNT_SCOPE = "account";
    public static final String DEFAULT_SCOPE = "account";

    public BitbucketIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        String defaultScope = config.getDefaultScope();
        if (defaultScope == null || defaultScope.trim().equals("")) {
            config.setDefaultScope("account");
        }
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = SimpleHttp.doGet((String)USER_URL, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken).asJson();
            String type = this.getJsonProperty(profile, "type");
            if (type == null) {
                throw new IdentityBrokerException("Could not obtain account information from bitbucket.");
            }
            if (type.equals("error")) {
                JsonNode errorNode = profile.get("error");
                if (errorNode != null) {
                    String errorMsg = this.getJsonProperty(errorNode, "message");
                    throw new IdentityBrokerException("Could not obtain account information from bitbucket.  Error: " + errorMsg);
                }
                throw new IdentityBrokerException("Could not obtain account information from bitbucket.");
            }
            if (!type.equals("user")) {
                logger.debug((Object)("Unknown object type: " + type));
                throw new IdentityBrokerException("Could not obtain account information from bitbucket.");
            }
            BrokeredIdentityContext user = new BrokeredIdentityContext(this.getJsonProperty(profile, "account_id"));
            String username = this.getJsonProperty(profile, "username");
            user.setUsername(username);
            user.setIdpConfig(this.getConfig());
            user.setIdp((IdentityProvider)this);
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
            return user;
        }
        catch (Exception e) {
            if (e instanceof IdentityBrokerException) {
                throw (IdentityBrokerException)e;
            }
            throw new IdentityBrokerException("Could not obtain user profile from github.", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return "account";
    }
}

