/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron._private;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.NoSuchProviderException;
import java.security.Policy;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYELY", length=5)
public interface ElytronSubsystemMessages
extends BasicLogger {
    public static final ElytronSubsystemMessages ROOT_LOGGER = (ElytronSubsystemMessages)Logger.getMessageLogger(ElytronSubsystemMessages.class, (String)"org.wildfly.extension.elytron");

    @Message(id=2, value="Can not inject the same realm '%s' in a single security domain.")
    public OperationFailedException duplicateRealmInjection(String var1);

    @Message(id=3, value="The operation did not contain an address with a value for '%s'.")
    public IllegalArgumentException operationAddressMissingKey(String var1);

    @Message(id=4, value="Unable to start the service.")
    public StartException unableToStartService(@Cause Exception var1);

    @Message(id=5, value="Unable to access KeyStore to complete the requested operation.")
    public OperationFailedException unableToAccessKeyStore(@Cause Exception var1);

    @Message(id=7, value="The required service '%s' is not UP, it is currently '%s'.")
    public OperationFailedException requiredServiceNotUp(ServiceName var1, ServiceController.State var2);

    @Message(id=8, value="Invalid operation name '%s', expected one of '%s'")
    public OperationFailedException invalidOperationName(String var1, String ... var2);

    @Message(id=9, value="Unable to complete operation. '%s'")
    public RuntimeException unableToCompleteOperation(@Cause Throwable var1, String var2);

    @Message(id=10, value="Unable to save KeyStore - KeyStore file '%s' does not exist.")
    public OperationFailedException cantSaveWithoutFile(String var1);

    @Message(id=12, value="No suitable provider found for type '%s'")
    public StartException noSuitableProvider(String var1);

    @Message(id=13, value="The default-realm '%s' is not in the list of realms [%s] referenced by this domain.")
    public OperationFailedException defaultRealmNotReferenced(String var1, String var2);

    @Message(id=14, value="Unable to load the properties files required to start the properties file backed realm: Users file: '%s' Groups file: '%s'")
    public StartException unableToLoadPropertiesFiles(@Cause Exception var1, String var2, String var3);

    @Message(id=15, value="The custom component implementation '%s' doe not implement 'org.wildfly.extension.elytron.Configurable' however configuration has been supplied.")
    public StartException componentNotConfigurable(String var1);

    @Message(id=16, value="The supplied regular expression '%s' is invalid.")
    public OperationFailedException invalidRegularExpression(String var1, @Cause Exception var2);

    @Message(id=17, value="Property file referenced in properties-realm does not exist: %s")
    public StartException propertyFilesDoesNotExist(String var1);

    @Message(id=18, value="Unable to create %s for algorithm '%s'.")
    public StartException unableToCreateManagerFactory(String var1, String var2);

    @Message(id=19, value="No '%s' found in injected value.")
    public StartException noTypeFound(String var1);

    @Message(id=20, value="Unable to reload the properties files required to by the properties file backed realm.")
    public OperationFailedException unableToReLoadPropertiesFiles(@Cause Exception var1);

    @Message(id=21, value="Exception while creating the permission object for the permission mapping. Please check [class-name], [target-name] (name of permission) and [action] of [%s].")
    public StartException exceptionWhileCreatingPermission(String var1, @Cause Throwable var2);

    @Message(id=22, value="KeyStore file '%s' does not exist and required.")
    public StartException keyStoreFileNotExists(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23, value="KeyStore file '%s' does not exist. Used blank.")
    public void keyStoreFileNotExistsButIgnored(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=24, value="Certificate [%s] in KeyStore is not valid")
    public void certificateNotValid(String var1, @Cause Exception var2);

    @Message(id=25, value="Referenced property file is invalid: %s")
    public StartException propertyFileIsInvalid(String var1, @Cause Throwable var2);

    @Message(id=27, value="Unable to obtain OID for X.500 attribute '%s'")
    public OperationFailedException unableToObtainOidForX500Attribute(String var1);

    @Message(id=28, value="The X.500 attribute must be defined by name or by OID")
    public OperationFailedException x500AttributeMustBeDefined();

    @Message(id=29, value="Failed to parse URL '%s'")
    public OperationFailedException invalidURL(String var1, @Cause Exception var2);

    @Message(id=30, value="Realm '%s' does not support cache")
    public StartException realmDoesNotSupportCache(String var1);

    @Message(id=31, value="Unable to access CRL file.")
    public StartException unableToAccessCRL(@Cause Exception var1);

    @Message(id=32, value="Unable to reload CRL file.")
    public RuntimeException unableToReloadCRL(@Cause Exception var1);

    @Message(id=33, value="Unable to access entry [%s] from key store [%s].")
    public RuntimeException unableToAccessEntryFromKeyStore(String var1, String var2);

    @Message(id=34, value="A principal query can only have a single key mapper")
    public OperationFailedException jdbcRealmOnlySingleKeyMapperAllowed();

    @Message(id=35, value="Unable to load module '%s'.")
    public OperationFailedException unableToLoadModule(String var1, @Cause Exception var2);

    @Message(id=36, value="Security realm '%s' has been referenced twice in the same security domain.")
    public OperationFailedException realmRefererencedTwice(String var1);

    @Message(id=37, value="Injected value is not of '%s' type.")
    public StartException invalidTypeInjected(String var1);

    @Message(id=909, value="Credential store '%s' does not support given credential store entry type '%s'")
    public OperationFailedException credentialStoreEntryTypeNotSupported(String var1, String var2);

    @Message(id=910, value="Password cannot be resolved for key-store \"%s\"")
    public IOException keyStorePasswordCannotBeResolved(String var1);

    @Message(id=911, value="Credential store \"%s\" protection parameter cannot be resolved")
    public IOException credentialStoreProtectionParameterCannotBeResolved(String var1);

    @Message(id=913, value="Credential alias \"%s\" of credential type \"%s\" already exists in the store")
    public OperationFailedException credentialAlreadyExists(String var1, String var2);

    @Message(id=914, value="Provider loader \"%s\" cannot supply Credential Store provider of type \"%s\"")
    public NoSuchProviderException providerLoaderCannotSupplyProvider(String var1, String var2);

    @Message(id=916, value="Credential cannot be resolved")
    public IllegalStateException credentialCannotBeResolved();

    @Message(id=917, value="Password cannot be resolved for dir-context")
    public StartException dirContextPasswordCannotBeResolved(@Cause Exception var1);

    @Message(id=920, value="Credential alias \"%s\" of credential type \"%s\" does not exist in the store")
    public OperationFailedException credentialDoesNotExist(String var1, String var2);

    @Message(id=0, value="Reload dependent services which might already have cached the secret value")
    public String reloadDependantServices();

    @Message(id=0, value="Update dependent resources as alias \"%s\" does not exist anymore")
    public String updateDependantServices(String var1);

    @Message(id=1000, value="Identity with name [%s] already exists.")
    public OperationFailedException identityAlreadyExists(String var1);

    @Message(id=1001, value="Could not create identity with name [%s].")
    public RuntimeException couldNotCreateIdentity(String var1, @Cause Exception var2);

    @Message(id=1002, value="Identity with name [%s] not found.")
    public String identityNotFound(String var1);

    @Message(id=1003, value="Could not delete identity with name [%s].")
    public RuntimeException couldNotDeleteIdentity(String var1, @Cause Exception var2);

    @Message(id=1004, value="Identity with name [%s] not authorized.")
    public String identityNotAuthorized(String var1);

    @Message(id=1005, value="Could not read identity [%s] from security domain [%s].")
    public RuntimeException couldNotReadIdentity(String var1, ServiceName var2, @Cause Exception var3);

    @Message(id=1007, value="Could not read identity with name [%s].")
    public RuntimeException couldNotReadIdentity(String var1, @Cause Exception var2);

    @Message(id=1008, value="Failed to obtain the authorization identity.")
    public RuntimeException couldNotObtainAuthorizationIdentity(@Cause Exception var1);

    @Message(id=1009, value="Failed to add attribute.")
    public RuntimeException couldNotAddAttribute(@Cause Exception var1);

    @Message(id=1010, value="Failed to remove attribute.")
    public RuntimeException couldNotRemoveAttribute(@Cause Exception var1);

    @Message(id=1011, value="Could not create password.")
    public RuntimeException couldNotCreatePassword(@Cause Exception var1);

    @Message(id=1012, value="Unexpected password type [%s].")
    public OperationFailedException unexpectedPasswordType(String var1);

    @Message(id=1013, value="Pattern [%s] requires a capture group")
    public OperationFailedException patternRequiresCaptureGroup(String var1);

    @Message(id=1014, value="Invalid [%s] definition. Only one of '%s' or '%s' can be set in one Object in the list of filters.")
    public OperationFailedException invalidDefinition(String var1, String var2, String var3);

    @Message(id=1015, value="Unable to perform automatic outflow for '%s'")
    public IllegalStateException unableToPerformOutflow(String var1, @Cause Exception var2);

    @Message(id=1016, value="Server '%s' not known")
    public OperationFailedException serverNotKnown(String var1, @Cause UnknownHostException var2);

    @Message(id=1017, value="Invalid value for cipher-suite-filter. %s")
    public OperationFailedException invalidCipherSuiteFilter(@Cause Throwable var1, String var2);

    @Message(id=1018, value="Invalid size %s")
    public OperationFailedException invalidSize(String var1);

    @Message(id=1019, value="The suffix (%s) can not contain seconds or milliseconds.")
    public OperationFailedException suffixContainsMillis(String var1);

    @Message(id=1020, value="The suffix (%s) is invalid. A suffix must be a valid date format.")
    public OperationFailedException invalidSuffix(String var1);

    @Message(id=1021, value="Cannot remove the default policy provider [%s]")
    public OperationFailedException cannotRemoveDefaultPolicy(String var1);

    @Message(id=1022, value="Failed to set policy [%s]")
    public RuntimeException failedToSetPolicy(Policy var1, @Cause Exception var2);

    @Message(id=1023, value="Could not find policy provider with name [%s]")
    public OperationFailedException cannotFindPolicyProvider(String var1);

    @Message(id=1024, value="Failed to register policy context handlers")
    public RuntimeException failedToRegisterPolicyHandlers(@Cause Exception var1);

    @Message(id=1025, value="Failed to create policy [%s]")
    public RuntimeException failedToCreatePolicy(String var1, @Cause Exception var2);
}

