/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;

public class SimpleBuilder<T>
implements Builder<T> {
    private final ServiceName name;
    private final Service<T> service;

    public SimpleBuilder(ServiceName name, T value) {
        this(name, (Value<T>)new ImmediateValue(value));
    }

    public SimpleBuilder(ServiceName name, Value<T> value) {
        this(name, (Service<T>)new ValueService(value));
    }

    public SimpleBuilder(ServiceName name, Service<T> service) {
        this.name = name;
        this.service = service;
    }

    @Override
    public ServiceName getServiceName() {
        return this.name;
    }

    @Override
    public ServiceBuilder<T> build(ServiceTarget target) {
        return target.addService(this.name, this.service);
    }
}

