/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.transport.Address;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.sessions.StickySessionEncoderProvider;

public class InfinispanStickySessionEncoderProvider
implements StickySessionEncoderProvider {
    private final KeycloakSession session;
    private final String myNodeName;

    public InfinispanStickySessionEncoderProvider(KeycloakSession session, String myNodeName) {
        this.session = session;
        this.myNodeName = myNodeName;
    }

    public String encodeSessionId(String sessionId) {
        String nodeName = this.getNodeName(sessionId);
        if (nodeName != null) {
            return sessionId + '.' + nodeName;
        }
        return sessionId;
    }

    public String decodeSessionId(String encodedSessionId) {
        int index = encodedSessionId.indexOf(46);
        return index == -1 ? encodedSessionId : encodedSessionId.substring(0, index);
    }

    public void close() {
    }

    private String getNodeName(String sessionId) {
        InfinispanConnectionProvider ispnProvider = (InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = ispnProvider.getCache("authenticationSessions");
        DistributionManager distManager = cache.getAdvancedCache().getDistributionManager();
        if (distManager != null) {
            Address address = distManager.getPrimaryLocation((Object)sessionId);
            return address.toString();
        }
        return this.myNodeName;
    }
}

