/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.servlet.AbstractServletPipeline;
import com.google.inject.servlet.FilterChainInvocation;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.FilterPipeline;
import java.io.IOException;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public abstract class AbstractFilterPipeline
implements FilterPipeline {
    private final AbstractServletPipeline servletPipeline;
    private final Provider<ServletContext> servletContext;
    private final Injector injector;
    private volatile boolean initialized = false;

    protected abstract boolean hasFiltersMapped();

    protected abstract FilterDefinition[] filterDefinitions();

    protected AbstractFilterPipeline(Injector injector, AbstractServletPipeline servletPipeline, Provider<ServletContext> servletContext) {
        this.injector = injector;
        this.servletPipeline = servletPipeline;
        this.servletContext = servletContext;
    }

    @Override
    public synchronized void initPipeline(ServletContext servletContext) throws ServletException {
        if (this.initialized) {
            return;
        }
        Set initializedSoFar = Sets.newIdentityHashSet();
        for (FilterDefinition filterDefinition : this.filterDefinitions()) {
            filterDefinition.init(servletContext, this.injector, initializedSoFar);
        }
        this.servletPipeline.init(servletContext, this.injector);
        this.initialized = true;
    }

    @Override
    public void dispatch(ServletRequest request, ServletResponse response, FilterChain proceedingFilterChain) throws IOException, ServletException {
        if (!this.initialized) {
            this.initPipeline((ServletContext)this.servletContext.get());
        }
        new FilterChainInvocation(this.filterDefinitions(), this.servletPipeline, proceedingFilterChain).doFilter(AbstractFilterPipeline.withDispatcher(request, this.servletPipeline), response);
    }

    private static ServletRequest withDispatcher(ServletRequest servletRequest, final AbstractServletPipeline servletPipeline) {
        if (!servletPipeline.hasServletsMapped()) {
            return servletRequest;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        return new HttpServletRequestWrapper(request){

            public RequestDispatcher getRequestDispatcher(String path) {
                RequestDispatcher dispatcher = servletPipeline.getRequestDispatcher(path);
                return null != dispatcher ? dispatcher : super.getRequestDispatcher(path);
            }
        };
    }

    @Override
    public void destroyPipeline() {
        this.servletPipeline.destroy();
        Set destroyedSoFar = Sets.newIdentityHashSet();
        for (FilterDefinition filterDefinition : this.filterDefinitions()) {
            filterDefinition.destroy(destroyedSoFar);
        }
    }
}

