/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.Spans;

public abstract class FilterSpans
extends Spans {
    protected final Spans in;
    private boolean atFirstInCurrentDoc = false;
    private int startPos = -1;

    protected FilterSpans(Spans in) {
        this.in = Objects.requireNonNull(in);
    }

    protected abstract AcceptStatus accept(Spans var1) throws IOException;

    @Override
    public final int nextDoc() throws IOException {
        int doc;
        do {
            if ((doc = this.in.nextDoc()) != Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        } while (!this.twoPhaseCurrentDocMatches());
        return doc;
    }

    @Override
    public final int advance(int target) throws IOException {
        int doc = this.in.advance(target);
        while (doc != Integer.MAX_VALUE && !this.twoPhaseCurrentDocMatches()) {
            doc = this.in.nextDoc();
        }
        return doc;
    }

    @Override
    public final int docID() {
        return this.in.docID();
    }

    @Override
    public final int nextStartPosition() throws IOException {
        if (this.atFirstInCurrentDoc) {
            this.atFirstInCurrentDoc = false;
            return this.startPos;
        }
        while (true) {
            this.startPos = this.in.nextStartPosition();
            if (this.startPos == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            switch (this.accept(this.in)) {
                case YES: {
                    return this.startPos;
                }
                case NO: {
                    break;
                }
                case NO_MORE_IN_CURRENT_DOC: {
                    this.startPos = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
            }
        }
    }

    @Override
    public final int startPosition() {
        return this.atFirstInCurrentDoc ? -1 : this.startPos;
    }

    @Override
    public final int endPosition() {
        return this.atFirstInCurrentDoc ? -1 : (this.startPos != Integer.MAX_VALUE ? this.in.endPosition() : Integer.MAX_VALUE);
    }

    @Override
    public int width() {
        return this.in.width();
    }

    @Override
    public void collect(SpanCollector collector) throws IOException {
        this.in.collect(collector);
    }

    @Override
    public final long cost() {
        return this.in.cost();
    }

    @Override
    public String toString() {
        return "Filter(" + this.in.toString() + ")";
    }

    @Override
    public final TwoPhaseIterator asTwoPhaseIterator() {
        final TwoPhaseIterator inner = this.in.asTwoPhaseIterator();
        if (inner != null) {
            return new TwoPhaseIterator(inner.approximation()){

                @Override
                public boolean matches() throws IOException {
                    return inner.matches() && FilterSpans.this.twoPhaseCurrentDocMatches();
                }
            };
        }
        return new TwoPhaseIterator(this.in){

            @Override
            public boolean matches() throws IOException {
                return FilterSpans.this.twoPhaseCurrentDocMatches();
            }
        };
    }

    private final boolean twoPhaseCurrentDocMatches() throws IOException {
        this.atFirstInCurrentDoc = false;
        this.startPos = this.in.nextStartPosition();
        assert (this.startPos != Integer.MAX_VALUE);
        block5: while (true) {
            switch (this.accept(this.in)) {
                case YES: {
                    this.atFirstInCurrentDoc = true;
                    return true;
                }
                case NO: {
                    this.startPos = this.in.nextStartPosition();
                    if (this.startPos != Integer.MAX_VALUE) continue block5;
                }
                case NO_MORE_IN_CURRENT_DOC: {
                    this.startPos = -1;
                    return false;
                }
            }
        }
    }

    public static enum AcceptStatus {
        YES,
        NO,
        NO_MORE_IN_CURRENT_DOC;

    }
}

