/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.protocol.ArtifactResolveType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLRequestAbstractParser;

public class SAMLArtifactResolveParser
extends SAMLRequestAbstractParser
implements ParserNamespaceSupport {
    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ARTIFACT_RESOLVE.get());
        ArtifactResolveType artifactResolve = this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            super.parseCommonElements(startElement, xmlEventReader, (RequestAbstractType)artifactResolve);
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.ARTIFACT.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                artifactResolve.setArtifact(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ISSUER.get().equals(elementName) || JBossSAMLConstants.SIGNATURE.get().equals(elementName) || JBossSAMLConstants.EXTENSIONS.get().equals(elementName)) continue;
            throw new RuntimeException("PL00064: Parser: Unknown Start Element: " + elementName + "::location=" + startElement.getLocation());
        }
        return artifactResolve;
    }

    @Override
    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI());
    }

    private ArtifactResolveType parseBaseAttributes(StartElement startElement) throws ParsingException {
        super.parseRequiredAttributes(startElement);
        ArtifactResolveType authnRequest = new ArtifactResolveType(this.id, this.issueInstant);
        super.parseBaseAttributes(startElement, (RequestAbstractType)authnRequest);
        return authnRequest;
    }
}

