/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.cache.DirectBufferCache;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class BufferCacheService
implements Service<DirectBufferCache> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"undertow", "bufferCache"});
    private final int bufferSize;
    private final int buffersPerRegion;
    private final int maxRegions;
    private volatile DirectBufferCache value;

    public BufferCacheService(int bufferSize, int buffersPerRegion, int maxRegions) {
        this.bufferSize = bufferSize;
        this.buffersPerRegion = buffersPerRegion;
        this.maxRegions = maxRegions;
    }

    public void start(StartContext startContext) throws StartException {
        this.value = new DirectBufferCache(this.bufferSize, this.buffersPerRegion, this.maxRegions * this.buffersPerRegion * this.bufferSize);
    }

    public void stop(StopContext stopContext) {
        this.value = null;
    }

    public DirectBufferCache getValue() throws IllegalStateException, IllegalArgumentException {
        return this.value;
    }
}

