/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.function.BiFunction;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronAccount;
import org.wildfly.elytron.web.undertow.server.SecurityContextImpl;
import org.wildfly.security.auth.server.FlexibleIdentityAssociation;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronRunAsHandler
implements HttpHandler {
    private final HttpHandler next;
    private final BiFunction<SecurityIdentity, HttpServerExchange, SecurityIdentity> identityTransformer;

    public ElytronRunAsHandler(HttpHandler next) {
        this(next, (s, e) -> s);
    }

    public ElytronRunAsHandler(HttpHandler next, BiFunction<SecurityIdentity, HttpServerExchange, SecurityIdentity> identityTransformer) {
        this.next = (HttpHandler)Assert.checkNotNullParam((String)"next", (Object)next);
        this.identityTransformer = (BiFunction)Assert.checkNotNullParam((String)"identityTransformer", identityTransformer);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContextImpl securityContext = (SecurityContextImpl)exchange.getSecurityContext();
        Account account = securityContext != null ? securityContext.getAuthenticatedAccount() : null;
        SecurityIdentity securityIdentity = account instanceof ElytronAccount ? ((ElytronAccount)account).getSecurityIdentity() : null;
        securityIdentity = this.identityTransformer.apply(securityIdentity, exchange);
        FlexibleIdentityAssociation flexibleIdentityAssociation = securityContext.getFlexibleIdentityAssociation();
        if (flexibleIdentityAssociation != null) {
            if (securityIdentity != null) {
                flexibleIdentityAssociation.setIdentity(securityIdentity);
            }
            flexibleIdentityAssociation.runAs(() -> {
                this.next.handleRequest(exchange);
                return null;
            });
        } else if (securityIdentity != null) {
            securityIdentity.runAs(() -> {
                this.next.handleRequest(exchange);
                return null;
            });
        } else {
            this.next.handleRequest(exchange);
        }
    }
}

