/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.lang.reflect.AnnotatedElement;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.spatial.SpatialFieldBridgeByHash;
import org.hibernate.search.spatial.SpatialFieldBridgeByRange;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class SpatialBridgeProvider
extends ExtendedBridgeProvider {
    private static final Log LOG = LoggerFactory.make();

    SpatialBridgeProvider() {
    }

    @Override
    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext context) {
        FieldBridge bridge = null;
        AnnotatedElement annotatedElement = context.getAnnotatedElement();
        if (annotatedElement.isAnnotationPresent(Spatial.class)) {
            Spatial spatialAnn = annotatedElement.getAnnotation(Spatial.class);
            try {
                bridge = SpatialBridgeProvider.buildSpatialBridge(spatialAnn, null, null);
            }
            catch (Exception e) {
                throw LOG.unableToInstantiateSpatial(context.getMemberName(), e);
            }
            if (bridge == null) {
                throw LOG.unableToInstantiateSpatial(context.getMemberName(), null);
            }
        }
        return bridge;
    }

    public static FieldBridge buildSpatialBridge(Spatial spatial, String latitudeField, String longitudeField) {
        SpatialFieldBridge bridge = null;
        if (spatial != null) {
            bridge = spatial.spatialMode() == SpatialMode.HASH ? (latitudeField != null && longitudeField != null ? new SpatialFieldBridgeByHash(spatial.topSpatialHashLevel(), spatial.bottomSpatialHashLevel(), latitudeField, longitudeField) : new SpatialFieldBridgeByHash(spatial.topSpatialHashLevel(), spatial.bottomSpatialHashLevel())) : (latitudeField != null && longitudeField != null ? new SpatialFieldBridgeByRange(latitudeField, longitudeField) : new SpatialFieldBridgeByRange());
        }
        return bridge;
    }
}

