/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.util.JsonSerialization;

public class KeycloakIdentity
implements Identity {
    protected final AccessToken accessToken;
    protected final RealmModel realm;
    protected final KeycloakSession keycloakSession;
    protected final Attributes attributes;

    public KeycloakIdentity(KeycloakSession keycloakSession) {
        this(Tokens.getAccessToken(keycloakSession), keycloakSession);
    }

    public KeycloakIdentity(KeycloakSession keycloakSession, AccessToken accessToken) {
        this(accessToken, keycloakSession, keycloakSession.getContext().getRealm());
    }

    public KeycloakIdentity(AccessToken accessToken, KeycloakSession keycloakSession, RealmModel realm) {
        if (accessToken == null) {
            throw new ErrorResponseException("invalid_bearer_token", "Could not obtain bearer access_token from request.", Response.Status.FORBIDDEN);
        }
        if (keycloakSession == null) {
            throw new ErrorResponseException("no_keycloak_session", "No keycloak session", Response.Status.FORBIDDEN);
        }
        if (realm == null) {
            throw new ErrorResponseException("no_keycloak_session", "No realm set", Response.Status.FORBIDDEN);
        }
        this.accessToken = accessToken;
        this.keycloakSession = keycloakSession;
        this.realm = realm;
        HashMap attributes = new HashMap();
        try {
            Map resourceAccess;
            ObjectNode objectNode = JsonSerialization.createObjectNode((Object)this.accessToken);
            Iterator iterator = objectNode.fieldNames();
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                JsonNode fieldValue = objectNode.get(fieldName);
                ArrayList<String> values = new ArrayList<String>();
                if (fieldValue.isArray()) {
                    Iterator valueIterator = fieldValue.iterator();
                    while (valueIterator.hasNext()) {
                        values.add(((JsonNode)valueIterator.next()).asText());
                    }
                } else {
                    String value = fieldValue.asText();
                    if (StringUtil.isNullOrEmpty((String)value)) continue;
                    values.add(value);
                }
                if (values.isEmpty()) continue;
                attributes.put(fieldName, values);
            }
            AccessToken.Access realmAccess = accessToken.getRealmAccess();
            if (realmAccess != null) {
                attributes.put("kc.realm.roles", realmAccess.getRoles());
            }
            if ((resourceAccess = accessToken.getResourceAccess()) != null) {
                resourceAccess.forEach((clientId, access) -> {
                    Collection cfr_ignored_0 = attributes.put("kc.client." + clientId + ".roles", access.getRoles());
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading attributes from security token.", e);
        }
        this.attributes = Attributes.from(attributes);
    }

    public KeycloakIdentity(AccessToken accessToken, KeycloakSession keycloakSession) {
        if (accessToken == null) {
            throw new ErrorResponseException("invalid_bearer_token", "Could not obtain bearer access_token from request.", Response.Status.FORBIDDEN);
        }
        if (keycloakSession == null) {
            throw new ErrorResponseException("no_keycloak_session", "No keycloak session", Response.Status.FORBIDDEN);
        }
        this.accessToken = accessToken;
        this.keycloakSession = keycloakSession;
        this.realm = keycloakSession.getContext().getRealm();
        HashMap attributes = new HashMap();
        try {
            Map resourceAccess;
            ObjectNode objectNode = JsonSerialization.createObjectNode((Object)this.accessToken);
            Iterator iterator = objectNode.fieldNames();
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                JsonNode fieldValue = objectNode.get(fieldName);
                ArrayList<String> values = new ArrayList<String>();
                if (fieldValue.isArray()) {
                    Iterator valueIterator = fieldValue.iterator();
                    while (valueIterator.hasNext()) {
                        values.add(((JsonNode)valueIterator.next()).asText());
                    }
                } else {
                    String value = fieldValue.asText();
                    if (StringUtil.isNullOrEmpty((String)value)) continue;
                    values.add(value);
                }
                if (values.isEmpty()) continue;
                attributes.put(fieldName, values);
            }
            AccessToken.Access realmAccess = accessToken.getRealmAccess();
            if (realmAccess != null) {
                attributes.put("kc.realm.roles", realmAccess.getRoles());
            }
            if ((resourceAccess = accessToken.getResourceAccess()) != null) {
                resourceAccess.forEach((clientId, access) -> {
                    Collection cfr_ignored_0 = attributes.put("kc.client." + clientId + ".roles", access.getRoles());
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading attributes from security token.", e);
        }
        this.attributes = Attributes.from(attributes);
    }

    public String getId() {
        if (this.isResourceServer()) {
            ClientModel client = this.getTargetClient();
            return client == null ? null : client.getId();
        }
        return this.accessToken.getSubject();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    private boolean isResourceServer() {
        UserModel clientUser = null;
        ClientModel clientModel = this.getTargetClient();
        if (clientModel != null) {
            clientUser = this.keycloakSession.users().getServiceAccount(clientModel);
        }
        if (clientUser == null) {
            return false;
        }
        return this.accessToken.getSubject().equals(clientUser.getId());
    }

    private ClientModel getTargetClient() {
        if (this.accessToken.getIssuedFor() != null) {
            return this.realm.getClientByClientId(this.accessToken.getIssuedFor());
        }
        if (this.accessToken.getAudience() != null && this.accessToken.getAudience().length > 0) {
            String audience = this.accessToken.getAudience()[0];
            return this.realm.getClientByClientId(audience);
        }
        return null;
    }
}

