/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.Collection;
import java.util.List;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class UnorderedDistributionInterceptor
extends NonTxDistributionInterceptor {
    private static Log log = LogFactory.getLog(UnorderedDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private DistributionManager distributionManager;
    private RpcOptions syncRpcOptions;
    private RpcOptions asyncRpcOptions;

    @Inject
    public void inject(DistributionManager distributionManager) {
        this.distributionManager = distributionManager;
    }

    @Start
    public void start() {
        this.syncRpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.NONE).build();
        this.asyncRpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.ASYNCHRONOUS, DeliverOrder.NONE).build();
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }
        int commandTopologyId = command.getTopologyId();
        int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
        if (commandTopologyId != -1 && currentTopologyId != commandTopologyId) {
            throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
        }
        ConsistentHash writeCH = this.distributionManager.getWriteConsistentHash();
        List owners = null;
        if (writeCH.isReplicated()) {
            this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        } else {
            owners = writeCH.locateOwners(command.getKey());
            if (owners.contains(this.rpcManager.getAddress())) {
                this.invokeNextInterceptor(ctx, (VisitableCommand)command);
            } else {
                log.tracef("Not invoking %s on %s since it is not an owner", (Object)command, (Object)this.rpcManager.getAddress());
            }
        }
        if (ctx.isOriginLocal() && command.isSuccessful()) {
            return this.rpcManager.invokeRemotelyAsync((Collection)owners, (ReplicableCommand)command, this.isSynchronous((FlagAffectedCommand)command) ? this.syncRpcOptions : this.asyncRpcOptions);
        }
        return null;
    }
}

