/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

abstract class AbstractService
implements Service<Object> {
    private final Object mBeanInstance;
    private final List<SetupAction> setupActions;
    private final ClassLoader mbeanContextClassLoader;
    protected final InjectedValue<ExecutorService> executor = new InjectedValue();

    protected AbstractService(Object mBeanInstance, List<SetupAction> setupActions, ClassLoader mbeanContextClassLoader) {
        this.mBeanInstance = mBeanInstance;
        this.setupActions = setupActions;
        this.mbeanContextClassLoader = mbeanContextClassLoader;
    }

    public final Object getValue() {
        return this.mBeanInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeLifecycleMethod(Method method, LifecycleContext context) throws InvocationTargetException, IllegalAccessException {
        if (method != null) {
            try {
                for (SetupAction action : this.setupActions) {
                    action.setup(Collections.emptyMap());
                }
                ClassLoader old = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.mbeanContextClassLoader);
                try {
                    method.invoke(this.mBeanInstance, new Object[0]);
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                }
            }
            finally {
                ListIterator<SetupAction> it = this.setupActions.listIterator(this.setupActions.size());
                while (it.hasPrevious()) {
                    SetupAction action;
                    action = it.previous();
                    action.teardown(Collections.emptyMap());
                }
            }
        }
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executor;
    }
}

