/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.aesh.EndpointTypeConverter;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.registration.cli.common.AttributeOperation;
import org.keycloak.client.registration.cli.common.CmdStdinContext;
import org.keycloak.client.registration.cli.common.EndpointType;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.util.AuthUtil;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.client.registration.cli.util.HttpUtil;
import org.keycloak.client.registration.cli.util.IoUtil;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.client.registration.cli.util.ParseUtil;
import org.keycloak.client.registration.cli.util.ReflectionUtil;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.util.JsonSerialization;

@CommandDefinition(name="update", description="CLIENT_ID [ARGUMENTS]")
public class UpdateCmd
extends AbstractAuthOptionsCmd {
    @Option(shortName=101, name="endpoint", description="Endpoint type to use - one of: 'default', 'oidc'", hasValue=true, converter=EndpointTypeConverter.class)
    private EndpointType regType = null;
    @Option(shortName=102, name="file", description="Use the file or standard input if '-' is specified", hasValue=true)
    private String file = null;
    @Option(shortName=109, name="merge", description="Merge new values with existing configuration on the server", hasValue=false)
    private boolean mergeMode = true;
    @Option(shortName=111, name="output", description="After update output the new client configuration", hasValue=false)
    private boolean outputClient = false;
    @Option(shortName=99, name="compressed", description="Don't pretty print the output", hasValue=false)
    private boolean compressed = false;
    @Arguments
    private List<String> args;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        LinkedList<AttributeOperation> attrs = new LinkedList<AttributeOperation>();
        try {
            InputStream response;
            if (this.printHelp()) {
                CommandResult commandResult = this.help ? CommandResult.SUCCESS : CommandResult.FAILURE;
                return commandResult;
            }
            this.processGlobalOptions();
            String clientId = null;
            if (this.args != null) {
                Iterator<String> it = this.args.iterator();
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("CLIENT_ID not specified");
                }
                clientId = it.next();
                if (clientId.startsWith("-")) {
                    IoUtil.warnfErr("You're using what looks like an OPTION as CLIENT: %s", clientId);
                }
                block21: while (it.hasNext()) {
                    String option;
                    switch (option = it.next()) {
                        case "-s": 
                        case "--set": {
                            if (!it.hasNext()) {
                                throw new IllegalArgumentException("Option " + option + " requires a value");
                            }
                            String[] keyVal = ParseUtil.parseKeyVal(it.next());
                            attrs.add(new AttributeOperation(AttributeOperation.Type.SET, keyVal[0], keyVal[1]));
                            continue block21;
                        }
                        case "-d": 
                        case "--delete": {
                            attrs.add(new AttributeOperation(AttributeOperation.Type.DELETE, it.next()));
                            continue block21;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported option: " + option);
                }
            }
            if (this.file == null && attrs.size() == 0) {
                throw new IllegalArgumentException("No file nor attribute values specified");
            }
            if (this.file == null && attrs.size() > 0) {
                this.mergeMode = true;
            }
            CmdStdinContext ctx = new CmdStdinContext();
            if (this.file != null) {
                ctx = ParseUtil.parseFileOrStdin(this.file, this.regType);
                this.regType = ctx.getEndpointType();
            }
            if (this.regType == null) {
                this.regType = EndpointType.DEFAULT;
                ctx.setEndpointType(this.regType);
            } else if (this.regType != EndpointType.DEFAULT && this.regType != EndpointType.OIDC) {
                throw new RuntimeException("Update not supported for endpoint type: " + this.regType.getEndpoint());
            }
            ConfigData config = ConfigUtil.loadConfig();
            config = this.copyWithServerInfo(config);
            String server = config.getServerUrl();
            String realm = config.getRealm();
            if (this.token == null) {
                boolean processed = false;
                for (AttributeOperation op : attrs) {
                    if (!"registrationAccessToken".equals(op.getKey().toString())) continue;
                    processed = true;
                    if (op.getType() != AttributeOperation.Type.SET) break;
                    this.token = op.getValue();
                    break;
                }
                if (!processed) {
                    this.token = ctx.getRegistrationAccessToken();
                }
            }
            if (this.token == null) {
                this.token = ConfigUtil.getRegistrationToken(config.sessionRealmConfigData(), clientId);
            }
            this.setupTruststore(config, commandInvocation);
            String auth = this.token;
            if (auth == null) {
                config = this.ensureAuthInfo(config, commandInvocation);
                if (ConfigUtil.credentialsAvailable(config = this.copyWithServerInfo(config))) {
                    auth = AuthUtil.ensureToken(config);
                }
            }
            String string = auth = auth != null ? "Bearer " + auth : null;
            if (this.mergeMode) {
                response = HttpUtil.doGet(server + "/realms/" + realm + "/clients-registrations/" + this.regType.getEndpoint() + "/" + HttpUtil.urlencode(clientId), "application/json", auth);
                String json = IoUtil.readFully(response);
                CmdStdinContext ctxremote = new CmdStdinContext();
                ctxremote.setContent(json);
                ctxremote.setEndpointType(this.regType);
                try {
                    if (this.regType == EndpointType.DEFAULT) {
                        ctxremote.setClient(JsonSerialization.readValue(json, ClientRepresentation.class));
                        this.token = ctxremote.getClient().getRegistrationAccessToken();
                    } else if (this.regType == EndpointType.OIDC) {
                        ctxremote.setOidcClient(JsonSerialization.readValue(json, OIDCClientRepresentation.class));
                        this.token = ctxremote.getOidcClient().getRegistrationAccessToken();
                    }
                }
                catch (JsonParseException e) {
                    throw new RuntimeException("Not a valid JSON document. " + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Not a valid JSON document", e);
                }
                if (this.token != null) {
                    auth = "Bearer " + this.token;
                    String newToken = this.token;
                    String clientToUpdate = clientId;
                    ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), clientToUpdate, newToken));
                }
                if (ctx.getClient() != null) {
                    ReflectionUtil.merge(ctx.getClient(), ctxremote.getClient());
                } else if (ctx.getOidcClient() != null) {
                    ReflectionUtil.merge(ctx.getOidcClient(), ctxremote.getOidcClient());
                }
                ctx = ctxremote;
            }
            if (attrs.size() > 0) {
                ctx = ParseUtil.mergeAttributes(ctx, attrs);
            }
            response = HttpUtil.doPut(server + "/realms/" + realm + "/clients-registrations/" + this.regType.getEndpoint() + "/" + HttpUtil.urlencode(clientId), "application/json", "application/json", ctx.getContent(), auth);
            try {
                Object clirep;
                if (this.regType == EndpointType.DEFAULT) {
                    clirep = JsonSerialization.readValue(response, ClientRepresentation.class);
                    this.outputResult(clirep);
                    this.token = ((ClientRepresentation)clirep).getRegistrationAccessToken();
                } else if (this.regType == EndpointType.OIDC) {
                    clirep = JsonSerialization.readValue(response, OIDCClientRepresentation.class);
                    this.outputResult(clirep);
                    this.token = ((OIDCClientRepresentation)clirep).getRegistrationAccessToken();
                }
                String newToken = this.token;
                String clientToUpdate = clientId;
                ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), clientToUpdate, newToken));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to process HTTP response", e);
            }
            CommandResult commandResult = CommandResult.SUCCESS;
            return commandResult;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + this.suggestHelp(), e);
        }
        finally {
            commandInvocation.stop();
        }
    }

    private void outputResult(Object result) throws IOException {
        if (this.outputClient) {
            if (this.compressed) {
                IoUtil.printOut(JsonSerialization.writeValueAsString(result));
            } else {
                IoUtil.printOut(JsonSerialization.writeValueAsPrettyString(result));
            }
        }
    }

    @Override
    protected boolean nothingToDo() {
        return this.noOptions() && this.regType == null && this.file == null && (this.args == null || this.args.size() == 0);
    }

    protected String suggestHelp() {
        return OsUtil.EOL + "Try '" + OsUtil.CMD + " help update' for more information";
    }

    @Override
    protected String help() {
        return UpdateCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " update CLIENT [ARGUMENTS]");
        out.println();
        out.println("Command to update an existing client configuration. If registration access token is specified it is used.");
        out.println("Otherwise, if 'registrationAccessToken' attribute is set, that is used. Otherwise, if registration access");
        out.println("token is available in configuration file, we use that. Finally, if it's not available anywhere, the current ");
        out.println("active session is used.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println("    --config              Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println("    --truststore PATH     Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified and --truststore is used)");
        out.println("    --token TOKEN         Registration access token to use");
        out.println("    CREDENTIALS OPTIONS   Same set of options as accepted by '" + OsUtil.CMD + " config credentials' in order to establish");
        out.println("                          an authenticated sessions. This allows on-the-fly transient authentication that does");
        out.println("                          not touch a config file.");
        out.println();
        out.println("  Command specific options:");
        out.println("    CLIENT                ClientId of the client to update");
        out.println("    -s, --set KEY=VALUE   Set specific attribute to a specified value");
        out.println("              KEY+=VALUE  Add item to an array");
        out.println("    -d, --delete NAME     Delete the specific attribute, or array item");
        out.println("    -e, --endpoint TYPE   Endpoint type to use - one of: 'default', 'oidc'");
        out.println("    -f, --file FILENAME   Use the file or standard input if '-' is specified");
        out.println("    -m, --merge           Merge new values with existing configuration on the server");
        out.println("                          Merge is automatically enabled unless --file is specified");
        out.println("    -o, --output          After update output the new client configuration");
        out.println("    -c, --compressed      Don't pretty print the output");
        out.println();
        out.println();
        out.println("Nested attributes are supported by using '.' to separate components of a KEY. Optionaly, the KEY components ");
        out.println("can be quoted with double quotes - e.g. my_client.attributes.\"external.user.id\". If VALUE starts with [ and ");
        out.println("ends with ] the attribute will be set as a JSON array. If VALUE starts with { and ends with } the attribute ");
        out.println("will be set as a JSON object. If KEY ends with an array index - e.g. clients[3]=VALUE - then the specified item");
        out.println("of the array is updated. If KEY+=VALUE syntax is used, then KEY is assumed to be an array, and another item is");
        out.println("added to it.");
        out.println();
        out.println("Attributes can also be deleted. If KEY ends with an array index, then the targeted item of an array is removed");
        out.println("and the following items are shifted.");
        out.println();
        out.println("Merged mode fetches current configuration from the server, applies attribute changes to it, and sends it");
        out.println("back to the server, overwriting existing configuration there. If available, Registration Access Token is used ");
        out.println("for authorization when doing changes. Otherwise current session's authorization is used in which case user needs");
        out.println("manage-clients permission for update to work.");
        out.println();
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Update a client by fetching current configuration from server, and applying specified changes.");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " update my_client -s enabled=true -s 'redirectUris=[\"http://localhost:8080/myapp/*\"]'");
        out.println();
        out.println("Update a client by overwriting existing configuration on the server with a new one:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " update my_client -f new_my_client.json");
        out.println();
        out.println("Update a client by overwriting existing configuration using local file as a template:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " update my_client -f new_my_client.json -s enabled=true");
        out.println();
        out.println("Update client by fetching current configuration from server and merging with specified changes:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " update my_client -f new_my_client.json -s enabled=true --merge");
        out.println();
        out.println("Update a client using 'oidc' endpoint:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " update my_client -e oidc -s 'redirect_uris=[\"http://localhost:8080/myapp/*\"]'");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

