/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.net.URI;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.sessions.AuthenticationSessionModel;

public class RequiredActionContextResult
implements RequiredActionContext {
    protected AuthenticationSessionModel authenticationSession;
    protected RealmModel realm;
    protected EventBuilder eventBuilder;
    protected KeycloakSession session;
    protected RequiredActionContext.Status status;
    protected Response challenge;
    protected HttpRequest httpRequest;
    protected UserModel user;
    protected RequiredActionFactory factory;

    public RequiredActionContextResult(AuthenticationSessionModel authSession, RealmModel realm, EventBuilder eventBuilder, KeycloakSession session, HttpRequest httpRequest, UserModel user, RequiredActionFactory factory) {
        this.authenticationSession = authSession;
        this.realm = realm;
        this.eventBuilder = eventBuilder;
        this.session = session;
        this.httpRequest = httpRequest;
        this.user = user;
        this.factory = factory;
    }

    public EventBuilder getEvent() {
        return this.eventBuilder;
    }

    public UserModel getUser() {
        return this.user;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public ClientConnection getConnection() {
        return this.session.getContext().getConnection();
    }

    public UriInfo getUriInfo() {
        return this.session.getContext().getUri();
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public RequiredActionContext.Status getStatus() {
        return this.status;
    }

    public void challenge(Response response) {
        this.status = RequiredActionContext.Status.CHALLENGE;
        this.challenge = response;
    }

    public void failure() {
        this.status = RequiredActionContext.Status.FAILURE;
    }

    public void success() {
        this.status = RequiredActionContext.Status.SUCCESS;
    }

    public void ignore() {
        this.status = RequiredActionContext.Status.IGNORE;
    }

    public URI getActionUrl(String code) {
        ClientModel client = this.authenticationSession.getClient();
        return LoginActionsService.requiredActionProcessor(this.getUriInfo()).queryParam("code", new Object[]{code}).queryParam("execution", new Object[]{this.getExecution()}).queryParam("client_id", new Object[]{client.getClientId()}).build(new Object[]{this.getRealm().getName()});
    }

    private String getExecution() {
        return this.factory.getId();
    }

    public String generateCode() {
        ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.getRealm(), this.getAuthenticationSession());
        this.authenticationSession.getParentSession().setTimestamp(Time.currentTime());
        return accessCode.getOrGenerateCode();
    }

    public URI getActionUrl() {
        String accessCode = this.generateCode();
        return this.getActionUrl(accessCode);
    }

    public LoginFormsProvider form() {
        String accessCode = this.generateCode();
        URI action = this.getActionUrl(accessCode);
        LoginFormsProvider provider = ((LoginFormsProvider)this.getSession().getProvider(LoginFormsProvider.class)).setAuthenticationSession(this.getAuthenticationSession()).setUser(this.getUser()).setActionUri(action).setExecution(this.getExecution()).setClientSessionCode(accessCode);
        return provider;
    }

    public Response getChallenge() {
        return this.challenge;
    }
}

