/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded.logging;

import java.lang.reflect.Method;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.embedded.EmbeddedProcessStartException;

@MessageLogger(projectCode="WFLYEMB", length=4)
public interface EmbeddedLogger
extends BasicLogger {
    public static final EmbeddedLogger ROOT_LOGGER = (EmbeddedLogger)Logger.getMessageLogger(EmbeddedLogger.class, (String)"org.jboss.as.embedded");

    @Message(id=11, value="Invalid JBoss home directory: %s")
    public IllegalStateException invalidJBossHome(String var1);

    @Message(id=14, value="Cannot load module %s from: %s")
    public RuntimeException moduleLoaderError(@Cause Throwable var1, String var2, ModuleLoader var3);

    @Message(id=17, value="Cannot load embedded server factory: %s")
    public IllegalStateException cannotLoadEmbeddedServerFactory(@Cause ClassNotFoundException var1, String var2);

    @Message(id=18, value="Cannot get reflective method '%s' for: %s")
    public IllegalStateException cannotGetReflectiveMethod(@Cause NoSuchMethodException var1, String var2, String var3);

    @Message(id=19, value="Cannot create standalone server using factory: %s")
    public IllegalStateException cannotCreateStandaloneServer(@Cause Throwable var1, Method var2);

    @Message(id=20, value="Cannot setup embedded process")
    public IllegalStateException cannotSetupEmbeddedServer(@Cause Throwable var1);

    @Message(id=21, value="Cannot start embedded process")
    public EmbeddedProcessStartException cannotStartEmbeddedServer(@Cause Throwable var1);

    @Message(id=22, value="Cannot invoke '%s' on embedded process")
    public IllegalStateException cannotInvokeStandaloneServer(@Cause Throwable var1, String var2);

    @Message(id=23, value="The embedded server is stopping and invocations on the ModelControllerClient are not available")
    public IllegalStateException processIsStopping();

    @Message(id=24, value="The embedded server is reloading and invocations on the ModelControllerClient are not yet available")
    public IllegalStateException processIsReloading();

    @Message(id=26, value="Cannot create host controller using factory: %s")
    public IllegalStateException cannotCreateHostController(@Cause Throwable var1, Method var2);

    @Message(id=27, value="The embedded server is stopped and invocations on the ModelControllerClient are not available")
    public IllegalStateException processIsStopped();
}

