/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.CollectionUtil;

public class ConjunctionDISI
extends DocIdSetIterator {
    final DocIdSetIterator lead;
    final DocIdSetIterator[] others;

    public static ConjunctionDISI intersect(List<? extends DocIdSetIterator> iterators) {
        if (iterators.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (DocIdSetIterator docIdSetIterator : iterators) {
            ConjunctionDISI.addIterator(docIdSetIterator, allIterators, twoPhaseIterators);
        }
        if (twoPhaseIterators.isEmpty()) {
            return new ConjunctionDISI(allIterators);
        }
        return new TwoPhase(allIterators, twoPhaseIterators);
    }

    private static void addIterator(DocIdSetIterator disi, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        if (disi.getClass() == ConjunctionDISI.class || disi.getClass() == TwoPhase.class) {
            ConjunctionDISI conjunction = (ConjunctionDISI)disi;
            allIterators.add(conjunction.lead);
            Collections.addAll(allIterators, conjunction.others);
            if (conjunction.getClass() == TwoPhase.class) {
                TwoPhase twoPhase = (TwoPhase)conjunction;
                Collections.addAll(twoPhaseIterators, twoPhase.twoPhaseView.twoPhaseIterators);
            }
        } else {
            TwoPhaseIterator twoPhaseIter = TwoPhaseIterator.asTwoPhaseIterator(disi);
            if (twoPhaseIter != null) {
                allIterators.add(twoPhaseIter.approximation());
                twoPhaseIterators.add(twoPhaseIter);
            } else {
                allIterators.add(disi);
            }
        }
    }

    ConjunctionDISI(List<? extends DocIdSetIterator> iterators) {
        assert (iterators.size() >= 2);
        CollectionUtil.timSort(iterators, new Comparator<DocIdSetIterator>(){

            @Override
            public int compare(DocIdSetIterator o1, DocIdSetIterator o2) {
                return Long.compare(o1.cost(), o2.cost());
            }
        });
        this.lead = iterators.get(0);
        this.others = iterators.subList(1, iterators.size()).toArray(new DocIdSetIterator[0]);
    }

    protected boolean matches() throws IOException {
        return true;
    }

    TwoPhaseIterator asTwoPhaseIterator() {
        return null;
    }

    private int doNext(int doc) throws IOException {
        block0: while (doc != Integer.MAX_VALUE) {
            for (DocIdSetIterator other : this.others) {
                int next;
                if (other.docID() >= doc || (next = other.advance(doc)) <= doc) continue;
                doc = this.lead.advance(next);
                continue block0;
            }
            if (this.matches()) {
                return doc;
            }
            doc = this.lead.nextDoc();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int advance(int target) throws IOException {
        return this.doNext(this.lead.advance(target));
    }

    @Override
    public int docID() {
        return this.lead.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.doNext(this.lead.nextDoc());
    }

    @Override
    public long cost() {
        return this.lead.cost();
    }

    private static class TwoPhase
    extends ConjunctionDISI {
        final TwoPhaseConjunctionDISI twoPhaseView;

        private TwoPhase(List<? extends DocIdSetIterator> iterators, List<TwoPhaseIterator> twoPhaseIterators) {
            super(iterators);
            this.twoPhaseView = new TwoPhaseConjunctionDISI(iterators, twoPhaseIterators);
        }

        @Override
        public TwoPhaseConjunctionDISI asTwoPhaseIterator() {
            return this.twoPhaseView;
        }

        @Override
        protected boolean matches() throws IOException {
            return this.twoPhaseView.matches();
        }
    }

    private static class TwoPhaseConjunctionDISI
    extends TwoPhaseIterator {
        private final TwoPhaseIterator[] twoPhaseIterators;

        private TwoPhaseConjunctionDISI(List<? extends DocIdSetIterator> iterators, List<TwoPhaseIterator> twoPhaseIterators) {
            super(new ConjunctionDISI(iterators));
            assert (twoPhaseIterators.size() > 0);
            this.twoPhaseIterators = twoPhaseIterators.toArray(new TwoPhaseIterator[twoPhaseIterators.size()]);
        }

        @Override
        public boolean matches() throws IOException {
            for (TwoPhaseIterator twoPhaseIterator : this.twoPhaseIterators) {
                if (twoPhaseIterator.matches()) continue;
                return false;
            }
            return true;
        }
    }
}

