/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarFile;
import org.jboss.modules.Resource;

final class JarEntryResource
implements Resource {
    private final JarFile jarFile;
    private final String entryName;
    private final URL resourceURL;

    JarEntryResource(JarFile jarFile, String name, String relativePath, URL resourceURL) {
        this.jarFile = jarFile;
        this.entryName = relativePath == null ? name : name.substring(relativePath.length() + 1);
        this.resourceURL = resourceURL;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public URL getURL() {
        return this.resourceURL;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.jarFile.getInputStream(this.jarFile.getEntry(this.entryName));
    }

    @Override
    public long getSize() {
        long size = this.jarFile.getEntry(this.entryName).getSize();
        return size == -1L ? 0L : size;
    }
}

