/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.metadata.PublishLocationAdapterImpl;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WebMetaDataHelper;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PublishLocationAdapter;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;

abstract class AbstractMetaDataBuilderPOJO {
    AbstractMetaDataBuilderPOJO() {
    }

    JSEArchiveMetaData create(Deployment dep) {
        if (WSLogger.ROOT_LOGGER.isTraceEnabled()) {
            WSLogger.ROOT_LOGGER.tracef("Creating JBoss agnostic meta data for POJO webservice deployment: %s", dep.getSimpleName());
        }
        JBossWebMetaData jbossWebMD = (JBossWebMetaData)WSHelper.getRequiredAttachment((Deployment)dep, JBossWebMetaData.class);
        DeploymentUnit unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class);
        List<POJOEndpoint> pojoEndpoints = this.getPojoEndpoints(unit);
        JSEArchiveMetaData.Builder builder = new JSEArchiveMetaData.Builder();
        String contextRoot = ASHelper.getContextRoot(dep, jbossWebMD);
        builder.setContextRoot(contextRoot);
        WSLogger.ROOT_LOGGER.tracef("Setting context root: %s", contextRoot);
        Map<String, String> servletMappings = this.getServletUrlPatternsMappings(jbossWebMD, pojoEndpoints);
        builder.setServletMappings(servletMappings);
        Map<String, String> servletClassNamesMappings = this.getServletClassMappings(jbossWebMD, pojoEndpoints);
        builder.setServletClassNames(servletClassNamesMappings);
        String securityDomain = jbossWebMD.getSecurityDomain();
        builder.setSecurityDomain(securityDomain);
        JBossWebservicesMetaData jbossWebservicesMD = (JBossWebservicesMetaData)WSHelper.getOptionalAttachment((Deployment)dep, JBossWebservicesMetaData.class);
        if (jbossWebservicesMD != null) {
            PublishLocationAdapterImpl resolver = new PublishLocationAdapterImpl(jbossWebservicesMD.getWebserviceDescriptions());
            builder.setPublishLocationAdapter((PublishLocationAdapter)resolver);
        }
        List<JSESecurityMetaData> jseSecurityMDs = this.getSecurityMetaData(jbossWebMD.getSecurityConstraints());
        builder.setSecurityMetaData(jseSecurityMDs);
        this.setConfigNameAndFile(builder, jbossWebMD, jbossWebservicesMD);
        return builder.build();
    }

    protected abstract List<POJOEndpoint> getPojoEndpoints(DeploymentUnit var1);

    private void setConfigNameAndFile(JSEArchiveMetaData.Builder builder, JBossWebMetaData jbossWebMD, JBossWebservicesMetaData jbossWebservicesMD) {
        if (jbossWebservicesMD != null && jbossWebservicesMD.getConfigName() != null) {
            String configName = jbossWebservicesMD.getConfigName();
            builder.setConfigName(configName);
            WSLogger.ROOT_LOGGER.tracef("Setting config name: %s", configName);
            String configFile = jbossWebservicesMD.getConfigFile();
            builder.setConfigFile(configFile);
            WSLogger.ROOT_LOGGER.tracef("Setting config file: %s", configFile);
            return;
        }
        List contextParams = jbossWebMD.getContextParams();
        if (contextParams != null) {
            for (ParamValueMetaData contextParam : contextParams) {
                if ("jbossws-config-name".equals(contextParam.getParamName())) {
                    String configName = contextParam.getParamValue();
                    builder.setConfigName(configName);
                    WSLogger.ROOT_LOGGER.tracef("Setting config name: %s", configName);
                }
                if (!"jbossws-config-file".equals(contextParam.getParamName())) continue;
                String configFile = contextParam.getParamValue();
                builder.setConfigFile(configFile);
                WSLogger.ROOT_LOGGER.tracef("Setting config file: %s", configFile);
            }
        }
    }

    private List<JSESecurityMetaData> getSecurityMetaData(List<SecurityConstraintMetaData> securityConstraintsMD) {
        LinkedList<JSESecurityMetaData> jseSecurityMDs = new LinkedList<JSESecurityMetaData>();
        if (securityConstraintsMD != null) {
            for (SecurityConstraintMetaData securityConstraintMD : securityConstraintsMD) {
                JSESecurityMetaData.Builder jseSecurityMDBuilder = new JSESecurityMetaData.Builder();
                jseSecurityMDBuilder.setTransportGuarantee(securityConstraintMD.getTransportGuarantee().name());
                for (WebResourceCollectionMetaData webResourceMD : securityConstraintMD.getResourceCollections()) {
                    jseSecurityMDBuilder.addWebResource(webResourceMD.getName(), (Collection)webResourceMD.getUrlPatterns());
                }
                jseSecurityMDs.add(jseSecurityMDBuilder.build());
            }
        }
        return jseSecurityMDs;
    }

    private Map<String, String> getServletUrlPatternsMappings(JBossWebMetaData jbossWebMD, List<POJOEndpoint> pojoEndpoints) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        List<ServletMappingMetaData> servletMappings = WebMetaDataHelper.getServletMappings(jbossWebMD);
        for (POJOEndpoint pojoEndpoint : pojoEndpoints) {
            mappings.put(pojoEndpoint.getName(), pojoEndpoint.getUrlPattern());
            if (pojoEndpoint.isDeclared()) continue;
            String endpointName = pojoEndpoint.getName();
            List<String> urlPatterns = WebMetaDataHelper.getUrlPatterns(pojoEndpoint.getUrlPattern());
            WebMetaDataHelper.newServletMapping(endpointName, urlPatterns, servletMappings);
        }
        return mappings;
    }

    private Map<String, String> getServletClassMappings(JBossWebMetaData jbossWebMD, List<POJOEndpoint> pojoEndpoints) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        JBossServletsMetaData servlets = WebMetaDataHelper.getServlets(jbossWebMD);
        for (POJOEndpoint pojoEndpoint : pojoEndpoints) {
            String pojoName = pojoEndpoint.getName();
            String pojoClassName = pojoEndpoint.getClassName();
            mappings.put(pojoName, pojoClassName);
            if (pojoEndpoint.isDeclared()) continue;
            String endpointName = pojoEndpoint.getName();
            String endpointClassName = pojoEndpoint.getClassName();
            WebMetaDataHelper.newServlet(endpointName, endpointClassName, servlets);
        }
        return mappings;
    }
}

