/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.ServiceLoader;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.ModuleBuilder;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.GlobalConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.KeyAffinityServiceFactoryBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.CacheContainer;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.spi.CacheAliasBuilderProvider;

public class CacheContainerServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathElement ejbPath;
        Resource ejbResource;
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        if (context.getProcessType().isServer() && !context.isBooting() && name.equals("ejb") && (ejbResource = CacheContainerServiceHandler.safeGetResource(context, ejbPath = PathElement.pathElement((String)"subsystem", (String)"ejb3"))) != null && ejbResource.hasChild(PathElement.pathElement((String)"service", (String)"remote"))) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            return;
        }
        ServiceTarget target = context.getServiceTarget();
        new ModuleBuilder(CacheContainerComponent.MODULE.getServiceName(address), (Attribute)CacheContainerResourceDefinition.Attribute.MODULE).configure(context, model).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        new GlobalConfigurationBuilder(address).configure(context, model).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        CacheContainerBuilder containerBuilder = new CacheContainerBuilder(address).configure(context, model);
        containerBuilder.build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        new KeyAffinityServiceFactoryBuilder(address).build(target).install();
        BinderServiceBuilder bindingBuilder = new BinderServiceBuilder(InfinispanBindingFactory.createCacheContainerBinding(name), containerBuilder.getServiceName(), CacheContainer.class);
        ModelNodes.optionalString((ModelNode)CacheContainerResourceDefinition.Attribute.JNDI_NAME.resolveModelAttribute((ExpressionResolver)context, model)).map(jndiName -> ContextNames.bindInfoFor((String)JndiNameFactory.parse((String)jndiName).getAbsoluteName())).ifPresent(aliasBinding -> bindingBuilder.alias(aliasBinding));
        bindingBuilder.build(target).install();
        String defaultCache = containerBuilder.getDefaultCache();
        if (defaultCache != null) {
            CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.entrySet().forEach(entry -> new AliasServiceBuilder(((Capability)entry.getValue()).getServiceName(address), ((InfinispanCacheRequirement)entry.getKey()).getServiceName(context, name, defaultCache), ((InfinispanCacheRequirement)entry.getKey()).getType()).build(target).install());
            if (!defaultCache.equals("default")) {
                new BinderServiceBuilder(InfinispanBindingFactory.createCacheBinding(name, "default"), CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.get(InfinispanCacheRequirement.CACHE).getServiceName(address), Cache.class).build(target).install();
                new BinderServiceBuilder(InfinispanBindingFactory.createCacheConfigurationBinding(name, "default"), CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.get(InfinispanCacheRequirement.CONFIGURATION).getServiceName(address), Configuration.class).build(target).install();
            }
            for (CacheAliasBuilderProvider provider : ServiceLoader.load(CacheAliasBuilderProvider.class, CacheAliasBuilderProvider.class.getClassLoader())) {
                for (CapabilityServiceBuilder builder : provider.getBuilders(requirement -> CacheContainerResourceDefinition.DEFAULT_CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), name, null, defaultCache)) {
                    builder.configure(context).build(target).install();
                }
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        ModelNodes.optionalString((ModelNode)CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model)).ifPresent(defaultCache -> {
            for (CacheAliasBuilderProvider provider : ServiceLoader.load(CacheAliasBuilderProvider.class, CacheAliasBuilderProvider.class.getClassLoader())) {
                for (ServiceNameProvider builder : provider.getBuilders(requirement -> CacheContainerResourceDefinition.DEFAULT_CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), name, null, defaultCache)) {
                    context.removeService(builder.getServiceName());
                }
            }
            if (!defaultCache.equals("default")) {
                context.removeService(InfinispanBindingFactory.createCacheBinding(name, "default").getBinderServiceName());
                context.removeService(InfinispanBindingFactory.createCacheConfigurationBinding(name, "default").getBinderServiceName());
            }
            CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.values().forEach(capability -> context.removeService(capability.getServiceName(address)));
        });
        context.removeService(InfinispanBindingFactory.createCacheContainerBinding(name).getBinderServiceName());
        context.removeService(CacheContainerComponent.MODULE.getServiceName(address));
        EnumSet.allOf(CacheContainerResourceDefinition.Capability.class).stream().map(component -> component.getServiceName(address)).forEach(serviceName -> context.removeService(serviceName));
    }

    private static Resource safeGetResource(OperationContext context, PathElement path) {
        try {
            return context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{path}), false);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

