/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.UnaryOperator;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.AbstractMechanismAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.SecurityIdentityServerMechanismFactory;

public final class HttpAuthenticationFactory
extends AbstractMechanismAuthenticationFactory<HttpServerAuthenticationMechanism, HttpServerAuthenticationMechanismFactory, HttpAuthenticationException> {
    HttpAuthenticationFactory(SecurityDomain securityDomain, MechanismConfigurationSelector mechanismConfigurationSelector, HttpServerAuthenticationMechanismFactory factory) {
        super(securityDomain, mechanismConfigurationSelector, factory);
    }

    @Override
    HttpServerAuthenticationMechanism doCreate(String name, CallbackHandler callbackHandler, UnaryOperator<HttpServerAuthenticationMechanismFactory> factoryTransformation) throws HttpAuthenticationException {
        HttpServerAuthenticationMechanism server = new SecurityIdentityServerMechanismFactory((HttpServerAuthenticationMechanismFactory)factoryTransformation.apply((HttpServerAuthenticationMechanismFactory)this.getFactory())).createAuthenticationMechanism(name, Collections.emptyMap(), callbackHandler);
        ElytronMessages.log.tracef("Created HttpServerAuthenticationMechanism [%s] for mechanism [%s]", (Object)server, (Object)name);
        return server;
    }

    @Override
    Collection<String> getAllSupportedMechNames() {
        return Arrays.asList(((HttpServerAuthenticationMechanismFactory)this.getFactory()).getMechanismNames(Collections.emptyMap()));
    }

    @Override
    Collection<Class<? extends Evidence>> getSupportedEvidenceTypes(String mechName) {
        switch (mechName) {
            case "BASIC": {
                return Collections.singleton(PasswordGuessEvidence.class);
            }
        }
        return Collections.emptySet();
    }

    @Override
    Collection<String> getSupportedEvidenceAlgorithmNames(Class<? extends AlgorithmEvidence> evidenceType, String mechName) {
        return Collections.emptySet();
    }

    @Override
    Collection<Class<? extends Credential>> getSupportedCredentialTypes(String mechName) {
        switch (mechName) {
            case "BASIC": 
            case "DIGEST": {
                return Collections.singleton(PasswordCredential.class);
            }
        }
        return Collections.emptySet();
    }

    @Override
    Collection<String> getSupportedCredentialAlgorithmNames(Class<? extends AlgorithmCredential> credentialType, String mechName) {
        switch (mechName) {
            case "BASIC": {
                return Collections.singleton("*");
            }
            case "DIGEST": {
                return Arrays.asList("clear", "digest-md5");
            }
        }
        return Collections.emptySet();
    }

    @Override
    boolean usesCredentials(String mechName) {
        switch (mechName) {
            case "BASIC": 
            case "DIGEST": {
                return true;
            }
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractMechanismAuthenticationFactory.Builder<HttpServerAuthenticationMechanism, HttpServerAuthenticationMechanismFactory, HttpAuthenticationException> {
        Builder() {
        }

        @Override
        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            super.setSecurityDomain(securityDomain);
            return this;
        }

        @Override
        public Builder setMechanismConfigurationSelector(MechanismConfigurationSelector mechanismConfigurationSelector) {
            super.setMechanismConfigurationSelector(mechanismConfigurationSelector);
            return this;
        }

        public Builder setFactory(HttpServerAuthenticationMechanismFactory factory) {
            super.setFactory(factory);
            return this;
        }

        public HttpAuthenticationFactory build() {
            return new HttpAuthenticationFactory(this.getSecurityDomain(), this.getMechanismConfigurationSelector(), (HttpServerAuthenticationMechanismFactory)this.getFactory());
        }
    }
}

