/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationProviderFactory;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.UriUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.keys.KeyProvider;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.models.utils.DefaultKeyProviders;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClaimRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.util.JsonSerialization;

public class RepresentationToModel {
    private static Logger logger = Logger.getLogger(RepresentationToModel.class);
    public static final String OIDC = "openid-connect";

    public static OTPPolicy toPolicy(RealmRepresentation rep) {
        OTPPolicy policy = new OTPPolicy();
        if (rep.getOtpPolicyType() != null) {
            policy.setType(rep.getOtpPolicyType());
        }
        if (rep.getOtpPolicyLookAheadWindow() != null) {
            policy.setLookAheadWindow(rep.getOtpPolicyLookAheadWindow().intValue());
        }
        if (rep.getOtpPolicyInitialCounter() != null) {
            policy.setInitialCounter(rep.getOtpPolicyInitialCounter().intValue());
        }
        if (rep.getOtpPolicyAlgorithm() != null) {
            policy.setAlgorithm(rep.getOtpPolicyAlgorithm());
        }
        if (rep.getOtpPolicyDigits() != null) {
            policy.setDigits(rep.getOtpPolicyDigits().intValue());
        }
        if (rep.getOtpPolicyPeriod() != null) {
            policy.setPeriod(rep.getOtpPolicyPeriod().intValue());
        }
        return policy;
    }

    public static void importRealm(KeycloakSession session, RealmRepresentation rep, RealmModel newRealm, boolean skipUserDependent) {
        RepresentationToModel.convertDeprecatedSocialProviders(rep);
        RepresentationToModel.convertDeprecatedApplications(session, rep);
        newRealm.setName(rep.getRealm());
        if (rep.getDisplayName() != null) {
            newRealm.setDisplayName(rep.getDisplayName());
        }
        if (rep.getDisplayNameHtml() != null) {
            newRealm.setDisplayNameHtml(rep.getDisplayNameHtml());
        }
        if (rep.isEnabled() != null) {
            newRealm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isBruteForceProtected() != null) {
            newRealm.setBruteForceProtected(rep.isBruteForceProtected().booleanValue());
        }
        if (rep.isPermanentLockout() != null) {
            newRealm.setPermanentLockout(rep.isPermanentLockout().booleanValue());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            newRealm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds().intValue());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            newRealm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds().intValue());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            newRealm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds().intValue());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            newRealm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds().longValue());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            newRealm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds().intValue());
        }
        if (rep.getFailureFactor() != null) {
            newRealm.setFailureFactor(rep.getFailureFactor().intValue());
        }
        if (rep.isEventsEnabled() != null) {
            newRealm.setEventsEnabled(rep.isEventsEnabled().booleanValue());
        }
        if (rep.getEnabledEventTypes() != null) {
            newRealm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
        if (rep.getEventsExpiration() != null) {
            newRealm.setEventsExpiration(rep.getEventsExpiration().longValue());
        }
        if (rep.getEventsListeners() != null) {
            newRealm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            newRealm.setAdminEventsEnabled(rep.isAdminEventsEnabled().booleanValue());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            newRealm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled().booleanValue());
        }
        if (rep.getNotBefore() != null) {
            newRealm.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getRevokeRefreshToken() != null) {
            newRealm.setRevokeRefreshToken(rep.getRevokeRefreshToken().booleanValue());
        } else {
            newRealm.setRevokeRefreshToken(false);
        }
        if (rep.getRefreshTokenMaxReuse() != null) {
            newRealm.setRefreshTokenMaxReuse(rep.getRefreshTokenMaxReuse().intValue());
        } else {
            newRealm.setRefreshTokenMaxReuse(0);
        }
        if (rep.getAccessTokenLifespan() != null) {
            newRealm.setAccessTokenLifespan(rep.getAccessTokenLifespan().intValue());
        } else {
            newRealm.setAccessTokenLifespan(300);
        }
        if (rep.getAccessTokenLifespanForImplicitFlow() != null) {
            newRealm.setAccessTokenLifespanForImplicitFlow(rep.getAccessTokenLifespanForImplicitFlow().intValue());
        } else {
            newRealm.setAccessTokenLifespanForImplicitFlow(900);
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            newRealm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout().intValue());
        } else {
            newRealm.setSsoSessionIdleTimeout(1800);
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            newRealm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan().intValue());
        } else {
            newRealm.setSsoSessionMaxLifespan(36000);
        }
        if (rep.getOfflineSessionIdleTimeout() != null) {
            newRealm.setOfflineSessionIdleTimeout(rep.getOfflineSessionIdleTimeout().intValue());
        } else {
            newRealm.setOfflineSessionIdleTimeout(2592000);
        }
        if (rep.getAccessCodeLifespan() != null) {
            newRealm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        } else {
            newRealm.setAccessCodeLifespan(60);
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            newRealm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        } else {
            newRealm.setAccessCodeLifespanUserAction(300);
        }
        if (rep.getAccessCodeLifespanLogin() != null) {
            newRealm.setAccessCodeLifespanLogin(rep.getAccessCodeLifespanLogin().intValue());
        } else {
            newRealm.setAccessCodeLifespanLogin(1800);
        }
        if (rep.getActionTokenGeneratedByAdminLifespan() != null) {
            newRealm.setActionTokenGeneratedByAdminLifespan(rep.getActionTokenGeneratedByAdminLifespan().intValue());
        } else {
            newRealm.setActionTokenGeneratedByAdminLifespan(43200);
        }
        if (rep.getActionTokenGeneratedByUserLifespan() != null) {
            newRealm.setActionTokenGeneratedByUserLifespan(rep.getActionTokenGeneratedByUserLifespan().intValue());
        } else {
            newRealm.setActionTokenGeneratedByUserLifespan(newRealm.getAccessCodeLifespanUserAction());
        }
        if (rep.getSslRequired() != null) {
            newRealm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.isRegistrationAllowed() != null) {
            newRealm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isRegistrationEmailAsUsername() != null) {
            newRealm.setRegistrationEmailAsUsername(rep.isRegistrationEmailAsUsername().booleanValue());
        }
        if (rep.isRememberMe() != null) {
            newRealm.setRememberMe(rep.isRememberMe().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            newRealm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isLoginWithEmailAllowed() != null) {
            newRealm.setLoginWithEmailAllowed(rep.isLoginWithEmailAllowed().booleanValue());
        }
        if (rep.isDuplicateEmailsAllowed() != null) {
            newRealm.setDuplicateEmailsAllowed(rep.isDuplicateEmailsAllowed().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            newRealm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isEditUsernameAllowed() != null) {
            newRealm.setEditUsernameAllowed(rep.isEditUsernameAllowed().booleanValue());
        }
        if (rep.getLoginTheme() != null) {
            newRealm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            newRealm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            newRealm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            newRealm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.getRequiredCredentials() != null) {
            for (String string : rep.getRequiredCredentials()) {
                newRealm.addRequiredCredential(string);
            }
        } else {
            newRealm.addRequiredCredential("password");
        }
        if (rep.getPasswordPolicy() != null) {
            newRealm.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)rep.getPasswordPolicy()));
        }
        if (rep.getOtpPolicyType() != null) {
            newRealm.setOTPPolicy(RepresentationToModel.toPolicy(rep));
        } else {
            newRealm.setOTPPolicy(OTPPolicy.DEFAULT_POLICY);
        }
        RepresentationToModel.importAuthenticationFlows(newRealm, rep);
        if (rep.getRequiredActions() != null) {
            for (RequiredActionProviderRepresentation requiredActionProviderRepresentation : rep.getRequiredActions()) {
                RequiredActionProviderModel model = RepresentationToModel.toModel(requiredActionProviderRepresentation);
                MigrationUtils.updateOTPRequiredAction(model);
                newRealm.addRequiredActionProvider(model);
            }
        } else {
            DefaultRequiredActions.addActions(newRealm);
        }
        RepresentationToModel.importIdentityProviders(rep, newRealm);
        RepresentationToModel.importIdentityProviderMappers(rep, newRealm);
        if (rep.getClientTemplates() != null) {
            RepresentationToModel.createClientTemplates(session, rep, newRealm);
        }
        if (rep.getClients() != null) {
            RepresentationToModel.createClients(session, rep, newRealm);
        }
        RepresentationToModel.importRoles(rep.getRoles(), newRealm);
        if (rep.getDefaultRoles() != null) {
            for (String string : rep.getDefaultRoles()) {
                newRealm.addDefaultRole(string.trim());
            }
        }
        if (rep.getClients() != null) {
            for (ClientRepresentation clientRepresentation : rep.getClients()) {
                if (clientRepresentation.getDefaultRoles() == null) continue;
                ClientModel clientModel = newRealm.getClientByClientId(clientRepresentation.getClientId());
                clientModel.updateDefaultRoles(clientRepresentation.getDefaultRoles());
            }
        }
        if (rep.getClientScopeMappings() != null) {
            for (Map.Entry entry : rep.getClientScopeMappings().entrySet()) {
                ClientModel app = newRealm.getClientByClientId((String)entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                RepresentationToModel.createClientScopeMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getScopeMappings() != null) {
            for (ScopeMappingRepresentation scopeMappingRepresentation : rep.getScopeMappings()) {
                ScopeContainerModel scopeContainer = RepresentationToModel.getScopeContainerHavingScope(newRealm, scopeMappingRepresentation);
                for (String roleString : scopeMappingRepresentation.getRoles()) {
                    RoleModel role = newRealm.getRole(roleString.trim());
                    if (role == null) {
                        role = newRealm.addRole(roleString.trim());
                    }
                    scopeContainer.addScopeMapping(role);
                }
            }
        }
        if (rep.getSmtpServer() != null) {
            newRealm.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            newRealm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        } else {
            newRealm.setBrowserSecurityHeaders(BrowserSecurityHeaders.defaultHeaders);
        }
        if (rep.getComponents() != null) {
            MultivaluedHashMap components = rep.getComponents();
            String string = newRealm.getId();
            RepresentationToModel.importComponents(newRealm, (MultivaluedHashMap<String, ComponentExportRepresentation>)components, string);
        }
        RepresentationToModel.importUserFederationProvidersAndMappers(session, rep, newRealm);
        if (rep.getGroups() != null) {
            RepresentationToModel.importGroups(newRealm, rep);
            if (rep.getDefaultGroups() != null) {
                for (String string : rep.getDefaultGroups()) {
                    GroupModel found = KeycloakModelUtils.findGroupByPath(newRealm, string);
                    if (found == null) {
                        throw new RuntimeException("default group in realm rep doesn't exist: " + string);
                    }
                    newRealm.addDefaultGroup(found);
                }
            }
        }
        if (rep.getUsers() != null) {
            for (UserRepresentation userRepresentation : rep.getUsers()) {
                UserModel userModel = RepresentationToModel.createUser(session, newRealm, userRepresentation);
            }
        }
        if (rep.getFederatedUsers() != null) {
            for (UserRepresentation userRepresentation : rep.getFederatedUsers()) {
                RepresentationToModel.importFederatedUser(session, newRealm, userRepresentation);
            }
        }
        if (!skipUserDependent) {
            RepresentationToModel.importRealmAuthorizationSettings(rep, newRealm, session);
        }
        if (rep.isInternationalizationEnabled() != null) {
            newRealm.setInternationalizationEnabled(rep.isInternationalizationEnabled().booleanValue());
        }
        if (rep.getSupportedLocales() != null) {
            newRealm.setSupportedLocales(new HashSet(rep.getSupportedLocales()));
        }
        if (rep.getDefaultLocale() != null) {
            newRealm.setDefaultLocale(rep.getDefaultLocale());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                newRealm.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (newRealm.getComponents(newRealm.getId(), KeyProvider.class.getName()).isEmpty()) {
            if (rep.getPrivateKey() != null) {
                DefaultKeyProviders.createProviders(newRealm, rep.getPrivateKey(), rep.getCertificate());
            } else {
                DefaultKeyProviders.createProviders(newRealm);
            }
        }
    }

    public static void importUserFederationProvidersAndMappers(KeycloakSession session, RealmRepresentation rep, RealmModel newRealm) {
        HashSet<String> convertSet = new HashSet<String>();
        convertSet.add("ldap");
        convertSet.add("kerberos");
        HashMap<String, String> mapperConvertSet = new HashMap<String, String>();
        mapperConvertSet.put("ldap", "org.keycloak.storage.ldap.mappers.LDAPStorageMapper");
        HashMap<String, ComponentModel> userStorageModels = new HashMap<String, ComponentModel>();
        if (rep.getUserFederationProviders() != null) {
            for (UserFederationProviderRepresentation fedRep : rep.getUserFederationProviders()) {
                if (!convertSet.contains(fedRep.getProviderName())) continue;
                ComponentModel component = RepresentationToModel.convertFedProviderToComponent(newRealm.getId(), fedRep);
                userStorageModels.put(fedRep.getDisplayName(), newRealm.importComponentModel(component));
            }
        }
        HashSet storageProvidersWhichShouldImportDefaultMappers = new HashSet(userStorageModels.keySet());
        if (rep.getUserFederationMappers() != null) {
            for (UserFederationMapperRepresentation representation : rep.getUserFederationMappers()) {
                if (!userStorageModels.containsKey(representation.getFederationProviderDisplayName())) continue;
                ComponentModel parent = (ComponentModel)userStorageModels.get(representation.getFederationProviderDisplayName());
                String newMapperType = (String)mapperConvertSet.get(parent.getProviderId());
                ComponentModel mapper = RepresentationToModel.convertFedMapperToComponent(newRealm, parent, representation, newMapperType);
                newRealm.importComponentModel(mapper);
                storageProvidersWhichShouldImportDefaultMappers.remove(representation.getFederationProviderDisplayName());
            }
        }
        for (String providerDisplayName : storageProvidersWhichShouldImportDefaultMappers) {
            ComponentUtil.notifyCreated(session, newRealm, (ComponentModel)userStorageModels.get(providerDisplayName));
        }
    }

    protected static void importComponents(RealmModel newRealm, MultivaluedHashMap<String, ComponentExportRepresentation> components, String parentId) {
        for (Map.Entry entry : components.entrySet()) {
            String providerType = (String)entry.getKey();
            for (ComponentExportRepresentation compRep : (List)entry.getValue()) {
                ComponentModel component = new ComponentModel();
                component.setId(compRep.getId());
                component.setName(compRep.getName());
                component.setConfig(compRep.getConfig());
                component.setProviderType(providerType);
                component.setProviderId(compRep.getProviderId());
                component.setSubType(compRep.getSubType());
                component.setParentId(parentId);
                component = newRealm.importComponentModel(component);
                if (compRep.getSubComponents() == null) continue;
                RepresentationToModel.importComponents(newRealm, (MultivaluedHashMap<String, ComponentExportRepresentation>)compRep.getSubComponents(), component.getId());
            }
        }
    }

    public static void importRoles(RolesRepresentation realmRoles, RealmModel realm) {
        RoleModel role;
        ClientModel client;
        if (realmRoles == null) {
            return;
        }
        if (realmRoles.getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realmRoles.getRealm()) {
                RepresentationToModel.createRole(realm, roleRepresentation);
            }
        }
        if (realmRoles.getClient() != null) {
            for (Map.Entry entry : realmRoles.getClient().entrySet()) {
                client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                }
                for (RoleRepresentation roleRep : (List)entry.getValue()) {
                    role = roleRep.getId() != null ? client.addRole(roleRep.getId(), roleRep.getName()) : client.addRole(roleRep.getName());
                    role.setDescription(roleRep.getDescription());
                    boolean scopeParamRequired = roleRep.isScopeParamRequired() == null ? false : roleRep.isScopeParamRequired();
                    role.setScopeParamRequired(scopeParamRequired);
                }
            }
        }
        if (realmRoles.getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realmRoles.getRealm()) {
                RoleModel role2 = realm.getRole(roleRepresentation.getName());
                RepresentationToModel.addComposites(role2, roleRepresentation, realm);
            }
        }
        if (realmRoles.getClient() != null) {
            for (Map.Entry entry : realmRoles.getClient().entrySet()) {
                client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                }
                for (RoleRepresentation roleRep : (List)entry.getValue()) {
                    role = client.getRole(roleRep.getName());
                    RepresentationToModel.addComposites(role, roleRep, realm);
                }
            }
        }
    }

    public static void importGroups(RealmModel realm, RealmRepresentation rep) {
        List groups = rep.getGroups();
        if (groups == null) {
            return;
        }
        GroupModel parent = null;
        for (GroupRepresentation group : groups) {
            RepresentationToModel.importGroup(realm, parent, group);
        }
    }

    public static void importGroup(RealmModel realm, GroupModel parent, GroupRepresentation group) {
        GroupModel newGroup = realm.createGroup(group.getId(), group.getName());
        if (group.getAttributes() != null) {
            for (Map.Entry attr : group.getAttributes().entrySet()) {
                newGroup.setAttribute((String)attr.getKey(), (List)attr.getValue());
            }
        }
        realm.moveGroup(newGroup, parent);
        if (group.getRealmRoles() != null) {
            for (String roleString : group.getRealmRoles()) {
                RoleModel role = realm.getRole(roleString.trim());
                if (role == null) {
                    role = realm.addRole(roleString.trim());
                }
                newGroup.grantRole(role);
            }
        }
        if (group.getClientRoles() != null) {
            for (Map.Entry entry : group.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                List roleNames = (List)entry.getValue();
                for (String roleName : roleNames) {
                    RoleModel role = client.getRole(roleName.trim());
                    if (role == null) {
                        role = client.addRole(roleName.trim());
                    }
                    newGroup.grantRole(role);
                }
            }
        }
        if (group.getSubGroups() != null) {
            for (GroupRepresentation subGroup : group.getSubGroups()) {
                RepresentationToModel.importGroup(realm, newGroup, subGroup);
            }
        }
    }

    public static void importAuthenticationFlows(RealmModel newRealm, RealmRepresentation rep) {
        if (rep.getAuthenticationFlows() == null) {
            DefaultAuthenticationFlows.migrateFlows(newRealm);
        } else {
            AuthenticatorConfigModel model;
            for (AuthenticatorConfigRepresentation configRep : rep.getAuthenticatorConfig()) {
                model = RepresentationToModel.toModel(configRep);
                newRealm.addAuthenticatorConfig(model);
            }
            for (Object flowRep : rep.getAuthenticationFlows()) {
                model = RepresentationToModel.toModel((AuthenticationFlowRepresentation)flowRep);
                model.setId(null);
                model = newRealm.addAuthenticationFlow((AuthenticationFlowModel)model);
            }
            for (Object flowRep : rep.getAuthenticationFlows()) {
                model = newRealm.getFlowByAlias(flowRep.getAlias());
                for (AuthenticationExecutionExportRepresentation exeRep : flowRep.getAuthenticationExecutions()) {
                    AuthenticationExecutionModel execution = RepresentationToModel.toModel(newRealm, exeRep);
                    execution.setParentFlow(model.getId());
                    newRealm.addAuthenticatorExecution(execution);
                }
            }
        }
        if (rep.getBrowserFlow() == null) {
            newRealm.setBrowserFlow(newRealm.getFlowByAlias("browser"));
        } else {
            newRealm.setBrowserFlow(newRealm.getFlowByAlias(rep.getBrowserFlow()));
        }
        if (rep.getRegistrationFlow() == null) {
            newRealm.setRegistrationFlow(newRealm.getFlowByAlias("registration"));
        } else {
            newRealm.setRegistrationFlow(newRealm.getFlowByAlias(rep.getRegistrationFlow()));
        }
        if (rep.getDirectGrantFlow() == null) {
            newRealm.setDirectGrantFlow(newRealm.getFlowByAlias("direct grant"));
        } else {
            newRealm.setDirectGrantFlow(newRealm.getFlowByAlias(rep.getDirectGrantFlow()));
        }
        if (rep.getResetCredentialsFlow() == null) {
            AuthenticationFlowModel resetFlow = newRealm.getFlowByAlias("reset credentials");
            if (resetFlow == null) {
                DefaultAuthenticationFlows.resetCredentialsFlow(newRealm);
            } else {
                newRealm.setResetCredentialsFlow(resetFlow);
            }
        } else {
            newRealm.setResetCredentialsFlow(newRealm.getFlowByAlias(rep.getResetCredentialsFlow()));
        }
        if (rep.getClientAuthenticationFlow() == null) {
            AuthenticationFlowModel clientFlow = newRealm.getFlowByAlias("clients");
            if (clientFlow == null) {
                DefaultAuthenticationFlows.clientAuthFlow(newRealm);
            } else {
                newRealm.setClientAuthenticationFlow(clientFlow);
            }
        } else {
            newRealm.setClientAuthenticationFlow(newRealm.getFlowByAlias(rep.getClientAuthenticationFlow()));
        }
        if (newRealm.getFlowByAlias("first broker login") == null) {
            DefaultAuthenticationFlows.firstBrokerLoginFlow(newRealm, true);
        }
        String defaultProvider = null;
        if (rep.getIdentityProviders() != null) {
            for (IdentityProviderRepresentation i : rep.getIdentityProviders()) {
                if (!i.isEnabled() || !i.isAuthenticateByDefault()) continue;
                defaultProvider = i.getProviderId();
                break;
            }
        }
        if (rep.getDockerAuthenticationFlow() == null) {
            AuthenticationFlowModel dockerAuthenticationFlow = newRealm.getFlowByAlias("docker auth");
            if (dockerAuthenticationFlow == null) {
                DefaultAuthenticationFlows.dockerAuthenticationFlow(newRealm);
            } else {
                newRealm.setDockerAuthenticationFlow(dockerAuthenticationFlow);
            }
        } else {
            newRealm.setDockerAuthenticationFlow(newRealm.getFlowByAlias(rep.getDockerAuthenticationFlow()));
        }
        DefaultAuthenticationFlows.addIdentityProviderAuthenticator(newRealm, defaultProvider);
    }

    private static void convertDeprecatedSocialProviders(RealmRepresentation rep) {
        if (rep.isSocial() != null && rep.isSocial().booleanValue() && rep.getSocialProviders() != null && !rep.getSocialProviders().isEmpty() && rep.getIdentityProviders() == null) {
            Boolean updateProfileFirstLogin = rep.isUpdateProfileOnInitialSocialLogin() != null && rep.isUpdateProfileOnInitialSocialLogin() != false;
            if (rep.getSocialProviders() != null) {
                logger.warn((Object)"Using deprecated 'social' configuration in JSON representation. It will be removed in future versions");
                LinkedList<IdentityProviderRepresentation> identityProviders = new LinkedList<IdentityProviderRepresentation>();
                for (String k : rep.getSocialProviders().keySet()) {
                    if (!k.endsWith(".key")) continue;
                    String providerId = k.split("\\.")[0];
                    String key = (String)rep.getSocialProviders().get(k);
                    String secret = (String)rep.getSocialProviders().get(k.replace(".key", ".secret"));
                    IdentityProviderRepresentation identityProvider = new IdentityProviderRepresentation();
                    identityProvider.setAlias(providerId);
                    identityProvider.setProviderId(providerId);
                    identityProvider.setEnabled(true);
                    identityProvider.setLinkOnly(false);
                    identityProvider.setUpdateProfileFirstLogin(updateProfileFirstLogin.booleanValue());
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("clientId", key);
                    config.put("clientSecret", secret);
                    identityProvider.setConfig(config);
                    identityProviders.add(identityProvider);
                }
                rep.setIdentityProviders(identityProviders);
            }
        }
    }

    private static void convertDeprecatedSocialProviders(UserRepresentation user) {
        if (user.getSocialLinks() != null && !user.getSocialLinks().isEmpty() && user.getFederatedIdentities() == null) {
            logger.warnf("Using deprecated 'socialLinks' configuration in JSON representation for user '%s'. It will be removed in future versions", (Object)user.getUsername());
            LinkedList<FederatedIdentityRepresentation> federatedIdentities = new LinkedList<FederatedIdentityRepresentation>();
            for (SocialLinkRepresentation social : user.getSocialLinks()) {
                FederatedIdentityRepresentation federatedIdentity = new FederatedIdentityRepresentation();
                federatedIdentity.setIdentityProvider(social.getSocialProvider());
                federatedIdentity.setUserId(social.getSocialUserId());
                federatedIdentity.setUserName(social.getSocialUsername());
                federatedIdentities.add(federatedIdentity);
            }
            user.setFederatedIdentities(federatedIdentities);
        }
        user.setSocialLinks(null);
    }

    private static void convertDeprecatedApplications(KeycloakSession session, RealmRepresentation realm) {
        if (realm.getApplications() != null || realm.getOauthClients() != null) {
            if (realm.getClients() == null) {
                realm.setClients(new LinkedList());
            }
            LinkedList clients = new LinkedList();
            if (realm.getApplications() != null) {
                clients.addAll(realm.getApplications());
            }
            if (realm.getOauthClients() != null) {
                clients.addAll(realm.getOauthClients());
            }
            for (ApplicationRepresentation app : clients) {
                app.setClientId(app.getName());
                app.setName(null);
                if (app instanceof OAuthClientRepresentation) {
                    app.setConsentRequired(Boolean.valueOf(true));
                    app.setFullScopeAllowed(Boolean.valueOf(false));
                }
                if (app.getProtocolMappers() == null && app.getClaims() != null) {
                    long mask = RepresentationToModel.getClaimsMask(app.getClaims());
                    List<ProtocolMapperRepresentation> convertedProtocolMappers = ((MigrationProvider)session.getProvider(MigrationProvider.class)).getMappersForClaimMask(mask);
                    app.setProtocolMappers(convertedProtocolMappers);
                    app.setClaims(null);
                }
                realm.getClients().add(app);
            }
        }
        if (realm.getApplicationScopeMappings() != null && realm.getClientScopeMappings() == null) {
            realm.setClientScopeMappings(realm.getApplicationScopeMappings());
        }
        if (realm.getRoles() != null && realm.getRoles().getApplication() != null && realm.getRoles().getClient() == null) {
            realm.getRoles().setClient(realm.getRoles().getApplication());
        }
        if (realm.getUsers() != null) {
            for (UserRepresentation userRepresentation : realm.getUsers()) {
                if (userRepresentation.getApplicationRoles() == null || userRepresentation.getClientRoles() != null) continue;
                userRepresentation.setClientRoles(userRepresentation.getApplicationRoles());
            }
        }
        if (realm.getRoles() != null && realm.getRoles().getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realm.getRoles().getRealm()) {
                if (roleRepresentation.getComposites() == null || roleRepresentation.getComposites().getApplication() == null || roleRepresentation.getComposites().getClient() != null) continue;
                roleRepresentation.getComposites().setClient(roleRepresentation.getComposites().getApplication());
            }
        }
        if (realm.getRoles() != null && realm.getRoles().getClient() != null) {
            for (Map.Entry entry : realm.getRoles().getClient().entrySet()) {
                for (RoleRepresentation role : (List)entry.getValue()) {
                    if (role.getComposites() == null || role.getComposites().getApplication() == null || role.getComposites().getClient() != null) continue;
                    role.getComposites().setClient(role.getComposites().getApplication());
                }
            }
        }
    }

    public static void renameRealm(RealmModel realm, String name) {
        ClientModel accountClient;
        if (name.equals(realm.getName())) {
            return;
        }
        String oldName = realm.getName();
        ClientModel masterApp = realm.getMasterAdminClient();
        masterApp.setClientId(KeycloakModelUtils.getMasterRealmAdminApplicationClientId(name));
        realm.setName(name);
        ClientModel adminClient = realm.getClientByClientId("security-admin-console");
        if (adminClient != null) {
            if (adminClient.getBaseUrl() != null) {
                adminClient.setBaseUrl(adminClient.getBaseUrl().replace("/admin/" + oldName + "/", "/admin/" + name + "/"));
            }
            HashSet<String> adminRedirectUris = new HashSet<String>();
            for (String r : adminClient.getRedirectUris()) {
                adminRedirectUris.add(RepresentationToModel.replace(r, "/admin/" + oldName + "/", "/admin/" + name + "/"));
            }
            adminClient.setRedirectUris(adminRedirectUris);
        }
        if ((accountClient = realm.getClientByClientId("account")) != null) {
            if (accountClient.getBaseUrl() != null) {
                accountClient.setBaseUrl(accountClient.getBaseUrl().replace("/realms/" + oldName + "/", "/realms/" + name + "/"));
            }
            HashSet<String> accountRedirectUris = new HashSet<String>();
            for (String r : accountClient.getRedirectUris()) {
                accountRedirectUris.add(RepresentationToModel.replace(r, "/realms/" + oldName + "/", "/realms/" + name + "/"));
            }
            accountClient.setRedirectUris(accountRedirectUris);
        }
    }

    private static String replace(String url, String target, String replacement) {
        return url != null ? url.replace(target, replacement) : null;
    }

    public static void updateRealm(RealmRepresentation rep, RealmModel realm, KeycloakSession session) {
        if (rep.getRealm() != null) {
            RepresentationToModel.renameRealm(realm, rep.getRealm());
        }
        if (rep.getAttributes() != null) {
            HashSet attrsToRemove = new HashSet(realm.getAttributes().keySet());
            attrsToRemove.removeAll(rep.getAttributes().keySet());
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                realm.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            for (String attr : attrsToRemove) {
                realm.removeAttribute(attr);
            }
        }
        if (rep.getDisplayName() != null) {
            realm.setDisplayName(rep.getDisplayName());
        }
        if (rep.getDisplayNameHtml() != null) {
            realm.setDisplayNameHtml(rep.getDisplayNameHtml());
        }
        if (rep.isEnabled() != null) {
            realm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isBruteForceProtected() != null) {
            realm.setBruteForceProtected(rep.isBruteForceProtected().booleanValue());
        }
        if (rep.isPermanentLockout() != null) {
            realm.setPermanentLockout(rep.isPermanentLockout().booleanValue());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            realm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds().intValue());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            realm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds().intValue());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            realm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds().intValue());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            realm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds().longValue());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            realm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds().intValue());
        }
        if (rep.getFailureFactor() != null) {
            realm.setFailureFactor(rep.getFailureFactor().intValue());
        }
        if (rep.isRegistrationAllowed() != null) {
            realm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isRegistrationEmailAsUsername() != null) {
            realm.setRegistrationEmailAsUsername(rep.isRegistrationEmailAsUsername().booleanValue());
        }
        if (rep.isRememberMe() != null) {
            realm.setRememberMe(rep.isRememberMe().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            realm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isLoginWithEmailAllowed() != null) {
            realm.setLoginWithEmailAllowed(rep.isLoginWithEmailAllowed().booleanValue());
        }
        if (rep.isDuplicateEmailsAllowed() != null) {
            realm.setDuplicateEmailsAllowed(rep.isDuplicateEmailsAllowed().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            realm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isEditUsernameAllowed() != null) {
            realm.setEditUsernameAllowed(rep.isEditUsernameAllowed().booleanValue());
        }
        if (rep.getSslRequired() != null) {
            realm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.getAccessCodeLifespan() != null) {
            realm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            realm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        }
        if (rep.getAccessCodeLifespanLogin() != null) {
            realm.setAccessCodeLifespanLogin(rep.getAccessCodeLifespanLogin().intValue());
        }
        if (rep.getActionTokenGeneratedByAdminLifespan() != null) {
            realm.setActionTokenGeneratedByAdminLifespan(rep.getActionTokenGeneratedByAdminLifespan().intValue());
        }
        if (rep.getActionTokenGeneratedByUserLifespan() != null) {
            realm.setActionTokenGeneratedByUserLifespan(rep.getActionTokenGeneratedByUserLifespan().intValue());
        }
        if (rep.getNotBefore() != null) {
            realm.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getRevokeRefreshToken() != null) {
            realm.setRevokeRefreshToken(rep.getRevokeRefreshToken().booleanValue());
        }
        if (rep.getRefreshTokenMaxReuse() != null) {
            realm.setRefreshTokenMaxReuse(rep.getRefreshTokenMaxReuse().intValue());
        }
        if (rep.getAccessTokenLifespan() != null) {
            realm.setAccessTokenLifespan(rep.getAccessTokenLifespan().intValue());
        }
        if (rep.getAccessTokenLifespanForImplicitFlow() != null) {
            realm.setAccessTokenLifespanForImplicitFlow(rep.getAccessTokenLifespanForImplicitFlow().intValue());
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            realm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout().intValue());
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            realm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan().intValue());
        }
        if (rep.getOfflineSessionIdleTimeout() != null) {
            realm.setOfflineSessionIdleTimeout(rep.getOfflineSessionIdleTimeout().intValue());
        }
        if (rep.getRequiredCredentials() != null) {
            realm.updateRequiredCredentials(rep.getRequiredCredentials());
        }
        if (rep.getLoginTheme() != null) {
            realm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            realm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            realm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            realm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.isEventsEnabled() != null) {
            realm.setEventsEnabled(rep.isEventsEnabled().booleanValue());
        }
        if (rep.getEventsExpiration() != null) {
            realm.setEventsExpiration(rep.getEventsExpiration().longValue());
        }
        if (rep.getEventsListeners() != null) {
            realm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.getEnabledEventTypes() != null) {
            realm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            realm.setAdminEventsEnabled(rep.isAdminEventsEnabled().booleanValue());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            realm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled().booleanValue());
        }
        if (rep.getPasswordPolicy() != null) {
            realm.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)session, (String)rep.getPasswordPolicy()));
        }
        if (rep.getOtpPolicyType() != null) {
            realm.setOTPPolicy(RepresentationToModel.toPolicy(rep));
        }
        if (rep.getDefaultRoles() != null) {
            realm.updateDefaultRoles(rep.getDefaultRoles().toArray(new String[rep.getDefaultRoles().size()]));
        }
        if (rep.getSmtpServer() != null) {
            HashMap<String, String> config = new HashMap<String, String>(rep.getSmtpServer());
            if (rep.getSmtpServer().containsKey("password") && "**********".equals(rep.getSmtpServer().get("password"))) {
                String passwordValue = realm.getSmtpConfig() != null ? (String)realm.getSmtpConfig().get("password") : null;
                config.put("password", passwordValue);
            }
            realm.setSmtpConfig(config);
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            realm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        }
        if (rep.isInternationalizationEnabled() != null) {
            realm.setInternationalizationEnabled(rep.isInternationalizationEnabled().booleanValue());
        }
        if (rep.getSupportedLocales() != null) {
            realm.setSupportedLocales(new HashSet(rep.getSupportedLocales()));
        }
        if (rep.getDefaultLocale() != null) {
            realm.setDefaultLocale(rep.getDefaultLocale());
        }
        if (rep.getBrowserFlow() != null) {
            realm.setBrowserFlow(realm.getFlowByAlias(rep.getBrowserFlow()));
        }
        if (rep.getRegistrationFlow() != null) {
            realm.setRegistrationFlow(realm.getFlowByAlias(rep.getRegistrationFlow()));
        }
        if (rep.getDirectGrantFlow() != null) {
            realm.setDirectGrantFlow(realm.getFlowByAlias(rep.getDirectGrantFlow()));
        }
        if (rep.getResetCredentialsFlow() != null) {
            realm.setResetCredentialsFlow(realm.getFlowByAlias(rep.getResetCredentialsFlow()));
        }
        if (rep.getClientAuthenticationFlow() != null) {
            realm.setClientAuthenticationFlow(realm.getFlowByAlias(rep.getClientAuthenticationFlow()));
        }
        if (rep.getDockerAuthenticationFlow() != null) {
            realm.setDockerAuthenticationFlow(realm.getFlowByAlias(rep.getDockerAuthenticationFlow()));
        }
    }

    public static ComponentModel convertFedProviderToComponent(String realmId, UserFederationProviderRepresentation fedModel) {
        UserStorageProviderModel model = new UserStorageProviderModel();
        model.setId(fedModel.getId());
        model.setName(fedModel.getDisplayName());
        model.setParentId(realmId);
        model.setProviderId(fedModel.getProviderName());
        model.setProviderType(UserStorageProvider.class.getName());
        model.setFullSyncPeriod(fedModel.getFullSyncPeriod());
        model.setPriority(fedModel.getPriority());
        model.setChangedSyncPeriod(fedModel.getChangedSyncPeriod());
        model.setLastSync(fedModel.getLastSync());
        if (fedModel.getConfig() != null) {
            for (Map.Entry entry : fedModel.getConfig().entrySet()) {
                model.getConfig().putSingle(entry.getKey(), entry.getValue());
            }
        }
        return model;
    }

    public static ComponentModel convertFedMapperToComponent(RealmModel realm, ComponentModel parent, UserFederationMapperRepresentation rep, String newMapperType) {
        ComponentModel mapper = new ComponentModel();
        mapper.setId(rep.getId());
        mapper.setName(rep.getName());
        mapper.setProviderId(rep.getFederationMapperType());
        mapper.setProviderType(newMapperType);
        mapper.setParentId(parent.getId());
        if (rep.getConfig() != null) {
            for (Map.Entry entry : rep.getConfig().entrySet()) {
                mapper.getConfig().putSingle(entry.getKey(), entry.getValue());
            }
        }
        return mapper;
    }

    public static void createRole(RealmModel newRealm, RoleRepresentation roleRep) {
        RoleModel role;
        RoleModel roleModel = role = roleRep.getId() != null ? newRealm.addRole(roleRep.getId(), roleRep.getName()) : newRealm.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
        boolean scopeParamRequired = roleRep.isScopeParamRequired() == null ? false : roleRep.isScopeParamRequired();
        role.setScopeParamRequired(scopeParamRequired);
    }

    private static void addComposites(RoleModel role, RoleRepresentation roleRep, RealmModel realm) {
        if (roleRep.getComposites() == null) {
            return;
        }
        if (roleRep.getComposites().getRealm() != null) {
            for (String string : roleRep.getComposites().getRealm()) {
                RoleModel realmRole = realm.getRole(string);
                if (realmRole == null) {
                    throw new RuntimeException("Unable to find composite realm role: " + string);
                }
                role.addCompositeRole(realmRole);
            }
        }
        if (roleRep.getComposites().getClient() != null) {
            for (Map.Entry entry : roleRep.getComposites().getClient().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + roleRep.getName());
                }
                for (String roleStr : (List)entry.getValue()) {
                    RoleModel clientRole = client.getRole(roleStr);
                    if (clientRole == null) {
                        throw new RuntimeException("Unable to find composite client role: " + roleStr);
                    }
                    role.addCompositeRole(clientRole);
                }
            }
        }
    }

    private static Map<String, ClientModel> createClients(KeycloakSession session, RealmRepresentation rep, RealmModel realm) {
        HashMap<String, ClientModel> appMap = new HashMap<String, ClientModel>();
        for (ClientRepresentation resourceRep : rep.getClients()) {
            ClientModel app = RepresentationToModel.createClient(session, realm, resourceRep, false);
            appMap.put(app.getClientId(), app);
        }
        return appMap;
    }

    public static ClientModel createClient(KeycloakSession session, RealmModel realm, ClientRepresentation resourceRep, boolean addDefaultRoles) {
        ClientModel client;
        logger.debug((Object)("Create client: {0}" + resourceRep.getClientId()));
        ClientModel clientModel = client = resourceRep.getId() != null ? realm.addClient(resourceRep.getId(), resourceRep.getClientId()) : realm.addClient(resourceRep.getClientId());
        if (resourceRep.getName() != null) {
            client.setName(resourceRep.getName());
        }
        if (resourceRep.getDescription() != null) {
            client.setDescription(resourceRep.getDescription());
        }
        if (resourceRep.isEnabled() != null) {
            client.setEnabled(resourceRep.isEnabled().booleanValue());
        }
        client.setManagementUrl(resourceRep.getAdminUrl());
        if (resourceRep.isSurrogateAuthRequired() != null) {
            client.setSurrogateAuthRequired(resourceRep.isSurrogateAuthRequired().booleanValue());
        }
        if (resourceRep.getRootUrl() != null) {
            client.setRootUrl(resourceRep.getRootUrl());
        }
        if (resourceRep.getBaseUrl() != null) {
            client.setBaseUrl(resourceRep.getBaseUrl());
        }
        if (resourceRep.isBearerOnly() != null) {
            client.setBearerOnly(resourceRep.isBearerOnly().booleanValue());
        }
        if (resourceRep.isConsentRequired() != null) {
            client.setConsentRequired(resourceRep.isConsentRequired().booleanValue());
        }
        if (resourceRep.isDirectGrantsOnly() != null) {
            logger.warn((Object)"Using deprecated 'directGrantsOnly' configuration in JSON representation. It will be removed in future versions");
            client.setStandardFlowEnabled(resourceRep.isDirectGrantsOnly() == false);
            client.setDirectAccessGrantsEnabled(resourceRep.isDirectGrantsOnly().booleanValue());
        }
        if (resourceRep.isStandardFlowEnabled() != null) {
            client.setStandardFlowEnabled(resourceRep.isStandardFlowEnabled().booleanValue());
        }
        if (resourceRep.isImplicitFlowEnabled() != null) {
            client.setImplicitFlowEnabled(resourceRep.isImplicitFlowEnabled().booleanValue());
        }
        if (resourceRep.isDirectAccessGrantsEnabled() != null) {
            client.setDirectAccessGrantsEnabled(resourceRep.isDirectAccessGrantsEnabled().booleanValue());
        }
        if (resourceRep.isServiceAccountsEnabled() != null) {
            client.setServiceAccountsEnabled(resourceRep.isServiceAccountsEnabled().booleanValue());
        }
        if (resourceRep.isPublicClient() != null) {
            client.setPublicClient(resourceRep.isPublicClient().booleanValue());
        }
        if (resourceRep.isFrontchannelLogout() != null) {
            client.setFrontchannelLogout(resourceRep.isFrontchannelLogout().booleanValue());
        }
        if (resourceRep.getProtocol() != null) {
            client.setProtocol(resourceRep.getProtocol());
        } else {
            client.setProtocol(OIDC);
        }
        if (resourceRep.getNodeReRegistrationTimeout() != null) {
            client.setNodeReRegistrationTimeout(resourceRep.getNodeReRegistrationTimeout().intValue());
        } else {
            client.setNodeReRegistrationTimeout(-1);
        }
        if (resourceRep.getNotBefore() != null) {
            client.setNotBefore(resourceRep.getNotBefore().intValue());
        }
        if (resourceRep.getClientAuthenticatorType() != null) {
            client.setClientAuthenticatorType(resourceRep.getClientAuthenticatorType());
        } else {
            client.setClientAuthenticatorType(KeycloakModelUtils.getDefaultClientAuthenticatorType());
        }
        client.setSecret(resourceRep.getSecret());
        if (client.getSecret() == null) {
            KeycloakModelUtils.generateSecret(client);
        }
        if (resourceRep.getAttributes() != null) {
            for (Map.Entry entry : resourceRep.getAttributes().entrySet()) {
                client.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (resourceRep.getRedirectUris() != null) {
            for (String string : resourceRep.getRedirectUris()) {
                client.addRedirectUri(string);
            }
        }
        if (resourceRep.getWebOrigins() != null) {
            for (String string : resourceRep.getWebOrigins()) {
                logger.debugv("Client: {0} webOrigin: {1}", (Object)resourceRep.getClientId(), (Object)string);
                client.addWebOrigin(string);
            }
        } else if (resourceRep.getRedirectUris() != null) {
            HashSet origins = new HashSet();
            for (String redirectUri : resourceRep.getRedirectUris()) {
                logger.debugv("add redirect-uri to origin: {0}", (Object)redirectUri);
                if (!redirectUri.startsWith("http")) continue;
                String origin = UriUtils.getOrigin((String)redirectUri);
                logger.debugv("adding default client origin: {0}", (Object)origin);
                origins.add(origin);
            }
            if (origins.size() > 0) {
                client.setWebOrigins((Set)origins);
            }
        }
        if (resourceRep.getRegisteredNodes() != null) {
            for (Map.Entry entry : resourceRep.getRegisteredNodes().entrySet()) {
                client.registerNode((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
        }
        if (addDefaultRoles && resourceRep.getDefaultRoles() != null) {
            client.updateDefaultRoles(resourceRep.getDefaultRoles());
        }
        if (resourceRep.getProtocolMappers() != null) {
            Set mappers = client.getProtocolMappers();
            for (ProtocolMapperModel mapper : mappers) {
                client.removeProtocolMapper(mapper);
            }
            for (ProtocolMapperModel mapper : resourceRep.getProtocolMappers()) {
                client.addProtocolMapper(RepresentationToModel.toModel((ProtocolMapperRepresentation)mapper));
            }
            MigrationUtils.updateProtocolMappers((ProtocolMapperContainerModel)client);
        }
        if (resourceRep.getClientTemplate() != null) {
            for (ClientTemplateModel clientTemplateModel : realm.getClientTemplates()) {
                if (clientTemplateModel.getName().equals(resourceRep.getClientTemplate())) {
                    client.setClientTemplate(clientTemplateModel);
                    break;
                }
                MigrationUtils.updateProtocolMappers((ProtocolMapperContainerModel)clientTemplateModel);
            }
        }
        if (resourceRep.isFullScopeAllowed() != null) {
            client.setFullScopeAllowed(resourceRep.isFullScopeAllowed().booleanValue());
        } else if (client.getClientTemplate() != null) {
            client.setFullScopeAllowed(!client.isConsentRequired() && client.getClientTemplate().isFullScopeAllowed());
        } else {
            client.setFullScopeAllowed(!client.isConsentRequired());
        }
        if (resourceRep.isUseTemplateConfig() != null) {
            client.setUseTemplateConfig(resourceRep.isUseTemplateConfig().booleanValue());
        } else {
            client.setUseTemplateConfig(false);
        }
        if (resourceRep.isUseTemplateScope() != null) {
            client.setUseTemplateScope(resourceRep.isUseTemplateScope().booleanValue());
        } else {
            client.setUseTemplateScope(resourceRep.getClientTemplate() != null);
        }
        if (resourceRep.isUseTemplateMappers() != null) {
            client.setUseTemplateMappers(resourceRep.isUseTemplateMappers().booleanValue());
        } else {
            client.setUseTemplateMappers(resourceRep.getClientTemplate() != null);
        }
        client.updateClient();
        return client;
    }

    public static void updateClient(ClientRepresentation rep, ClientModel resource) {
        List webOrigins;
        List redirectUris;
        if (rep.getClientId() != null) {
            resource.setClientId(rep.getClientId());
        }
        if (rep.getName() != null) {
            resource.setName(rep.getName());
        }
        if (rep.getDescription() != null) {
            resource.setDescription(rep.getDescription());
        }
        if (rep.isEnabled() != null) {
            resource.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isBearerOnly() != null) {
            resource.setBearerOnly(rep.isBearerOnly().booleanValue());
        }
        if (rep.isConsentRequired() != null) {
            resource.setConsentRequired(rep.isConsentRequired().booleanValue());
        }
        if (rep.isStandardFlowEnabled() != null) {
            resource.setStandardFlowEnabled(rep.isStandardFlowEnabled().booleanValue());
        }
        if (rep.isImplicitFlowEnabled() != null) {
            resource.setImplicitFlowEnabled(rep.isImplicitFlowEnabled().booleanValue());
        }
        if (rep.isDirectAccessGrantsEnabled() != null) {
            resource.setDirectAccessGrantsEnabled(rep.isDirectAccessGrantsEnabled().booleanValue());
        }
        if (rep.isServiceAccountsEnabled() != null) {
            resource.setServiceAccountsEnabled(rep.isServiceAccountsEnabled().booleanValue());
        }
        if (rep.isPublicClient() != null) {
            resource.setPublicClient(rep.isPublicClient().booleanValue());
        }
        if (rep.isFullScopeAllowed() != null) {
            resource.setFullScopeAllowed(rep.isFullScopeAllowed().booleanValue());
        }
        if (rep.isFrontchannelLogout() != null) {
            resource.setFrontchannelLogout(rep.isFrontchannelLogout().booleanValue());
        }
        if (rep.getRootUrl() != null) {
            resource.setRootUrl(rep.getRootUrl());
        }
        if (rep.getAdminUrl() != null) {
            resource.setManagementUrl(rep.getAdminUrl());
        }
        if (rep.getBaseUrl() != null) {
            resource.setBaseUrl(rep.getBaseUrl());
        }
        if (rep.isSurrogateAuthRequired() != null) {
            resource.setSurrogateAuthRequired(rep.isSurrogateAuthRequired().booleanValue());
        }
        if (rep.getNodeReRegistrationTimeout() != null) {
            resource.setNodeReRegistrationTimeout(rep.getNodeReRegistrationTimeout().intValue());
        }
        if (rep.getClientAuthenticatorType() != null) {
            resource.setClientAuthenticatorType(rep.getClientAuthenticatorType());
        }
        if (rep.getProtocol() != null) {
            resource.setProtocol(rep.getProtocol());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                resource.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (rep.getNotBefore() != null) {
            resource.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getDefaultRoles() != null) {
            resource.updateDefaultRoles(rep.getDefaultRoles());
        }
        if ((redirectUris = rep.getRedirectUris()) != null) {
            resource.setRedirectUris(new HashSet(redirectUris));
        }
        if ((webOrigins = rep.getWebOrigins()) != null) {
            resource.setWebOrigins(new HashSet(webOrigins));
        }
        if (rep.getRegisteredNodes() != null) {
            for (Map.Entry entry : rep.getRegisteredNodes().entrySet()) {
                resource.registerNode((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
        }
        if (rep.isUseTemplateConfig() != null) {
            resource.setUseTemplateConfig(rep.isUseTemplateConfig().booleanValue());
        }
        if (rep.isUseTemplateScope() != null) {
            resource.setUseTemplateScope(rep.isUseTemplateScope().booleanValue());
        }
        if (rep.isUseTemplateMappers() != null) {
            resource.setUseTemplateMappers(rep.isUseTemplateMappers().booleanValue());
        }
        if (rep.getSecret() != null) {
            resource.setSecret(rep.getSecret());
        }
        if (rep.getClientTemplate() != null) {
            if (rep.getClientTemplate().equals("NONE")) {
                resource.setClientTemplate(null);
            } else {
                RealmModel realm = resource.getRealm();
                for (ClientTemplateModel template : realm.getClientTemplates()) {
                    if (!template.getName().equals(rep.getClientTemplate())) continue;
                    resource.setClientTemplate(template);
                    if (rep.isUseTemplateConfig() == null) {
                        resource.setUseTemplateConfig(true);
                    }
                    if (rep.isUseTemplateScope() == null) {
                        resource.setUseTemplateScope(true);
                    }
                    if (rep.isUseTemplateMappers() != null) break;
                    resource.setUseTemplateMappers(true);
                    break;
                }
            }
        }
        resource.updateClient();
    }

    private static Map<String, ClientTemplateModel> createClientTemplates(KeycloakSession session, RealmRepresentation rep, RealmModel realm) {
        HashMap<String, ClientTemplateModel> appMap = new HashMap<String, ClientTemplateModel>();
        for (ClientTemplateRepresentation resourceRep : rep.getClientTemplates()) {
            ClientTemplateModel app = RepresentationToModel.createClientTemplate(session, realm, resourceRep);
            appMap.put(app.getName(), app);
        }
        return appMap;
    }

    public static ClientTemplateModel createClientTemplate(KeycloakSession session, RealmModel realm, ClientTemplateRepresentation resourceRep) {
        ClientTemplateModel client;
        logger.debug((Object)("Create client template: {0}" + resourceRep.getName()));
        ClientTemplateModel clientTemplateModel = client = resourceRep.getId() != null ? realm.addClientTemplate(resourceRep.getId(), resourceRep.getName()) : realm.addClientTemplate(resourceRep.getName());
        if (resourceRep.getName() != null) {
            client.setName(resourceRep.getName());
        }
        if (resourceRep.getDescription() != null) {
            client.setDescription(resourceRep.getDescription());
        }
        if (resourceRep.getProtocol() != null) {
            client.setProtocol(resourceRep.getProtocol());
        }
        if (resourceRep.isFullScopeAllowed() != null) {
            client.setFullScopeAllowed(resourceRep.isFullScopeAllowed().booleanValue());
        }
        if (resourceRep.getProtocolMappers() != null) {
            Set mappers = client.getProtocolMappers();
            for (ProtocolMapperModel mapper : mappers) {
                client.removeProtocolMapper(mapper);
            }
            for (ProtocolMapperModel mapper : resourceRep.getProtocolMappers()) {
                client.addProtocolMapper(RepresentationToModel.toModel((ProtocolMapperRepresentation)mapper));
            }
        }
        if (resourceRep.isBearerOnly() != null) {
            client.setBearerOnly(resourceRep.isBearerOnly().booleanValue());
        }
        if (resourceRep.isConsentRequired() != null) {
            client.setConsentRequired(resourceRep.isConsentRequired().booleanValue());
        }
        if (resourceRep.isStandardFlowEnabled() != null) {
            client.setStandardFlowEnabled(resourceRep.isStandardFlowEnabled().booleanValue());
        }
        if (resourceRep.isImplicitFlowEnabled() != null) {
            client.setImplicitFlowEnabled(resourceRep.isImplicitFlowEnabled().booleanValue());
        }
        if (resourceRep.isDirectAccessGrantsEnabled() != null) {
            client.setDirectAccessGrantsEnabled(resourceRep.isDirectAccessGrantsEnabled().booleanValue());
        }
        if (resourceRep.isServiceAccountsEnabled() != null) {
            client.setServiceAccountsEnabled(resourceRep.isServiceAccountsEnabled().booleanValue());
        }
        if (resourceRep.isPublicClient() != null) {
            client.setPublicClient(resourceRep.isPublicClient().booleanValue());
        }
        if (resourceRep.isFrontchannelLogout() != null) {
            client.setFrontchannelLogout(resourceRep.isFrontchannelLogout().booleanValue());
        }
        if (resourceRep.getAttributes() != null) {
            for (Map.Entry entry : resourceRep.getAttributes().entrySet()) {
                client.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return client;
    }

    public static void updateClientTemplate(ClientTemplateRepresentation rep, ClientTemplateModel resource) {
        if (rep.getName() != null) {
            resource.setName(rep.getName());
        }
        if (rep.getDescription() != null) {
            resource.setDescription(rep.getDescription());
        }
        if (rep.isFullScopeAllowed() != null) {
            resource.setFullScopeAllowed(rep.isFullScopeAllowed().booleanValue());
        }
        if (rep.getProtocol() != null) {
            resource.setProtocol(rep.getProtocol());
        }
        if (rep.isBearerOnly() != null) {
            resource.setBearerOnly(rep.isBearerOnly().booleanValue());
        }
        if (rep.isConsentRequired() != null) {
            resource.setConsentRequired(rep.isConsentRequired().booleanValue());
        }
        if (rep.isStandardFlowEnabled() != null) {
            resource.setStandardFlowEnabled(rep.isStandardFlowEnabled().booleanValue());
        }
        if (rep.isImplicitFlowEnabled() != null) {
            resource.setImplicitFlowEnabled(rep.isImplicitFlowEnabled().booleanValue());
        }
        if (rep.isDirectAccessGrantsEnabled() != null) {
            resource.setDirectAccessGrantsEnabled(rep.isDirectAccessGrantsEnabled().booleanValue());
        }
        if (rep.isServiceAccountsEnabled() != null) {
            resource.setServiceAccountsEnabled(rep.isServiceAccountsEnabled().booleanValue());
        }
        if (rep.isPublicClient() != null) {
            resource.setPublicClient(rep.isPublicClient().booleanValue());
        }
        if (rep.isFullScopeAllowed() != null) {
            resource.setFullScopeAllowed(rep.isFullScopeAllowed().booleanValue());
        }
        if (rep.isFrontchannelLogout() != null) {
            resource.setFrontchannelLogout(rep.isFrontchannelLogout().booleanValue());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                resource.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static long getClaimsMask(ClaimRepresentation rep) {
        long mask = 1023L;
        mask = rep.getAddress() ? (mask |= 0x100L) : (mask &= 0xFFFFFFFFFFFFFEFFL);
        mask = rep.getEmail() ? (mask |= 0x20L) : (mask &= 0xFFFFFFFFFFFFFFDFL);
        mask = rep.getGender() ? (mask |= 0x40L) : (mask &= 0xFFFFFFFFFFFFFFBFL);
        mask = rep.getLocale() ? (mask |= 0x80L) : (mask &= 0xFFFFFFFFFFFFFF7FL);
        mask = rep.getName() ? (mask |= 1L) : (mask &= 0xFFFFFFFFFFFFFFFEL);
        mask = rep.getPhone() ? (mask |= 0x200L) : (mask &= 0xFFFFFFFFFFFFFDFFL);
        mask = rep.getPicture() ? (mask |= 8L) : (mask &= 0xFFFFFFFFFFFFFFF7L);
        mask = rep.getProfile() ? (mask |= 4L) : (mask &= 0xFFFFFFFFFFFFFFFBL);
        mask = rep.getUsername() ? (mask |= 2L) : (mask &= 0xFFFFFFFFFFFFFFFDL);
        mask = rep.getWebsite() ? (mask |= 0x10L) : (mask &= 0xFFFFFFFFFFFFFFEFL);
        return mask;
    }

    public static void createClientScopeMappings(RealmModel realm, ClientModel clientModel, List<ScopeMappingRepresentation> mappings) {
        for (ScopeMappingRepresentation mapping : mappings) {
            ScopeContainerModel scopeContainer = RepresentationToModel.getScopeContainerHavingScope(realm, mapping);
            for (String roleString : mapping.getRoles()) {
                RoleModel role = clientModel.getRole(roleString.trim());
                if (role == null) {
                    role = clientModel.addRole(roleString.trim());
                }
                scopeContainer.addScopeMapping(role);
            }
        }
    }

    private static ScopeContainerModel getScopeContainerHavingScope(RealmModel realm, ScopeMappingRepresentation scope) {
        if (scope.getClient() != null) {
            ClientModel client = realm.getClientByClientId(scope.getClient());
            if (client == null) {
                throw new RuntimeException("Unknown client specification in scope mappings: " + scope.getClient());
            }
            return client;
        }
        if (scope.getClientTemplate() != null) {
            ClientTemplateModel clientTemplate = KeycloakModelUtils.getClientTemplateByName(realm, scope.getClientTemplate());
            if (clientTemplate == null) {
                throw new RuntimeException("Unknown clientTemplate specification in scope mappings: " + scope.getClientTemplate());
            }
            return clientTemplate;
        }
        throw new RuntimeException("Either client or clientTemplate needs to be specified in scope mappings");
    }

    public static UserModel createUser(KeycloakSession session, RealmModel newRealm, UserRepresentation userRep) {
        RepresentationToModel.convertDeprecatedSocialProviders(userRep);
        UserModel user = session.userLocalStorage().addUser(newRealm, userRep.getId(), userRep.getUsername(), false, false);
        user.setEnabled(userRep.isEnabled() != null && userRep.isEnabled() != false);
        user.setCreatedTimestamp(userRep.getCreatedTimestamp());
        user.setEmail(userRep.getEmail());
        if (userRep.isEmailVerified() != null) {
            user.setEmailVerified(userRep.isEmailVerified().booleanValue());
        }
        user.setFirstName(userRep.getFirstName());
        user.setLastName(userRep.getLastName());
        user.setFederationLink(userRep.getFederationLink());
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                List value = (List)entry.getValue();
                if (value == null) continue;
                user.setAttribute((String)entry.getKey(), new ArrayList(value));
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String requiredAction : userRep.getRequiredActions()) {
                user.addRequiredAction(UserModel.RequiredAction.valueOf((String)requiredAction.toUpperCase()));
            }
        }
        RepresentationToModel.createCredentials(userRep, session, newRealm, user, false);
        if (userRep.getFederatedIdentities() != null) {
            for (FederatedIdentityRepresentation identity : userRep.getFederatedIdentities()) {
                FederatedIdentityModel mappingModel = new FederatedIdentityModel(identity.getIdentityProvider(), identity.getUserId(), identity.getUserName());
                session.users().addFederatedIdentity(newRealm, user, mappingModel);
            }
        }
        RepresentationToModel.createRoleMappings(userRep, user, newRealm);
        if (userRep.getClientConsents() != null) {
            for (UserConsentRepresentation consentRep : userRep.getClientConsents()) {
                UserConsentModel consentModel = RepresentationToModel.toModel(newRealm, consentRep);
                session.users().addConsent(newRealm, user.getId(), consentModel);
            }
        }
        if (userRep.getNotBefore() != null) {
            session.users().setNotBeforeForUser(newRealm, user, userRep.getNotBefore().intValue());
        }
        if (userRep.getServiceAccountClientId() != null) {
            String clientId = userRep.getServiceAccountClientId();
            ClientModel client = newRealm.getClientByClientId(clientId);
            if (client == null) {
                throw new RuntimeException("Unable to find client specified for service account link. Client: " + clientId);
            }
            user.setServiceAccountClientLink(client.getId());
        }
        if (userRep.getGroups() != null) {
            for (String path : userRep.getGroups()) {
                GroupModel group = KeycloakModelUtils.findGroupByPath(newRealm, path);
                if (group == null) {
                    throw new RuntimeException("Unable to find group specified by path: " + path);
                }
                user.joinGroup(group);
            }
        }
        return user;
    }

    public static void createCredentials(UserRepresentation userRep, KeycloakSession session, RealmModel realm, UserModel user, boolean adminRequest) {
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                RepresentationToModel.updateCredential(session, realm, user, cred, adminRequest);
            }
        }
    }

    private static void updateCredential(KeycloakSession session, RealmModel realm, UserModel user, CredentialRepresentation cred, boolean adminRequest) {
        if (cred.getValue() != null) {
            PasswordUserCredentialModel plainTextCred = RepresentationToModel.convertCredential(cred);
            plainTextCred.setAdminRequest(adminRequest);
            session.userCredentialManager().updateCredential(realm, user, (CredentialInput)plainTextCred);
        } else {
            CredentialModel hashedCred = new CredentialModel();
            hashedCred.setType(cred.getType());
            hashedCred.setDevice(cred.getDevice());
            if (cred.getHashIterations() != null) {
                hashedCred.setHashIterations(cred.getHashIterations().intValue());
            }
            try {
                if (cred.getSalt() != null) {
                    hashedCred.setSalt(Base64.decode((String)cred.getSalt()));
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            hashedCred.setValue(cred.getHashedSaltedValue());
            if (cred.getCounter() != null) {
                hashedCred.setCounter(cred.getCounter().intValue());
            }
            if (cred.getDigits() != null) {
                hashedCred.setDigits(cred.getDigits().intValue());
            }
            if (cred.getAlgorithm() != null) {
                if (("password".equals(cred.getType()) || "password-history".equals(cred.getType())) && cred.getAlgorithm().equals("HmacSHA1")) {
                    hashedCred.setAlgorithm("pbkdf2");
                } else {
                    hashedCred.setAlgorithm(cred.getAlgorithm());
                }
            } else if ("password".equals(cred.getType()) || "password-history".equals(cred.getType())) {
                hashedCred.setAlgorithm("pbkdf2");
            } else if (UserCredentialModel.isOtp((String)cred.getType())) {
                hashedCred.setAlgorithm("HmacSHA1");
            }
            if (cred.getPeriod() != null) {
                hashedCred.setPeriod(cred.getPeriod().intValue());
            }
            if (cred.getDigits() == null && UserCredentialModel.isOtp((String)cred.getType())) {
                hashedCred.setDigits(6);
            }
            if (cred.getPeriod() == null && "totp".equals(cred.getType())) {
                hashedCred.setPeriod(30);
            }
            hashedCred.setCreatedDate(cred.getCreatedDate());
            session.userCredentialManager().createCredential(realm, user, hashedCred);
        }
    }

    public static PasswordUserCredentialModel convertCredential(CredentialRepresentation cred) {
        PasswordUserCredentialModel credential = new PasswordUserCredentialModel();
        credential.setType(cred.getType());
        credential.setValue(cred.getValue());
        return credential;
    }

    public static CredentialModel toModel(CredentialRepresentation cred) {
        CredentialModel model = new CredentialModel();
        model.setHashIterations(cred.getHashIterations().intValue());
        model.setCreatedDate(cred.getCreatedDate());
        model.setType(cred.getType());
        model.setDigits(cred.getDigits().intValue());
        model.setConfig(cred.getConfig());
        model.setDevice(cred.getDevice());
        model.setAlgorithm(cred.getAlgorithm());
        model.setCounter(cred.getCounter().intValue());
        model.setPeriod(cred.getPeriod().intValue());
        if (cred.getSalt() != null) {
            try {
                model.setSalt(Base64.decode((String)cred.getSalt()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        model.setValue(cred.getValue());
        if (cred.getHashedSaltedValue() != null) {
            model.setValue(cred.getHashedSaltedValue());
        }
        return model;
    }

    public static void createRoleMappings(UserRepresentation userRep, UserModel user, RealmModel realm) {
        if (userRep.getRealmRoles() != null) {
            for (String string : userRep.getRealmRoles()) {
                RoleModel role = realm.getRole(string.trim());
                if (role == null) {
                    role = realm.addRole(string.trim());
                }
                user.grantRole(role);
            }
        }
        if (userRep.getClientRoles() != null) {
            for (Map.Entry entry : userRep.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                RepresentationToModel.createClientRoleMappings(client, user, (List)entry.getValue());
            }
        }
    }

    public static void createClientRoleMappings(ClientModel clientModel, UserModel user, List<String> roleNames) {
        if (user == null) {
            throw new RuntimeException("User not found");
        }
        for (String roleName : roleNames) {
            RoleModel role = clientModel.getRole(roleName.trim());
            if (role == null) {
                role = clientModel.addRole(roleName.trim());
            }
            user.grantRole(role);
        }
    }

    private static void importIdentityProviders(RealmRepresentation rep, RealmModel newRealm) {
        if (rep.getIdentityProviders() != null) {
            for (IdentityProviderRepresentation representation : rep.getIdentityProviders()) {
                newRealm.addIdentityProvider(RepresentationToModel.toModel(newRealm, representation));
            }
        }
    }

    private static void importIdentityProviderMappers(RealmRepresentation rep, RealmModel newRealm) {
        if (rep.getIdentityProviderMappers() != null) {
            for (IdentityProviderMapperRepresentation representation : rep.getIdentityProviderMappers()) {
                newRealm.addIdentityProviderMapper(RepresentationToModel.toModel(representation));
            }
        }
    }

    public static IdentityProviderModel toModel(RealmModel realm, IdentityProviderRepresentation representation) {
        AuthenticationFlowModel flowModel;
        IdentityProviderModel identityProviderModel = new IdentityProviderModel();
        identityProviderModel.setInternalId(representation.getInternalId());
        identityProviderModel.setAlias(representation.getAlias());
        identityProviderModel.setDisplayName(representation.getDisplayName());
        identityProviderModel.setProviderId(representation.getProviderId());
        identityProviderModel.setEnabled(representation.isEnabled());
        identityProviderModel.setLinkOnly(representation.isLinkOnly());
        identityProviderModel.setTrustEmail(representation.isTrustEmail());
        identityProviderModel.setAuthenticateByDefault(representation.isAuthenticateByDefault());
        identityProviderModel.setStoreToken(representation.isStoreToken());
        identityProviderModel.setAddReadTokenRoleOnCreate(representation.isAddReadTokenRoleOnCreate());
        identityProviderModel.setConfig(new HashMap(representation.getConfig()));
        String flowAlias = representation.getFirstBrokerLoginFlowAlias();
        if (flowAlias == null) {
            flowAlias = "first broker login";
        }
        if ((flowModel = realm.getFlowByAlias(flowAlias)) == null) {
            throw new ModelException("No available authentication flow with alias: " + flowAlias);
        }
        identityProviderModel.setFirstBrokerLoginFlowId(flowModel.getId());
        flowAlias = representation.getPostBrokerLoginFlowAlias();
        if (flowAlias == null || flowAlias.trim().length() == 0) {
            identityProviderModel.setPostBrokerLoginFlowId(null);
        } else {
            flowModel = realm.getFlowByAlias(flowAlias);
            if (flowModel == null) {
                throw new ModelException("No available authentication flow with alias: " + flowAlias);
            }
            identityProviderModel.setPostBrokerLoginFlowId(flowModel.getId());
        }
        return identityProviderModel;
    }

    public static ProtocolMapperModel toModel(ProtocolMapperRepresentation rep) {
        ProtocolMapperModel model = new ProtocolMapperModel();
        model.setId(rep.getId());
        model.setName(rep.getName());
        model.setConsentRequired(rep.isConsentRequired());
        model.setConsentText(rep.getConsentText());
        model.setProtocol(rep.getProtocol());
        model.setProtocolMapper(rep.getProtocolMapper());
        model.setConfig(RepresentationToModel.removeEmptyString(rep.getConfig()));
        return model;
    }

    public static IdentityProviderMapperModel toModel(IdentityProviderMapperRepresentation rep) {
        IdentityProviderMapperModel model = new IdentityProviderMapperModel();
        model.setId(rep.getId());
        model.setName(rep.getName());
        model.setIdentityProviderAlias(rep.getIdentityProviderAlias());
        model.setIdentityProviderMapper(rep.getIdentityProviderMapper());
        model.setConfig(RepresentationToModel.removeEmptyString(rep.getConfig()));
        return model;
    }

    public static UserConsentModel toModel(RealmModel newRealm, UserConsentRepresentation consentRep) {
        ClientModel client = newRealm.getClientByClientId(consentRep.getClientId());
        if (client == null) {
            throw new RuntimeException("Unable to find client consent mappings for client: " + consentRep.getClientId());
        }
        UserConsentModel consentModel = new UserConsentModel(client);
        consentModel.setCreatedDate(consentRep.getCreatedDate());
        consentModel.setLastUpdatedDate(consentRep.getLastUpdatedDate());
        if (consentRep.getGrantedRealmRoles() != null) {
            for (String string : consentRep.getGrantedRealmRoles()) {
                RoleModel role = newRealm.getRole(string);
                if (role == null) {
                    throw new RuntimeException("Unable to find realm role referenced in consent mappings of user. Role name: " + string);
                }
                consentModel.addGrantedRole(role);
            }
        }
        if (consentRep.getGrantedClientRoles() != null) {
            for (Map.Entry entry : consentRep.getGrantedClientRoles().entrySet()) {
                String clientId2 = (String)entry.getKey();
                ClientModel client2 = newRealm.getClientByClientId(clientId2);
                if (client2 == null) {
                    throw new RuntimeException("Unable to find client referenced in consent mappings. Client ID: " + clientId2);
                }
                for (String clientRoleName : (List)entry.getValue()) {
                    RoleModel clientRole = client2.getRole(clientRoleName);
                    if (clientRole == null) {
                        throw new RuntimeException("Unable to find client role referenced in consent mappings of user. Role name: " + clientRole + ", Client: " + clientId2);
                    }
                    consentModel.addGrantedRole(clientRole);
                }
            }
        }
        if (consentRep.getGrantedProtocolMappers() != null) {
            for (Map.Entry entry : consentRep.getGrantedProtocolMappers().entrySet()) {
                String protocol = (String)entry.getKey();
                for (String protocolMapperName : (List)entry.getValue()) {
                    ProtocolMapperModel protocolMapper = client.getProtocolMapperByName(protocol, protocolMapperName);
                    if (protocolMapper == null) {
                        throw new RuntimeException("Unable to find protocol mapper for protocol " + protocol + ", mapper name " + protocolMapperName);
                    }
                    consentModel.addGrantedProtocolMapper(protocolMapper);
                }
            }
        }
        return consentModel;
    }

    public static AuthenticationFlowModel toModel(AuthenticationFlowRepresentation rep) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(rep.getId());
        model.setBuiltIn(rep.isBuiltIn());
        model.setTopLevel(rep.isTopLevel());
        model.setProviderId(rep.getProviderId());
        model.setAlias(rep.getAlias());
        model.setDescription(rep.getDescription());
        return model;
    }

    public static AuthenticationExecutionModel toModel(RealmModel realm, AuthenticationExecutionExportRepresentation rep) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        if (rep.getAuthenticatorConfig() != null) {
            AuthenticatorConfigModel config = realm.getAuthenticatorConfigByAlias(rep.getAuthenticatorConfig());
            model.setAuthenticatorConfig(config.getId());
        }
        model.setAuthenticator(rep.getAuthenticator());
        model.setAuthenticatorFlow(rep.isAutheticatorFlow());
        if (rep.getFlowAlias() != null) {
            AuthenticationFlowModel flow = realm.getFlowByAlias(rep.getFlowAlias());
            model.setFlowId(flow.getId());
        }
        model.setPriority(rep.getPriority());
        model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
        return model;
    }

    public static AuthenticationExecutionModel toModel(RealmModel realm, AuthenticationExecutionRepresentation rep) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(rep.getId());
        model.setFlowId(rep.getFlowId());
        model.setAuthenticator(rep.getAuthenticator());
        model.setPriority(rep.getPriority());
        model.setParentFlow(rep.getParentFlow());
        model.setAuthenticatorFlow(rep.isAutheticatorFlow());
        model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
        if (rep.getAuthenticatorConfig() != null) {
            AuthenticatorConfigModel cfg = realm.getAuthenticatorConfigByAlias(rep.getAuthenticatorConfig());
            model.setAuthenticatorConfig(cfg.getId());
        }
        return model;
    }

    public static AuthenticatorConfigModel toModel(AuthenticatorConfigRepresentation rep) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setAlias(rep.getAlias());
        model.setConfig(rep.getConfig());
        return model;
    }

    public static RequiredActionProviderModel toModel(RequiredActionProviderRepresentation rep) {
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setConfig(rep.getConfig());
        model.setDefaultAction(rep.isDefaultAction());
        model.setEnabled(rep.isEnabled());
        model.setProviderId(rep.getProviderId());
        model.setName(rep.getName());
        model.setAlias(rep.getAlias());
        return model;
    }

    public static ComponentModel toModel(KeycloakSession session, ComponentRepresentation rep) {
        ComponentModel model = new ComponentModel();
        model.setId(rep.getId());
        model.setParentId(rep.getParentId());
        model.setProviderType(rep.getProviderType());
        model.setProviderId(rep.getProviderId());
        model.setConfig(new MultivaluedHashMap());
        model.setName(rep.getName());
        model.setSubType(rep.getSubType());
        if (rep.getConfig() != null) {
            HashSet keys = new HashSet(rep.getConfig().keySet());
            for (String k : keys) {
                List values = (List)rep.getConfig().get((Object)k);
                if (values == null) continue;
                ListIterator itr = values.listIterator();
                while (itr.hasNext()) {
                    String v = (String)itr.next();
                    if (v != null && !v.trim().isEmpty()) continue;
                    itr.remove();
                }
                if (values.isEmpty()) continue;
                model.getConfig().put((Object)k, (Object)values);
            }
        }
        return model;
    }

    public static void updateComponent(KeycloakSession session, ComponentRepresentation rep, ComponentModel component, boolean internal) {
        if (rep.getName() != null) {
            component.setName(rep.getName());
        }
        if (rep.getParentId() != null) {
            component.setParentId(rep.getParentId());
        }
        if (rep.getProviderType() != null) {
            component.setProviderType(rep.getProviderType());
        }
        if (rep.getProviderId() != null) {
            component.setProviderId(rep.getProviderId());
        }
        if (rep.getSubType() != null) {
            component.setSubType(rep.getSubType());
        }
        Map<String, ProviderConfigProperty> providerConfiguration = null;
        if (!internal) {
            providerConfiguration = ComponentUtil.getComponentConfigProperties(session, component);
        }
        if (rep.getConfig() != null) {
            HashSet keys = new HashSet(rep.getConfig().keySet());
            for (String k : keys) {
                if (!internal && !providerConfiguration.containsKey(k)) break;
                List values = (List)rep.getConfig().get((Object)k);
                if (values == null || values.isEmpty() || values.get(0) == null || ((String)values.get(0)).trim().isEmpty()) {
                    component.getConfig().remove((Object)k);
                    continue;
                }
                ListIterator itr = values.listIterator();
                while (itr.hasNext()) {
                    String v = (String)itr.next();
                    if (v != null && !v.trim().isEmpty() && !v.equals("**********")) continue;
                    itr.remove();
                }
                if (values.isEmpty()) continue;
                component.getConfig().put((Object)k, (Object)values);
            }
        }
    }

    public static void importRealmAuthorizationSettings(RealmRepresentation rep, RealmModel newRealm, KeycloakSession session) {
        if (rep.getClients() != null) {
            rep.getClients().forEach(clientRepresentation -> {
                ClientModel client = newRealm.getClientByClientId(clientRepresentation.getClientId());
                RepresentationToModel.importAuthorizationSettings(clientRepresentation, client, session);
            });
        }
    }

    public static void importAuthorizationSettings(ClientRepresentation clientRepresentation, ClientModel client, KeycloakSession session) {
        if (Boolean.TRUE.equals(clientRepresentation.getAuthorizationServicesEnabled())) {
            AuthorizationProviderFactory authorizationFactory = (AuthorizationProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(AuthorizationProvider.class);
            AuthorizationProvider authorization = authorizationFactory.create(session, client.getRealm());
            client.setServiceAccountsEnabled(true);
            client.setBearerOnly(false);
            client.setPublicClient(false);
            ResourceServerRepresentation rep = clientRepresentation.getAuthorizationSettings();
            if (rep == null) {
                rep = new ResourceServerRepresentation();
            }
            rep.setClientId(client.getId());
            RepresentationToModel.toModel(rep, authorization);
        }
    }

    public static void toModel(ResourceServerRepresentation rep, AuthorizationProvider authorization) {
        ResourceServer resourceServer;
        ResourceServerStore resourceServerStore = authorization.getStoreFactory().getResourceServerStore();
        ResourceServer existing = resourceServerStore.findById(rep.getClientId());
        if (existing == null) {
            resourceServer = resourceServerStore.create(rep.getClientId());
            resourceServer.setAllowRemoteResourceManagement(true);
            resourceServer.setPolicyEnforcementMode(PolicyEnforcementMode.ENFORCING);
        } else {
            resourceServer = existing;
        }
        resourceServer.setPolicyEnforcementMode(rep.getPolicyEnforcementMode());
        resourceServer.setAllowRemoteResourceManagement(rep.isAllowRemoteResourceManagement());
        for (ScopeRepresentation scope : rep.getScopes()) {
            RepresentationToModel.toModel(scope, resourceServer, authorization);
        }
        KeycloakSession session = authorization.getKeycloakSession();
        RealmModel realm = authorization.getRealm();
        for (ResourceRepresentation resource : rep.getResources()) {
            UserModel user;
            ResourceOwnerRepresentation owner = resource.getOwner();
            if (owner == null) {
                owner = new ResourceOwnerRepresentation();
                owner.setId(resourceServer.getId());
                resource.setOwner(owner);
            } else if (owner.getName() != null && (user = session.users().getUserByUsername(owner.getName(), realm)) != null) {
                owner.setId(user.getId());
            }
            RepresentationToModel.toModel(resource, resourceServer, authorization);
        }
        RepresentationToModel.importPolicies(authorization, resourceServer, rep.getPolicies(), null);
    }

    private static Policy importPolicies(AuthorizationProvider authorization, ResourceServer resourceServer, List<PolicyRepresentation> policiesToImport, String parentPolicyName) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        for (PolicyRepresentation policyRepresentation : policiesToImport) {
            Policy policy;
            PolicyStore policyStore;
            if (parentPolicyName != null && !parentPolicyName.equals(policyRepresentation.getName())) continue;
            Map config = policyRepresentation.getConfig();
            String applyPolicies = (String)config.get("applyPolicies");
            if (applyPolicies != null && !applyPolicies.isEmpty()) {
                policyStore = storeFactory.getPolicyStore();
                try {
                    List policies = (List)JsonSerialization.readValue((String)applyPolicies, List.class);
                    HashSet<String> policyIds = new HashSet<String>();
                    for (String policyName : policies) {
                        Policy policy2 = policyStore.findByName(policyName, resourceServer.getId());
                        if (policy2 == null) {
                            policy2 = policyStore.findById(policyName, resourceServer.getId());
                        }
                        if (policy2 == null && (policy2 = RepresentationToModel.importPolicies(authorization, resourceServer, policiesToImport, policyName)) == null) {
                            throw new RuntimeException("Policy with name [" + policyName + "] not defined.");
                        }
                        policyIds.add(policy2.getId());
                    }
                    config.put("applyPolicies", JsonSerialization.writeValueAsString(policyIds));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while importing policy [" + policyRepresentation.getName() + "].", e);
                }
            }
            if ((policy = (policyStore = storeFactory.getPolicyStore()).findById(policyRepresentation.getId(), resourceServer.getId())) == null) {
                policy = policyStore.findByName(policyRepresentation.getName(), resourceServer.getId());
            }
            policy = policy == null ? policyStore.create((AbstractPolicyRepresentation)policyRepresentation, resourceServer) : RepresentationToModel.toModel((AbstractPolicyRepresentation)policyRepresentation, authorization, policy);
            if (parentPolicyName == null || !parentPolicyName.equals(policyRepresentation.getName())) continue;
            return policy;
        }
        return null;
    }

    public static Policy toModel(AbstractPolicyRepresentation representation, AuthorizationProvider authorization, Policy model) {
        model.setName(representation.getName());
        model.setDescription(representation.getDescription());
        model.setDecisionStrategy(representation.getDecisionStrategy());
        model.setLogic(representation.getLogic());
        Set resources = representation.getResources();
        Set scopes = representation.getScopes();
        Set policies = representation.getPolicies();
        if (representation instanceof PolicyRepresentation) {
            String policiesConfig;
            String scopesConfig;
            String resourcesConfig;
            PolicyRepresentation policy = (PolicyRepresentation)PolicyRepresentation.class.cast(representation);
            if (resources == null && (resourcesConfig = (String)policy.getConfig().get("resources")) != null) {
                try {
                    resources = (Set)JsonSerialization.readValue((String)resourcesConfig, Set.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (scopes == null && (scopesConfig = (String)policy.getConfig().get("scopes")) != null) {
                try {
                    scopes = (Set)JsonSerialization.readValue((String)scopesConfig, Set.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (policies == null && (policiesConfig = (String)policy.getConfig().get("applyPolicies")) != null) {
                try {
                    policies = (Set)JsonSerialization.readValue((String)policiesConfig, Set.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            model.setConfig(policy.getConfig());
        }
        StoreFactory storeFactory = authorization.getStoreFactory();
        RepresentationToModel.updateResources(resources, model, storeFactory);
        RepresentationToModel.updateScopes(scopes, model, storeFactory);
        RepresentationToModel.updateAssociatedPolicies(policies, model, storeFactory);
        Object provider = authorization.getProviderFactory(model.getType());
        if (representation instanceof PolicyRepresentation) {
            provider.onImport(model, (PolicyRepresentation)PolicyRepresentation.class.cast(representation), authorization);
        } else if (representation.getId() == null) {
            provider.onCreate(model, (AbstractPolicyRepresentation)representation, authorization);
        } else {
            provider.onUpdate(model, (AbstractPolicyRepresentation)representation, authorization);
        }
        representation.setId(model.getId());
        return model;
    }

    private static void updateScopes(Set<String> scopeIds, Policy policy, StoreFactory storeFactory) {
        if (scopeIds != null) {
            boolean hasScope;
            if (scopeIds.isEmpty()) {
                for (Scope scope : new HashSet<Scope>(policy.getScopes())) {
                    policy.removeScope(scope);
                }
                return;
            }
            for (String scopeId : scopeIds) {
                hasScope = false;
                for (Scope scopeModel : new HashSet<Scope>(policy.getScopes())) {
                    if (!scopeModel.getId().equals(scopeId) && !scopeModel.getName().equals(scopeId)) continue;
                    hasScope = true;
                }
                if (hasScope) continue;
                ResourceServer resourceServer = policy.getResourceServer();
                Scope scope = storeFactory.getScopeStore().findById(scopeId, resourceServer.getId());
                if (scope == null && (scope = storeFactory.getScopeStore().findByName(scopeId, resourceServer.getId())) == null) {
                    throw new RuntimeException("Scope with id or name [" + scopeId + "] does not exist");
                }
                policy.addScope(scope);
            }
            for (Scope scopeModel : new HashSet<Scope>(policy.getScopes())) {
                hasScope = false;
                for (String scopeId : scopeIds) {
                    if (!scopeModel.getId().equals(scopeId) && !scopeModel.getName().equals(scopeId)) continue;
                    hasScope = true;
                }
                if (hasScope) continue;
                policy.removeScope(scopeModel);
            }
        }
        policy.removeConfig("scopes");
    }

    private static void updateAssociatedPolicies(Set<String> policyIds, Policy policy, StoreFactory storeFactory) {
        ResourceServer resourceServer = policy.getResourceServer();
        if (policyIds != null) {
            boolean hasPolicy;
            if (policyIds.isEmpty()) {
                for (Policy associated : new HashSet<Policy>(policy.getAssociatedPolicies())) {
                    policy.removeAssociatedPolicy(associated);
                }
                return;
            }
            PolicyStore policyStore = storeFactory.getPolicyStore();
            for (String policyId : policyIds) {
                hasPolicy = false;
                for (Policy policyModel : new HashSet<Policy>(policy.getAssociatedPolicies())) {
                    if (!policyModel.getId().equals(policyId) && !policyModel.getName().equals(policyId)) continue;
                    hasPolicy = true;
                }
                if (hasPolicy) continue;
                Policy associatedPolicy = policyStore.findById(policyId, resourceServer.getId());
                if (associatedPolicy == null && (associatedPolicy = policyStore.findByName(policyId, resourceServer.getId())) == null) {
                    throw new RuntimeException("Policy with id or name [" + policyId + "] does not exist");
                }
                policy.addAssociatedPolicy(associatedPolicy);
            }
            for (Policy policyModel : new HashSet<Policy>(policy.getAssociatedPolicies())) {
                hasPolicy = false;
                for (String policyId : policyIds) {
                    if (!policyModel.getId().equals(policyId) && !policyModel.getName().equals(policyId)) continue;
                    hasPolicy = true;
                }
                if (hasPolicy) continue;
                policy.removeAssociatedPolicy(policyModel);
            }
        }
        policy.removeConfig("applyPolicies");
    }

    private static void updateResources(Set<String> resourceIds, Policy policy, StoreFactory storeFactory) {
        if (resourceIds != null) {
            boolean hasResource;
            if (resourceIds.isEmpty()) {
                for (Resource resource : new HashSet<Resource>(policy.getResources())) {
                    policy.removeResource(resource);
                }
            }
            for (String resourceId : resourceIds) {
                hasResource = false;
                for (Resource resourceModel : new HashSet<Resource>(policy.getResources())) {
                    if (!resourceModel.getId().equals(resourceId) && !resourceModel.getName().equals(resourceId)) continue;
                    hasResource = true;
                }
                if (hasResource || "".equals(resourceId)) continue;
                Resource resource = storeFactory.getResourceStore().findById(resourceId, policy.getResourceServer().getId());
                if (resource == null && (resource = storeFactory.getResourceStore().findByName(resourceId, policy.getResourceServer().getId())) == null) {
                    throw new RuntimeException("Resource with id or name [" + resourceId + "] does not exist");
                }
                policy.addResource(resource);
            }
            for (Resource resourceModel : new HashSet<Resource>(policy.getResources())) {
                hasResource = false;
                for (String resourceId : resourceIds) {
                    if (!resourceModel.getId().equals(resourceId) && !resourceModel.getName().equals(resourceId)) continue;
                    hasResource = true;
                }
                if (hasResource) continue;
                policy.removeResource(resourceModel);
            }
        }
        policy.removeConfig("resources");
    }

    public static Resource toModel(ResourceRepresentation resource, ResourceServer resourceServer, AuthorizationProvider authorization) {
        String ownerId;
        ResourceStore resourceStore = authorization.getStoreFactory().getResourceStore();
        Resource existing = resource.getId() != null ? resourceStore.findById(resource.getId(), resourceServer.getId()) : resourceStore.findByName(resource.getName(), resourceServer.getId());
        if (existing != null) {
            existing.setName(resource.getName());
            existing.setType(resource.getType());
            existing.setUri(resource.getUri());
            existing.setIconUri(resource.getIconUri());
            existing.updateScopes(resource.getScopes().stream().map(scope -> RepresentationToModel.toModel(scope, resourceServer, authorization)).collect(Collectors.toSet()));
            return existing;
        }
        ResourceOwnerRepresentation owner = resource.getOwner();
        if (owner == null) {
            owner = new ResourceOwnerRepresentation();
            owner.setId(resourceServer.getId());
        }
        if ((ownerId = owner.getId()) == null) {
            throw new RuntimeException("No owner specified for resource [" + resource.getName() + "].");
        }
        ClientModel clientModel = authorization.getRealm().getClientById(resourceServer.getId());
        if (ownerId.equals(clientModel.getClientId())) {
            ownerId = resourceServer.getId();
        }
        if (!resourceServer.getId().equals(ownerId)) {
            RealmModel realm = authorization.getRealm();
            KeycloakSession keycloakSession = authorization.getKeycloakSession();
            UserProvider users = keycloakSession.users();
            UserModel ownerModel = users.getUserById(ownerId, realm);
            if (ownerModel == null) {
                ownerModel = users.getUserByUsername(ownerId, realm);
            }
            if (ownerModel == null) {
                throw new RuntimeException("Owner must be a valid username or user identifier. If the resource server, the client id or null.");
            }
            ownerId = ownerModel.getId();
        }
        Resource model = resourceStore.create(resource.getName(), resourceServer, ownerId);
        model.setType(resource.getType());
        model.setUri(resource.getUri());
        model.setIconUri(resource.getIconUri());
        Set scopes = resource.getScopes();
        if (scopes != null) {
            model.updateScopes(scopes.stream().map(scope -> RepresentationToModel.toModel(scope, resourceServer, authorization)).collect(Collectors.toSet()));
        }
        resource.setId(model.getId());
        return model;
    }

    public static Scope toModel(ScopeRepresentation scope, ResourceServer resourceServer, AuthorizationProvider authorization) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        ScopeStore scopeStore = storeFactory.getScopeStore();
        Scope existing = scope.getId() != null ? scopeStore.findById(scope.getId(), resourceServer.getId()) : scopeStore.findByName(scope.getName(), resourceServer.getId());
        if (existing != null) {
            existing.setName(scope.getName());
            existing.setIconUri(scope.getIconUri());
            return existing;
        }
        Scope model = scopeStore.create(scope.getName(), resourceServer);
        model.setIconUri(scope.getIconUri());
        scope.setId(model.getId());
        return model;
    }

    public static void importFederatedUser(KeycloakSession session, RealmModel newRealm, UserRepresentation userRep) {
        UserFederatedStorageProvider federatedStorage = session.userFederatedStorage();
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                if (value == null) continue;
                federatedStorage.setAttribute(newRealm, userRep.getId(), key, new LinkedList(value));
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String action : userRep.getRequiredActions()) {
                federatedStorage.addRequiredAction(newRealm, userRep.getId(), action);
            }
        }
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                federatedStorage.createCredential(newRealm, userRep.getId(), RepresentationToModel.toModel(cred));
            }
        }
        RepresentationToModel.createFederatedRoleMappings(federatedStorage, userRep, newRealm);
        if (userRep.getGroups() != null) {
            for (String path : userRep.getGroups()) {
                GroupModel group = KeycloakModelUtils.findGroupByPath(newRealm, path);
                if (group == null) {
                    throw new RuntimeException("Unable to find group specified by path: " + path);
                }
                federatedStorage.joinGroup(newRealm, userRep.getId(), group);
            }
        }
        if (userRep.getFederatedIdentities() != null) {
            for (FederatedIdentityRepresentation identity : userRep.getFederatedIdentities()) {
                FederatedIdentityModel mappingModel = new FederatedIdentityModel(identity.getIdentityProvider(), identity.getUserId(), identity.getUserName());
                federatedStorage.addFederatedIdentity(newRealm, userRep.getId(), mappingModel);
            }
        }
        if (userRep.getClientConsents() != null) {
            for (UserConsentRepresentation consentRep : userRep.getClientConsents()) {
                UserConsentModel consentModel = RepresentationToModel.toModel(newRealm, consentRep);
                federatedStorage.addConsent(newRealm, userRep.getId(), consentModel);
            }
        }
        if (userRep.getNotBefore() != null) {
            federatedStorage.setNotBeforeForUser(newRealm, userRep.getId(), userRep.getNotBefore().intValue());
        }
    }

    public static void createFederatedRoleMappings(UserFederatedStorageProvider federatedStorage, UserRepresentation userRep, RealmModel realm) {
        if (userRep.getRealmRoles() != null) {
            for (String string : userRep.getRealmRoles()) {
                RoleModel role = realm.getRole(string.trim());
                if (role == null) {
                    role = realm.addRole(string.trim());
                }
                federatedStorage.grantRole(realm, userRep.getId(), role);
            }
        }
        if (userRep.getClientRoles() != null) {
            for (Map.Entry entry : userRep.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                RepresentationToModel.createFederatedClientRoleMappings(federatedStorage, realm, client, userRep, (List)entry.getValue());
            }
        }
    }

    public static void createFederatedClientRoleMappings(UserFederatedStorageProvider federatedStorage, RealmModel realm, ClientModel clientModel, UserRepresentation userRep, List<String> roleNames) {
        if (userRep == null) {
            throw new RuntimeException("User not found");
        }
        for (String roleName : roleNames) {
            RoleModel role = clientModel.getRole(roleName.trim());
            if (role == null) {
                role = clientModel.addRole(roleName.trim());
            }
            federatedStorage.grantRole(realm, userRep.getId(), role);
        }
    }

    private static Map<String, String> removeEmptyString(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>(map);
        Iterator itr = m.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            if (e.getValue() != null && !((String)e.getValue()).equals("")) continue;
            itr.remove();
        }
        return m;
    }
}

