/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.deployers.StartupCountdown;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.iiop.EjbIIOPService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public class DeploymentRepositoryProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (eeModuleDescription == null) {
            return;
        }
        String applicationName = eeModuleDescription.getEarApplicationName();
        applicationName = applicationName == null ? "" : applicationName;
        DeploymentModuleIdentifier identifier = new DeploymentModuleIdentifier(applicationName, eeModuleDescription.getModuleName(), eeModuleDescription.getDistinctName());
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        HashMap<String, EjbDeploymentInformation> deploymentInformationMap = new HashMap<String, EjbDeploymentInformation>();
        HashSet<ServiceName> componentStartServices = new HashSet<ServiceName>();
        HashMap<ServiceName, InjectedValue> injectedValues = new HashMap<ServiceName, InjectedValue>();
        for (ComponentDescription component : componentDescriptions) {
            if (!(component instanceof EJBComponentDescription)) continue;
            EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)component;
            componentStartServices.add(component.getStartServiceName());
            InjectedValue componentInjectedValue = new InjectedValue();
            injectedValues.put(component.getCreateServiceName(), componentInjectedValue);
            HashMap remoteViews = new HashMap();
            HashMap<String, InjectedValue<ComponentView>> hashMap = new HashMap<String, InjectedValue<ComponentView>>();
            for (ViewDescription view : ejbComponentDescription.getViews()) {
                MethodIntf viewType;
                boolean remoteView = false;
                if (view instanceof EJBViewDescription && ((viewType = ((EJBViewDescription)view).getMethodIntf()) == MethodIntf.HOME || viewType == MethodIntf.REMOTE)) {
                    remoteView = true;
                }
                InjectedValue componentViewInjectedValue = new InjectedValue();
                if (remoteView) {
                    remoteViews.put(view.getViewClassName(), componentViewInjectedValue);
                } else {
                    hashMap.put(view.getViewClassName(), (InjectedValue<ComponentView>)componentViewInjectedValue);
                }
                injectedValues.put(view.getServiceName(), componentViewInjectedValue);
            }
            InjectedValue iorFactory = new InjectedValue();
            if (ejbComponentDescription.isExposedViaIiop()) {
                injectedValues.put(ejbComponentDescription.getServiceName().append(EjbIIOPService.SERVICE_NAME), iorFactory);
            }
            EjbDeploymentInformation info = new EjbDeploymentInformation(ejbComponentDescription.getEJBName(), (InjectedValue<EJBComponent>)componentInjectedValue, remoteViews, hashMap, (ClassLoader)module.getClassLoader(), (InjectedValue<EjbIIOPService>)iorFactory);
            deploymentInformationMap.put(ejbComponentDescription.getEJBName(), info);
        }
        StartupCountdown countdown = (StartupCountdown)deploymentUnit.getAttachment(Attachments.STARTUP_COUNTDOWN);
        ModuleDeployment deployment = new ModuleDeployment(identifier, deploymentInformationMap, countdown);
        ServiceName moduleDeploymentService = deploymentUnit.getServiceName().append(ModuleDeployment.SERVICE_NAME);
        ServiceBuilder builder = phaseContext.getServiceTarget().addService(moduleDeploymentService, (Service)deployment);
        for (Map.Entry entry : injectedValues.entrySet()) {
            builder.addDependency((ServiceName)entry.getKey(), (Injector)((InjectedValue)entry.getValue()));
        }
        builder.addDependency(DeploymentRepository.SERVICE_NAME, DeploymentRepository.class, deployment.getDeploymentRepository());
        builder.install();
        ModuleDeployment.ModuleDeploymentStartService deploymentStart = new ModuleDeployment.ModuleDeploymentStartService(identifier, countdown);
        ServiceBuilder serviceBuilder = phaseContext.getServiceTarget().addService(deploymentUnit.getServiceName().append(ModuleDeployment.START_SERVICE_NAME), (Service)deploymentStart);
        serviceBuilder.addDependencies(componentStartServices);
        serviceBuilder.addDependency(moduleDeploymentService);
        serviceBuilder.addDependency(DeploymentRepository.SERVICE_NAME, DeploymentRepository.class, deploymentStart.getDeploymentRepository());
        serviceBuilder.install();
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

