/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services;

import javax.enterprise.inject.spi.BeanManager;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.manager.BeanManagerImpl;

public class BeanManagerService
implements Service<BeanManager> {
    public static final ServiceName NAME = ServiceNames.BEAN_MANAGER_SERVICE_NAME;
    private final InjectedValue<WeldBootstrapService> weldContainer = new InjectedValue();
    private final String beanDeploymentArchiveId;
    private volatile BeanManagerImpl beanManager;

    public BeanManagerService(String beanDeploymentArchiveId) {
        this.beanDeploymentArchiveId = beanDeploymentArchiveId;
    }

    public void start(StartContext context) throws StartException {
        this.beanManager = ((WeldBootstrapService)this.weldContainer.getValue()).getBeanManager(this.beanDeploymentArchiveId);
    }

    public void stop(StopContext context) {
        this.beanManager = null;
    }

    public BeanManager getValue() throws IllegalStateException, IllegalArgumentException {
        return new BeanManagerProxy(this.beanManager);
    }

    public InjectedValue<WeldBootstrapService> getWeldContainer() {
        return this.weldContainer;
    }

    public static ServiceName serviceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(NAME);
    }
}

