/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.HMACProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class RestartLoginCookie {
    private static final Logger logger = Logger.getLogger(RestartLoginCookie.class);
    public static final String KC_RESTART = "KC_RESTART";
    @JsonProperty(value="cid")
    protected String clientId;
    @JsonProperty(value="pty")
    protected String authMethod;
    @JsonProperty(value="ruri")
    protected String redirectUri;
    @JsonProperty(value="act")
    protected String action;
    @JsonProperty(value="notes")
    protected Map<String, String> notes = new HashMap<String, String>();
    @Deprecated
    @JsonProperty(value="cs")
    protected String cs;

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String encode(KeycloakSession session, RealmModel realm) {
        KeyManager.ActiveHmacKey activeKey = session.keys().getActiveHmacKey(realm);
        JWSBuilder builder = new JWSBuilder();
        return builder.kid(activeKey.getKid()).jsonContent((Object)this).hmac256(activeKey.getSecretKey());
    }

    public RestartLoginCookie() {
    }

    public RestartLoginCookie(AuthenticationSessionModel authSession) {
        this.action = authSession.getAction();
        this.clientId = authSession.getClient().getClientId();
        this.authMethod = authSession.getProtocol();
        this.redirectUri = authSession.getRedirectUri();
        for (Map.Entry entry : authSession.getClientNotes().entrySet()) {
            this.notes.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void setRestartCookie(KeycloakSession session, RealmModel realm, ClientConnection connection, UriInfo uriInfo, AuthenticationSessionModel authSession) {
        RestartLoginCookie restart = new RestartLoginCookie(authSession);
        String encoded = restart.encode(session, realm);
        String path = AuthenticationManager.getRealmCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(KC_RESTART, encoded, path, null, null, -1, secureOnly, true);
    }

    public static void expireRestartCookie(RealmModel realm, ClientConnection connection, UriInfo uriInfo) {
        String path = AuthenticationManager.getRealmCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(KC_RESTART, "", path, null, null, 0, secureOnly, true);
    }

    public static AuthenticationSessionModel restartSession(KeycloakSession session, RealmModel realm, RootAuthenticationSessionModel rootSession, String expectedClientId) throws Exception {
        SecretKey secretKey;
        Cookie cook = (Cookie)session.getContext().getRequestHeaders().getCookies().get(KC_RESTART);
        if (cook == null) {
            logger.debug((Object)"KC_RESTART cookie doesn't exist");
            return null;
        }
        String encodedCookie = cook.getValue();
        JWSInput input = new JWSInput(encodedCookie);
        if (!HMACProvider.verify((JWSInput)input, (SecretKey)(secretKey = session.keys().getHmacSecretKey(realm, input.getHeader().getKeyId())))) {
            logger.debug((Object)"Failed to verify encoded RestartLoginCookie");
            return null;
        }
        RestartLoginCookie cookie = (RestartLoginCookie)input.readJsonContent(RestartLoginCookie.class);
        ClientModel client = realm.getClientByClientId(cookie.getClientId());
        if (client == null) {
            return null;
        }
        if (!client.getClientId().equals(expectedClientId)) {
            logger.debugf("Skip restarting from the KC_RESTART. Clients doesn't match: Cookie client: %s, Requested client: %s", (Object)client.getClientId(), (Object)expectedClientId);
            return null;
        }
        if (rootSession == null) {
            rootSession = new AuthenticationSessionManager(session).createAuthenticationSession(realm, true);
        }
        AuthenticationSessionModel authSession = rootSession.createAuthenticationSession(client);
        authSession.setProtocol(cookie.getAuthMethod());
        authSession.setRedirectUri(cookie.getRedirectUri());
        authSession.setAction(cookie.getAction());
        for (Map.Entry<String, String> entry : cookie.getNotes().entrySet()) {
            authSession.setClientNote(entry.getKey(), entry.getValue());
        }
        return authSession;
    }
}

