/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.security;

import org.wildfly.naming.client.SimpleName;

public final class SimpleNamePermissions {
    private SimpleNamePermissions() {
    }

    public static boolean impliesName(SimpleName myName, SimpleName otherName) {
        int mySize = myName.size();
        int otherSize = otherName.size();
        int len = Math.min(mySize, otherSize);
        for (int i = 0; i < len; ++i) {
            String mySeg = myName.get(i);
            String otherSeg = otherName.get(i);
            if (mySeg.equals("-")) {
                return true;
            }
            if (otherSeg.equals("-")) {
                return false;
            }
            if (mySeg.equals("*") || mySeg.equals(otherSeg)) continue;
            return false;
        }
        return mySize == otherSize;
    }
}

