/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq.client;

import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQClientProtocolManager;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.apache.activemq.artemis.core.protocol.hornetq.client.HornetQClientSessionContext;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;

public class HornetQClientProtocolManager
extends ActiveMQClientProtocolManager {
    private static final int VERSION_PLAYED = 123;

    protected void sendHandshake(Connection transportConnection) {
    }

    protected SessionContext newSessionContext(String name, int confirmationWindowSize, Channel sessionChannel, CreateSessionResponseMessage response) {
        return new HornetQClientSessionContext(name, (RemotingConnection)this.connection, sessionChannel, response.getServerVersion(), confirmationWindowSize);
    }

    protected Packet newCreateSessionPacket(Version clientVersion, String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int minLargeMessageSize, int confirmationWindowSize, long sessionChannelID) {
        return new CreateSessionMessage(name, sessionChannelID, 123, username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge, confirmationWindowSize, null);
    }

    public void sendSubscribeTopology(boolean isServer) {
        this.getChannel0().send((Packet)new SubscribeClusterTopologyUpdatesMessageV2(isServer, 123));
    }
}

