/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.execactions.ExecuteActionsActionToken;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.account.AccountFormService;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RoleMapperResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.validation.Validation;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.utils.ProfileHelper;

public class UserResource {
    private static final Logger logger = Logger.getLogger(UserResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    private UserModel user;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public UserResource(RealmModel realm, UserModel user, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.user = user;
        this.adminEvent = adminEvent.resource(ResourceType.USER);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateUser(UserRepresentation rep) {
        this.auth.users().requireManage(this.user);
        try {
            UserLoginFailureModel failureModel;
            Set<String> attrsToRemove;
            if (rep.getAttributes() != null) {
                attrsToRemove = new HashSet(this.user.getAttributes().keySet());
                attrsToRemove.removeAll(rep.getAttributes().keySet());
            } else {
                attrsToRemove = Collections.emptySet();
            }
            if (rep.isEnabled() != null && rep.isEnabled().booleanValue() && (failureModel = this.session.sessions().getUserLoginFailure(this.realm, this.user.getId())) != null) {
                failureModel.clearFailures();
            }
            UserResource.updateUserFromRep(this.user, rep, attrsToRemove, this.realm, this.session, true);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("User exists with same username or email");
        }
        catch (ReadOnlyException re) {
            return ErrorResponse.exists("User is read only!");
        }
        catch (ModelException me) {
            logger.warn((Object)"Could not update user!", (Throwable)me);
            return ErrorResponse.exists("Could not update user!");
        }
        catch (ForbiddenException fe) {
            throw fe;
        }
        catch (Exception me) {
            logger.warn((Object)"Could not update user!", (Throwable)me);
            return ErrorResponse.exists("Could not update user!");
        }
    }

    public static void updateUserFromRep(UserModel user, UserRepresentation rep, Set<String> attrsToRemove, RealmModel realm, KeycloakSession session, boolean removeMissingRequiredActions) {
        List reqActions;
        if (rep.getUsername() != null && realm.isEditUsernameAllowed()) {
            user.setUsername(rep.getUsername());
        }
        if (rep.getEmail() != null) {
            user.setEmail(rep.getEmail());
        }
        if (rep.getEmail() == "") {
            user.setEmail(null);
        }
        if (rep.getFirstName() != null) {
            user.setFirstName(rep.getFirstName());
        }
        if (rep.getLastName() != null) {
            user.setLastName(rep.getLastName());
        }
        if (rep.isEnabled() != null) {
            user.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isEmailVerified() != null) {
            user.setEmailVerified(rep.isEmailVerified().booleanValue());
        }
        if (rep.getFederationLink() != null) {
            user.setFederationLink(rep.getFederationLink());
        }
        if ((reqActions = rep.getRequiredActions()) != null) {
            HashSet<String> allActions = new HashSet<String>();
            for (ProviderFactory factory : session.getKeycloakSessionFactory().getProviderFactories(RequiredActionProvider.class)) {
                allActions.add(factory.getId());
            }
            for (String action : allActions) {
                if (reqActions.contains(action)) {
                    user.addRequiredAction(action);
                    continue;
                }
                if (!removeMissingRequiredActions) continue;
                user.removeRequiredAction(action);
            }
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                user.setAttribute((String)entry.getKey(), (List)entry.getValue());
            }
            for (String string : attrsToRemove) {
                user.removeAttribute(string);
            }
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserRepresentation getUser() {
        this.auth.users().requireView(this.user);
        UserRepresentation rep = ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)this.user);
        if (this.realm.isIdentityFederationEnabled()) {
            List<FederatedIdentityRepresentation> reps = this.getFederatedIdentities(this.user);
            rep.setFederatedIdentities(reps);
        }
        if (((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, this.realm, this.user)) {
            rep.setEnabled(Boolean.valueOf(false));
        }
        rep.setAccess(this.auth.users().getAccess(this.user));
        return rep;
    }

    @Path(value="impersonation")
    @POST
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Object> impersonate() {
        ProfileHelper.requireFeature(Profile.Feature.IMPERSONATION);
        this.auth.users().requireImpersonate(this.user);
        RealmModel authenticatedRealm = this.auth.adminAuth().getRealm();
        boolean sameRealm = false;
        if (authenticatedRealm.getId().equals(this.realm.getId())) {
            sameRealm = true;
            UserSessionModel userSession = this.session.sessions().getUserSession(authenticatedRealm, this.auth.adminAuth().getToken().getSessionState());
            AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
            AuthenticationManager.expireRememberMeCookie(this.realm, this.uriInfo, this.clientConnection);
            AuthenticationManager.backchannelLogout(this.session, authenticatedRealm, userSession, this.uriInfo, this.clientConnection, this.headers, true);
        }
        EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, this.user, this.user.getUsername(), this.clientConnection.getRemoteAddr(), "impersonate", false, null, null);
        AuthenticationManager.createLoginCookie(this.session, this.realm, userSession.getUser(), userSession, this.uriInfo, this.clientConnection);
        URI redirect = AccountFormService.accountServiceApplicationPage(this.uriInfo).build(new Object[]{this.realm.getName()});
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sameRealm", sameRealm);
        result.put("redirect", redirect.toString());
        event.event(EventType.IMPERSONATE).session(userSession).user(this.user).detail("impersonator_realm", authenticatedRealm.getName()).detail("impersonator", this.auth.adminAuth().getUser().getUsername()).success();
        return result;
    }

    @Path(value="sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getSessions() {
        this.auth.users().requireView(this.user);
        List sessions = this.session.sessions().getUserSessions(this.realm, this.user);
        ArrayList<UserSessionRepresentation> reps = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel session : sessions) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)session);
            reps.add(rep);
        }
        return reps;
    }

    @Path(value="offline-sessions/{clientId}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getOfflineSessions(@PathParam(value="clientId") String clientId) {
        this.auth.users().requireView(this.user);
        ClientModel client = this.realm.getClientById(clientId);
        if (client == null) {
            throw new NotFoundException("Client not found");
        }
        List<UserSessionModel> sessions = new UserSessionManager(this.session).findOfflineSessions(this.realm, this.user);
        ArrayList<UserSessionRepresentation> reps = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel session : sessions) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)session);
            AuthenticatedClientSessionModel clientSession = session.getAuthenticatedClientSessionByClient(clientId);
            if (clientSession == null) continue;
            rep.setLastAccess((long)clientSession.getTimestamp());
            reps.add(rep);
        }
        return reps;
    }

    @Path(value="federated-identity")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<FederatedIdentityRepresentation> getFederatedIdentity() {
        this.auth.users().requireView(this.user);
        return this.getFederatedIdentities(this.user);
    }

    private List<FederatedIdentityRepresentation> getFederatedIdentities(UserModel user) {
        Set identities = this.session.users().getFederatedIdentities(user, this.realm);
        ArrayList<FederatedIdentityRepresentation> result = new ArrayList<FederatedIdentityRepresentation>();
        for (FederatedIdentityModel identity : identities) {
            for (IdentityProviderModel identityProviderModel : this.realm.getIdentityProviders()) {
                if (!identityProviderModel.getAlias().equals(identity.getIdentityProvider())) continue;
                FederatedIdentityRepresentation rep = ModelToRepresentation.toRepresentation((FederatedIdentityModel)identity);
                result.add(rep);
            }
        }
        return result;
    }

    @Path(value="federated-identity/{provider}")
    @POST
    @NoCache
    public Response addFederatedIdentity(@PathParam(value="provider") String provider, FederatedIdentityRepresentation rep) {
        this.auth.users().requireManage(this.user);
        if (this.session.users().getFederatedIdentity(this.user, provider, this.realm) != null) {
            return ErrorResponse.exists("User is already linked with provider");
        }
        FederatedIdentityModel socialLink = new FederatedIdentityModel(provider, rep.getUserId(), rep.getUserName());
        this.session.users().addFederatedIdentity(this.realm, this.user, socialLink);
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(rep).success();
        return Response.noContent().build();
    }

    @Path(value="federated-identity/{provider}")
    @DELETE
    @NoCache
    public void removeFederatedIdentity(@PathParam(value="provider") String provider) {
        this.auth.users().requireManage(this.user);
        if (!this.session.users().removeFederatedIdentity(this.realm, this.user, provider)) {
            throw new NotFoundException("Link not found");
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="consents")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getConsents() {
        this.auth.users().requireView(this.user);
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        Set<ClientModel> offlineClients = new UserSessionManager(this.session).findClientsWithOfflineToken(this.realm, this.user);
        for (ClientModel client : this.realm.getClients()) {
            UserConsentModel consent = this.session.users().getConsentByClient(this.realm, this.user.getId(), client.getId());
            boolean hasOfflineToken = offlineClients.contains(client);
            if (consent == null && !hasOfflineToken) continue;
            UserConsentRepresentation rep = consent == null ? null : ModelToRepresentation.toRepresentation((UserConsentModel)consent);
            HashMap<String, Object> currentRep = new HashMap<String, Object>();
            currentRep.put("clientId", client.getClientId());
            currentRep.put("grantedClientScopes", rep == null ? Collections.emptyList() : rep.getGrantedClientScopes());
            currentRep.put("createdDate", rep == null ? null : rep.getCreatedDate());
            currentRep.put("lastUpdatedDate", rep == null ? null : rep.getLastUpdatedDate());
            LinkedList additionalGrants = new LinkedList();
            if (hasOfflineToken) {
                HashMap<String, String> offlineTokens = new HashMap<String, String>();
                offlineTokens.put("client", client.getId());
                offlineTokens.put("key", "Offline Token");
                additionalGrants.add(offlineTokens);
            }
            currentRep.put("additionalGrants", additionalGrants);
            result.add(currentRep);
        }
        return result;
    }

    @Path(value="consents/{client}")
    @DELETE
    @NoCache
    public void revokeConsent(@PathParam(value="client") String clientId) {
        this.auth.users().requireManage(this.user);
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            throw new NotFoundException("Client not found");
        }
        boolean revokedConsent = this.session.users().revokeConsentForClient(this.realm, this.user.getId(), client.getId());
        boolean revokedOfflineToken = new UserSessionManager(this.session).revokeOfflineToken(this.user, client);
        if (revokedConsent) {
            AuthenticationManager.backchannelLogoutUserFromClient(this.session, this.realm, this.user, client, this.uriInfo, this.headers);
        }
        if (!revokedConsent && !revokedOfflineToken) {
            throw new NotFoundException("Consent nor offline token not found");
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="logout")
    @POST
    public void logout() {
        this.auth.users().requireManage(this.user);
        this.session.users().setNotBeforeForUser(this.realm, this.user, Time.currentTime());
        List userSessions = this.session.sessions().getUserSessions(this.realm, this.user);
        for (UserSessionModel userSession : userSessions) {
            AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection, this.headers, true);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @DELETE
    @NoCache
    public Response deleteUser() {
        this.auth.users().requireManage(this.user);
        boolean removed = new UserManager(this.session).removeUser(this.realm, this.user);
        if (removed) {
            this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
            return Response.noContent().build();
        }
        return ErrorResponse.error("User couldn't be deleted", Response.Status.BAD_REQUEST);
    }

    @Path(value="role-mappings")
    public RoleMapperResource getRoleMappings() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.users().requireMapRoles(this.user);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.users().requireView(this.user);
        RoleMapperResource resource = new RoleMapperResource(this.realm, this.auth, (RoleMapperModel)this.user, this.adminEvent, manageCheck, viewCheck);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="disable-credential-types")
    @PUT
    @Consumes(value={"application/json"})
    public void disableCredentialType(List<String> credentialTypes) {
        this.auth.users().requireManage(this.user);
        if (credentialTypes == null) {
            return;
        }
        for (String type : credentialTypes) {
            this.session.userCredentialManager().disableCredentialType(this.realm, this.user, type);
        }
    }

    @Path(value="reset-password")
    @PUT
    @Consumes(value={"application/json"})
    public void resetPassword(CredentialRepresentation pass) {
        this.auth.users().requireManage(this.user);
        if (pass == null || pass.getValue() == null || !"password".equals(pass.getType())) {
            throw new BadRequestException("No password provided");
        }
        if (Validation.isBlank(pass.getValue())) {
            throw new BadRequestException("Empty password not allowed");
        }
        PasswordUserCredentialModel cred = UserCredentialModel.password((String)pass.getValue(), (boolean)true);
        try {
            this.session.userCredentialManager().updateCredential(this.realm, this.user, (CredentialInput)cred);
        }
        catch (IllegalStateException ise) {
            throw new BadRequestException("Resetting to N old passwords is not allowed.");
        }
        catch (ReadOnlyException mre) {
            throw new BadRequestException("Can't reset password as account is read only");
        }
        catch (ModelException e) {
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(e.getMessage(), MessageFormat.format(messages.getProperty(e.getMessage(), e.getMessage()), e.getParameters()), Response.Status.BAD_REQUEST);
        }
        if (pass.isTemporary() != null && pass.isTemporary().booleanValue()) {
            this.user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="remove-totp")
    @PUT
    @Consumes(value={"application/json"})
    public void removeTotp() {
        this.auth.users().requireManage(this.user);
        this.session.userCredentialManager().disableCredentialType(this.realm, this.user, "otp");
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Deprecated
    @Path(value="reset-password-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response resetPasswordEmail(@QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId) {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        return this.executeActionsEmail(redirectUri, clientId, null, actions);
    }

    @Path(value="execute-actions-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response executeActionsEmail(@QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId, @QueryParam(value="lifespan") Integer lifespan, List<String> actions) {
        String redirect;
        ClientModel client;
        this.auth.users().requireManage(this.user);
        if (this.user.getEmail() == null) {
            return ErrorResponse.error("User email missing", Response.Status.BAD_REQUEST);
        }
        if (!this.user.isEnabled()) {
            throw new WebApplicationException(ErrorResponse.error("User is disabled", Response.Status.BAD_REQUEST));
        }
        if (redirectUri != null && clientId == null) {
            throw new WebApplicationException(ErrorResponse.error("Client id missing", Response.Status.BAD_REQUEST));
        }
        if (clientId == null) {
            clientId = "account";
        }
        if ((client = this.realm.getClientByClientId(clientId)) == null || !client.isEnabled()) {
            throw new WebApplicationException(ErrorResponse.error(clientId + " not enabled", Response.Status.BAD_REQUEST));
        }
        if (redirectUri != null && (redirect = RedirectUtils.verifyRedirectUri(this.uriInfo, redirectUri, this.realm, client)) == null) {
            throw new WebApplicationException(ErrorResponse.error("Invalid redirect uri.", Response.Status.BAD_REQUEST));
        }
        if (lifespan == null) {
            lifespan = this.realm.getActionTokenGeneratedByAdminLifespan();
        }
        int expiration = Time.currentTime() + lifespan;
        ExecuteActionsActionToken token = new ExecuteActionsActionToken(this.user.getId(), expiration, actions, redirectUri, clientId);
        try {
            UriBuilder builder = LoginActionsService.actionTokenProcessor(this.uriInfo);
            builder.queryParam("key", new Object[]{token.serialize(this.session, this.realm, this.uriInfo)});
            String link = builder.build(new Object[]{this.realm.getName()}).toString();
            ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setAttribute("requiredActions", token.getRequiredActions()).setRealm(this.realm).setUser(this.user).sendExecuteActions(link, TimeUnit.SECONDS.toMinutes(lifespan.intValue()));
            this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
            return Response.ok().build();
        }
        catch (EmailException e) {
            ServicesLogger.LOGGER.failedToSendActionsEmail(e);
            return ErrorResponse.error("Failed to send execute actions email", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="send-verify-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response sendVerifyEmail(@QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId) {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.VERIFY_EMAIL.name());
        return this.executeActionsEmail(redirectUri, clientId, null, actions);
    }

    @GET
    @Path(value="groups")
    @NoCache
    @Produces(value={"application/json"})
    public List<GroupRepresentation> groupMembership() {
        this.auth.users().requireView(this.user);
        LinkedList<GroupRepresentation> memberships = new LinkedList<GroupRepresentation>();
        for (GroupModel group : this.user.getGroups()) {
            memberships.add(ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)false));
        }
        return memberships;
    }

    @DELETE
    @Path(value="groups/{groupId}")
    @NoCache
    public void removeMembership(@PathParam(value="groupId") String groupId) {
        this.auth.users().requireManageGroupMembership(this.user);
        GroupModel group = this.session.realms().getGroupById(groupId, this.realm);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.auth.groups().requireManageMembership(group);
        try {
            if (this.user.isMemberOf(group)) {
                this.user.leaveGroup(group);
                this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.GROUP_MEMBERSHIP).representation(ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)true)).resourcePath(this.uriInfo).success();
            }
        }
        catch (ModelException me) {
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(me.getMessage(), MessageFormat.format(messages.getProperty(me.getMessage(), me.getMessage()), me.getParameters()), Response.Status.BAD_REQUEST);
        }
    }

    @PUT
    @Path(value="groups/{groupId}")
    @NoCache
    public void joinGroup(@PathParam(value="groupId") String groupId) {
        this.auth.users().requireManageGroupMembership(this.user);
        GroupModel group = this.session.realms().getGroupById(groupId, this.realm);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.auth.groups().requireManageMembership(group);
        if (!this.user.isMemberOf(group)) {
            this.user.joinGroup(group);
            this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.GROUP_MEMBERSHIP).representation(ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)true)).resourcePath(this.uriInfo).success();
        }
    }
}

