/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.server.SystemExiter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostShutdownHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "shutdown";
    private final DomainController domainController;
    private static final AttributeDefinition RESTART = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"restart", (ModelType)ModelType.BOOLEAN, (boolean)true).setRequired(false)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("shutdown", HostResolver.getResolver("host")).addParameter(RESTART).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setRuntimeOnly().build();

    public HostShutdownHandler(DomainController domainController) {
        this.domainController = domainController;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean restart = RESTART.validateOperation(operation).asBoolean(false);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, final ModelNode operation) throws OperationFailedException {
                AuthorizationResult authorizationResult = context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
                    throw ControllerLogger.ACCESS_LOGGER.unauthorized(operation.get("operation").asString(), PathAddress.pathAddress((ModelNode)operation.get("address")), authorizationResult.getExplanation());
                }
                SystemExiter.logBeforeExit((SystemExiter.ExitLogger)new SystemExiter.ExitLogger(){

                    public void logExit() {
                        HostControllerLogger.ROOT_LOGGER.shuttingDownInResponseToManagementRequest(HostShutdownHandler.getOperationName(operation));
                    }
                });
                if (restart) {
                    HostShutdownHandler.this.domainController.stopLocalHost(10);
                } else {
                    HostShutdownHandler.this.domainController.stopLocalHost();
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private static String getOperationName(ModelNode op) {
        return op.hasDefined("operation") ? op.get("operation").asString() : OPERATION_NAME;
    }
}

