/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AlternativeAttributeCheckHandler;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ClusterConnectionDefinition
extends ModelOnlyResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"cluster-connection");
    public static final SimpleAttributeDefinition ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cluster-connection-address", (ModelType)ModelType.STRING).setXmlName("address")).setDefaultValue(null)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ALLOW_DIRECT_CONNECTIONS_ONLY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"allow-direct-connections-only", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setRequired(false)).setAllowExpression(true)).setAlternatives(new String[]{"discovery-group-name"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CHECK_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"check-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(30000L))).setRequired(false)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CONNECTION_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connection-ttl", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(60000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CONNECTOR_REF = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connector-ref", (ModelType)ModelType.STRING).setRestartAllServices()).build();
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"static-connectors", (ModelType)ModelType.STRING).setRequired(false)).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setXmlName("connector-ref")).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.WrappedListAttributeMarshaller(null))).setAlternatives(new String[]{"discovery-group-name"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition DISCOVERY_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"discovery-group-name", (ModelType)ModelType.STRING).setRequired(false)).setAlternatives(new String[]{ALLOW_DIRECT_CONNECTIONS_ONLY.getName(), CONNECTOR_REFS.getName()})).setAttributeMarshaller(AttributeMarshallers.DISCOVERY_GROUP_MARSHALLER)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition FORWARD_WHEN_NO_CONSUMERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"forward-when-no-consumers", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition INITIAL_CONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-connect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(-1))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MAX_HOPS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-hops", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(1))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MAX_RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(2000L))).setRequired(false)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition NOTIFICATION_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"notification-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(2))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition NOTIFICATION_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"notification-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(1000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(500L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RECONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(-1))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RETRY_INTERVAL_MULTIPLIER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval-multiplier", (ModelType)ModelType.DOUBLE).setDefaultValue(new ModelNode(1.0))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition USE_DUPLICATE_DETECTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-duplicate-detection", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(true))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ADDRESS, CONNECTOR_REF, CHECK_PERIOD, CONNECTION_TTL, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CALL_TIMEOUT, CommonAttributes.CALL_FAILOVER_TIMEOUT, RETRY_INTERVAL, RETRY_INTERVAL_MULTIPLIER, MAX_RETRY_INTERVAL, INITIAL_CONNECT_ATTEMPTS, RECONNECT_ATTEMPTS, USE_DUPLICATE_DETECTION, FORWARD_WHEN_NO_CONSUMERS, MAX_HOPS, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE, NOTIFICATION_ATTEMPTS, NOTIFICATION_INTERVAL, CONNECTOR_REFS, ALLOW_DIRECT_CONNECTIONS_ONLY, DISCOVERY_GROUP_NAME};
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{ADDRESS, ALLOW_DIRECT_CONNECTIONS_ONLY, CHECK_PERIOD, CONNECTION_TTL, FORWARD_WHEN_NO_CONSUMERS, MAX_HOPS, MAX_RETRY_INTERVAL, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, RETRY_INTERVAL, RETRY_INTERVAL_MULTIPLIER, USE_DUPLICATE_DETECTION, CommonAttributes.CALL_TIMEOUT, RECONNECT_ATTEMPTS, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE};
    public static final SimpleAttributeDefinition NODE_ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"node-id", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition TOPOLOGY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"topology", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final ClusterConnectionDefinition INSTANCE = new ClusterConnectionDefinition();

    private ClusterConnectionDefinition() {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("cluster-connection"), new ModelOnlyAddStepHandler(ATTRIBUTES){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                AlternativeAttributeCheckHandler.checkAlternatives(operation, CONNECTOR_REFS.getName(), DISCOVERY_GROUP_NAME.getName(), true);
            }
        }, ATTRIBUTES);
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }
}

