/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParallelBootOperationContext;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

public class ParallelBootOperationStepHandler
implements OperationStepHandler {
    private final Executor executor;
    private final ImmutableManagementResourceRegistration rootRegistration;
    private final ControlledProcessState processState;
    private final OperationStepHandler extraValidationStepHandler;
    private final ModelControllerImpl controller;
    private final int operationId;
    private final Map<String, List<ParsedBootOp>> opsBySubsystem = new LinkedHashMap<String, List<ParsedBootOp>>();
    private ParsedBootOp ourOp;

    ParallelBootOperationStepHandler(ExecutorService executorService, ImmutableManagementResourceRegistration rootRegistration, ControlledProcessState processState, ModelControllerImpl controller, int operationId, OperationStepHandler extraValidationStepHandler) {
        this.executor = executorService;
        this.rootRegistration = rootRegistration;
        this.processState = processState;
        this.controller = controller;
        this.operationId = operationId;
        this.extraValidationStepHandler = extraValidationStepHandler;
    }

    boolean addSubsystemOperation(ParsedBootOp parsedOp) {
        String subsystemName = this.getSubsystemName(parsedOp.address);
        if (subsystemName != null) {
            List<ParsedBootOp> list = this.opsBySubsystem.get(subsystemName);
            if (list == null) {
                list = new ArrayList<ParsedBootOp>();
                this.opsBySubsystem.put(subsystemName, list);
            }
            list.add(parsedOp);
            this.getParsedBootOp().addChildOperation(parsedOp);
        }
        return subsystemName != null;
    }

    ParsedBootOp getParsedBootOp() {
        if (this.ourOp == null) {
            ModelNode op = Util.getEmptyOperation("parallel-subsystem-boot", new ModelNode().setEmptyList());
            this.ourOp = new ParsedBootOp(op, (OperationStepHandler)this);
        }
        return this.ourOp;
    }

    private String getSubsystemName(PathAddress address) {
        String key = null;
        if (address.size() > 0 && "subsystem".equals(address.getElement(0).getKey())) {
            key = address.getElement(0).getValue();
        }
        return key;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!context.isNormalServer()) {
            throw ControllerLogger.ROOT_LOGGER.fullServerBootRequired(this.getClass());
        }
        if (!(context instanceof OperationContextImpl)) {
            throw ControllerLogger.ROOT_LOGGER.operationContextIsNotAbstractOperationContext();
        }
        long start = System.currentTimeMillis();
        OperationContextImpl primaryContext = (OperationContextImpl)context;
        context.getResourceRegistrationForUpdate();
        Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        context.acquireControllerLock();
        LinkedHashMap<String, List<ParsedBootOp>> runtimeOpsBySubsystem = new LinkedHashMap<String, List<ParsedBootOp>>();
        final LinkedHashMap<String, ParallelBootTransactionControl> transactionControls = new LinkedHashMap<String, ParallelBootTransactionControl>();
        CountDownLatch preparedLatch = new CountDownLatch(this.opsBySubsystem.size());
        final CountDownLatch committedLatch = new CountDownLatch(1);
        final CountDownLatch completeLatch = new CountDownLatch(this.opsBySubsystem.size());
        Thread controllingThread = Thread.currentThread();
        SecurityDomain bootSecurityDomain = SecurityDomain.builder().setDefaultRealmName("Empty").addRealm("Empty", SecurityRealm.EMPTY_REALM).build().build();
        for (Map.Entry<String, List<ParsedBootOp>> entry : this.opsBySubsystem.entrySet()) {
            String subsystemName = entry.getKey();
            ArrayList<ParsedBootOp> arrayList = new ArrayList<ParsedBootOp>();
            runtimeOpsBySubsystem.put(subsystemName, arrayList);
            ParallelBootTransactionControl txControl = new ParallelBootTransactionControl(preparedLatch, committedLatch, completeLatch);
            transactionControls.put(entry.getKey(), txControl);
            List<ParsedBootOp> bootOps = entry.getValue();
            ParallelBootOperationContext pboc = bootOps.size() == 0 ? null : this.createOperationContext(primaryContext, bootSecurityDomain, txControl, arrayList);
            ParallelBootTask subsystemTask = new ParallelBootTask(subsystemName, bootOps, OperationContext.Stage.MODEL, txControl, pboc);
            this.executor.execute(subsystemTask);
        }
        try {
            preparedLatch.await();
            this.checkForSubsystemFailures(context, transactionControls, OperationContext.Stage.MODEL);
            List loggingOps = (List)runtimeOpsBySubsystem.remove("logging");
            if (loggingOps != null) {
                for (ParsedBootOp loggingOp : loggingOps) {
                    context.addStep(loggingOp.response, loggingOp.operation, loggingOp.handler, OperationContext.Stage.RUNTIME);
                }
            }
            LinkedHashMap<String, Resource> linkedHashMap = new LinkedHashMap<String, Resource>();
            for (String string : this.opsBySubsystem.keySet()) {
                Resource resource = rootResource.removeChild(PathElement.pathElement("subsystem", string));
                if (resource == null) continue;
                linkedHashMap.put(string, resource);
            }
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                rootResource.registerChild(PathElement.pathElement("subsystem", (String)entry.getKey()), (Resource)entry.getValue());
            }
            context.addStep(this.getRuntimeStep(runtimeOpsBySubsystem, bootSecurityDomain), OperationContext.Stage.RUNTIME);
        }
        catch (InterruptedException e) {
            context.getFailureDescription().set(new ModelNode().set(ControllerLogger.ROOT_LOGGER.subsystemBootInterrupted()));
            Thread.currentThread().interrupt();
        }
        if (ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            ControllerLogger.MGMT_OP_LOGGER.debugf("Ran subsystem model operations in [%d] ms", elapsed);
        }
        context.completeStep(new OperationContext.ResultHandler(){

            @Override
            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                ParallelBootOperationStepHandler.this.notifySubsystemTransactions(transactionControls, resultAction == OperationContext.ResultAction.ROLLBACK, committedLatch, OperationContext.Stage.RUNTIME);
                try {
                    completeLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    private ParallelBootOperationContext createOperationContext(OperationContextImpl primaryContext, SecurityDomain bootSecurityDomain, ParallelBootTransactionControl txControl, List<ParsedBootOp> runtimeOps) {
        return new ParallelBootOperationContext(txControl, this.processState, primaryContext, runtimeOps, this.controller, this.operationId, this.controller.getAuditLogger(), this.extraValidationStepHandler, () -> ((SecurityDomain)bootSecurityDomain).getAnonymousSecurityIdentity());
    }

    private void checkForSubsystemFailures(OperationContext context, Map<String, ParallelBootTransactionControl> transactionControls, OperationContext.Stage stage) {
        boolean failureRecorded = false;
        for (Map.Entry<String, ParallelBootTransactionControl> entry : transactionControls.entrySet()) {
            ParallelBootTransactionControl txControl = entry.getValue();
            if (txControl.transaction == null) {
                String failureDesc = txControl.response.getResponseNode().hasDefined("failure-description") ? txControl.response.getResponseNode().get("failure-description").toString() : ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailed(entry.getKey());
                ControllerLogger.MGMT_OP_LOGGER.error(failureDesc);
                if (failureRecorded) continue;
                context.getFailureDescription().set(failureDesc);
                failureRecorded = true;
                context.setRollbackOnly();
                continue;
            }
            ControllerLogger.MGMT_OP_LOGGER.debugf("Stage %s boot ops for subsystem %s succeeded", (Object)stage, entry.getKey());
        }
    }

    private void notifySubsystemTransactions(Map<String, ParallelBootTransactionControl> transactionControls, boolean rollback, CountDownLatch committedLatch, OperationContext.Stage stage) {
        for (Map.Entry<String, ParallelBootTransactionControl> entry : transactionControls.entrySet()) {
            ParallelBootTransactionControl txControl = entry.getValue();
            if (txControl.transaction == null) continue;
            if (!rollback) {
                txControl.transaction.commit();
                ControllerLogger.MGMT_OP_LOGGER.debugf("Committed transaction for %s subsystem %s stage boot operations", entry.getKey(), (Object)stage);
                continue;
            }
            txControl.transaction.rollback();
            ControllerLogger.MGMT_OP_LOGGER.debugf("Rolled back transaction for %s subsystem %s stage boot operations", entry.getKey(), (Object)stage);
        }
        committedLatch.countDown();
    }

    private OperationStepHandler getRuntimeStep(final Map<String, List<ParsedBootOp>> runtimeOpsBySubsystem, final SecurityDomain bootSecurityDomain) {
        return new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                long start = System.currentTimeMillis();
                if (!(context instanceof OperationContextImpl)) {
                    throw ControllerLogger.ROOT_LOGGER.operationContextIsNotAbstractOperationContext();
                }
                OperationContextImpl primaryContext = (OperationContextImpl)context;
                context.getServiceRegistry(true);
                final LinkedHashMap<String, ParallelBootTransactionControl> transactionControls = new LinkedHashMap<String, ParallelBootTransactionControl>();
                CountDownLatch preparedLatch = new CountDownLatch(runtimeOpsBySubsystem.size());
                final CountDownLatch committedLatch = new CountDownLatch(1);
                final CountDownLatch completeLatch = new CountDownLatch(runtimeOpsBySubsystem.size());
                Thread controllingThread = Thread.currentThread();
                for (Map.Entry entry : runtimeOpsBySubsystem.entrySet()) {
                    String subsystemName = (String)entry.getKey();
                    ParallelBootTransactionControl txControl = new ParallelBootTransactionControl(preparedLatch, committedLatch, completeLatch);
                    transactionControls.put(subsystemName, txControl);
                    List bootOps = (List)entry.getValue();
                    ParallelBootOperationContext pboc = bootOps.size() == 0 ? null : ParallelBootOperationStepHandler.this.createOperationContext(primaryContext, bootSecurityDomain, txControl, null);
                    ParallelBootTask subsystemTask = new ParallelBootTask(subsystemName, bootOps, OperationContext.Stage.RUNTIME, txControl, pboc);
                    ParallelBootOperationStepHandler.this.executor.execute(subsystemTask);
                }
                try {
                    preparedLatch.await();
                    ParallelBootOperationStepHandler.this.checkForSubsystemFailures(context, transactionControls, OperationContext.Stage.RUNTIME);
                }
                catch (InterruptedException e) {
                    context.getFailureDescription().set(new ModelNode().set(ControllerLogger.ROOT_LOGGER.subsystemBootInterrupted()));
                    Thread.currentThread().interrupt();
                }
                if (ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) {
                    long elapsed = System.currentTimeMillis() - start;
                    ControllerLogger.MGMT_OP_LOGGER.debugf("Ran subsystem runtime operations in [%d] ms", elapsed);
                }
                context.completeStep(new OperationContext.ResultHandler(){

                    @Override
                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        ParallelBootOperationStepHandler.this.notifySubsystemTransactions(transactionControls, resultAction == OperationContext.ResultAction.ROLLBACK, committedLatch, OperationContext.Stage.MODEL);
                        try {
                            completeLatch.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                });
            }
        };
    }

    private static class ParallelBootTransactionControl
    implements ProxyController.ProxyOperationControl {
        private final CountDownLatch preparedLatch;
        private final CountDownLatch committedLatch;
        private final CountDownLatch completeLatch;
        private OperationResponse response;
        private ModelController.OperationTransaction transaction;
        private boolean signalled;

        ParallelBootTransactionControl(CountDownLatch preparedLatch, CountDownLatch committedLatch, CountDownLatch completeLatch) {
            this.preparedLatch = preparedLatch;
            this.committedLatch = committedLatch;
            this.completeLatch = completeLatch;
        }

        @Override
        public void operationFailed(ModelNode response) {
            if (!this.signalled) {
                this.response = OperationResponse.Factory.createSimple((ModelNode)response);
                this.preparedLatch.countDown();
                this.completeLatch.countDown();
                this.signalled = true;
            }
        }

        @Override
        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            if (!this.signalled) {
                this.transaction = transaction;
                this.preparedLatch.countDown();
                this.signalled = true;
                try {
                    this.committedLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw ControllerLogger.ROOT_LOGGER.transactionInterrupted();
                }
            }
        }

        @Override
        public void operationCompleted(OperationResponse response) {
            this.response = response;
            this.completeLatch.countDown();
        }
    }

    private class ParallelBootTask
    implements Runnable {
        private final String subsystemName;
        private final List<ParsedBootOp> bootOperations;
        private final OperationContext.Stage executionStage;
        private final ParallelBootTransactionControl transactionControl;
        private final ParallelBootOperationContext pboc;

        ParallelBootTask(String subsystemName, List<ParsedBootOp> bootOperations, OperationContext.Stage executionStage, ParallelBootTransactionControl transactionControl, ParallelBootOperationContext pboc) {
            assert (bootOperations != null || pboc != null);
            this.subsystemName = subsystemName;
            this.bootOperations = bootOperations;
            this.executionStage = executionStage;
            this.transactionControl = transactionControl;
            this.pboc = pboc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block32: {
                block30: {
                    if (this.pboc != null) break block30;
                    this.transactionControl.operationPrepared(new ModelController.OperationTransaction(){

                        @Override
                        public void commit() {
                        }

                        @Override
                        public void rollback() {
                        }
                    }, new ModelNode());
                    if (!this.transactionControl.signalled) {
                        if (this.bootOperations != null) {
                            for (ParsedBootOp op : this.bootOperations) {
                                if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                                this.transactionControl.operationFailed(op.response);
                                break;
                            }
                        }
                        if (!this.transactionControl.signalled) {
                            ModelNode failure = new ModelNode();
                            failure.get("success").set(false);
                            failure.get("failure-description").set(ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailedExecuting(this.subsystemName));
                            this.transactionControl.operationFailed(failure);
                        }
                    } else {
                        this.transactionControl.operationCompleted(this.transactionControl.response);
                    }
                    if (this.pboc != null) {
                        this.pboc.close();
                    }
                    return;
                }
                try {
                    this.pboc.setControllingThread();
                    for (ParsedBootOp op : this.bootOperations) {
                        OperationStepHandler osh = op.handler == null ? ParallelBootOperationStepHandler.this.rootRegistration.getOperationHandler(op.address, op.operationName) : op.handler;
                        this.pboc.addStep(op.response, op.operation, osh, this.executionStage);
                    }
                    this.pboc.executeOperation();
                }
                catch (Error | RuntimeException t) {
                    block31: {
                        try {
                            ControllerLogger.MGMT_OP_LOGGER.failedSubsystemBootOperations(t, this.subsystemName);
                            if (this.transactionControl.signalled) break block31;
                            ModelNode failure = new ModelNode();
                            failure.get("success").set(false);
                            failure.get("failure-description").set(t.toString());
                            this.transactionControl.operationFailed(failure);
                        }
                        catch (Throwable throwable) {
                            if (!this.transactionControl.signalled) {
                                if (this.bootOperations != null) {
                                    for (ParsedBootOp op : this.bootOperations) {
                                        if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                                        this.transactionControl.operationFailed(op.response);
                                        break;
                                    }
                                }
                                if (!this.transactionControl.signalled) {
                                    ModelNode failure = new ModelNode();
                                    failure.get("success").set(false);
                                    failure.get("failure-description").set(ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailedExecuting(this.subsystemName));
                                    this.transactionControl.operationFailed(failure);
                                }
                            } else {
                                this.transactionControl.operationCompleted(this.transactionControl.response);
                            }
                            if (this.pboc != null) {
                                this.pboc.close();
                            }
                            throw throwable;
                        }
                    }
                    if (!this.transactionControl.signalled) {
                        if (this.bootOperations != null) {
                            for (ParsedBootOp op : this.bootOperations) {
                                if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                                this.transactionControl.operationFailed(op.response);
                                break;
                            }
                        }
                        if (!this.transactionControl.signalled) {
                            ModelNode failure = new ModelNode();
                            failure.get("success").set(false);
                            failure.get("failure-description").set(ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailedExecuting(this.subsystemName));
                            this.transactionControl.operationFailed(failure);
                        }
                    } else {
                        this.transactionControl.operationCompleted(this.transactionControl.response);
                    }
                    if (this.pboc != null) {
                        this.pboc.close();
                    }
                    break block32;
                }
                if (!this.transactionControl.signalled) {
                    if (this.bootOperations != null) {
                        for (ParsedBootOp op : this.bootOperations) {
                            if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                            this.transactionControl.operationFailed(op.response);
                            break;
                        }
                    }
                    if (!this.transactionControl.signalled) {
                        ModelNode failure = new ModelNode();
                        failure.get("success").set(false);
                        failure.get("failure-description").set(ControllerLogger.ROOT_LOGGER.subsystemBootOperationFailedExecuting(this.subsystemName));
                        this.transactionControl.operationFailed(failure);
                    }
                } else {
                    this.transactionControl.operationCompleted(this.transactionControl.response);
                }
                if (this.pboc != null) {
                    this.pboc.close();
                }
            }
        }
    }
}

