/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsServiceConfigurator;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Version;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.IdentityServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.spi.CapabilityServiceNameRegistry;
import org.wildfly.clustering.spi.IdentityGroupServiceConfiguratorProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class JGroupsSubsystemServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        JGroupsLogger.ROOT_LOGGER.activatingSubsystem(Version.printVersion());
        ServiceTarget target = context.getServiceTarget();
        PathAddress address = context.getCurrentAddress();
        if (context.getProcessType().isServer() && !context.isBooting() && context.readResourceFromRoot(address.getParent(), false).hasChild(PathElement.pathElement((String)"subsystem", (String)"infinispan"))) {
            context.addStep((ctx, operation) -> {
                ctx.reloadRequired();
                ctx.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
            }, OperationContext.Stage.RUNTIME);
            return;
        }
        new ProtocolDefaultsServiceConfigurator().build(target).install();
        String defaultChannel = JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        if (defaultChannel != null) {
            for (Map.Entry<JGroupsRequirement, Capability> entry : JGroupsSubsystemResourceDefinition.CAPABILITIES.entrySet()) {
                new IdentityServiceConfigurator(entry.getValue().getServiceName(address), entry.getKey().getServiceName(context, defaultChannel)).build(target).install();
            }
            if (!defaultChannel.equals("default")) {
                new BinderServiceConfigurator(JGroupsBindingFactory.createChannelBinding("default"), JGroupsRequirement.CHANNEL.getServiceName(context, defaultChannel)).build(target).install();
                new BinderServiceConfigurator(JGroupsBindingFactory.createChannelFactoryBinding("default"), JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, defaultChannel)).build(target).install();
            }
            CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(JGroupsSubsystemResourceDefinition.CLUSTERING_CAPABILITIES, address);
            for (IdentityGroupServiceConfiguratorProvider provider : ServiceLoader.load(IdentityGroupServiceConfiguratorProvider.class, IdentityGroupServiceConfiguratorProvider.class.getClassLoader())) {
                for (CapabilityServiceConfigurator configurator : provider.getServiceConfigurators((ServiceNameRegistry)registry, null, defaultChannel)) {
                    configurator.configure(context).build(target).install();
                }
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String defaultChannel = JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        if (defaultChannel != null) {
            CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(JGroupsSubsystemResourceDefinition.CLUSTERING_CAPABILITIES, address);
            for (IdentityGroupServiceConfiguratorProvider provider : ServiceLoader.load(IdentityGroupServiceConfiguratorProvider.class, IdentityGroupServiceConfiguratorProvider.class.getClassLoader())) {
                for (ServiceNameProvider configurator : provider.getServiceConfigurators((ServiceNameRegistry)registry, null, defaultChannel)) {
                    context.removeService(configurator.getServiceName());
                }
            }
            if (!defaultChannel.equals("default")) {
                context.removeService(JGroupsBindingFactory.createChannelFactoryBinding("default").getBinderServiceName());
                context.removeService(JGroupsBindingFactory.createChannelBinding("default").getBinderServiceName());
            }
            for (Capability capability : JGroupsSubsystemResourceDefinition.CAPABILITIES.values()) {
                context.removeService(capability.getServiceName(address));
            }
        }
        context.removeService(ProtocolDefaultsServiceConfigurator.SERVICE_NAME);
    }
}

